---
name: brave-api-setup
description: Set up Brave Search API for OpenClaw web_search. Use when user needs to configure Brave API, get Brave API key, enable web search, or fix "missing_brave_api_key" error.
metadata:
  openclaw:
    requires:
      bins: ["node"]
    triggers:
      - Brave Search
      - brave api
      - web_search
      - missing_brave_api_key
      - search API
---

# Brave API Setup

Automates Brave Search API key extraction and OpenClaw configuration.

## Included Files

| File | Description |
|------|-------------|
| `SKILL.md` | This document |
| `scripts/apply-api-key.js` | Applies API key to OpenClaw config (Node.js) |

## Dependencies
- Node.js (for apply-api-key.js)
- OpenClaw browser capability (`browser` tool)

## When to Use

- User wants to enable `web_search` in OpenClaw
- Error: `missing_brave_api_key`
- User asks to set up Brave Search API

## Prerequisites

- User must have a Brave Search API account
- User must be logged in (openclaw browser profile)
- API key must exist in dashboard

## Workflow

### Step 1: Navigate to API keys page

```
browser(action="navigate", profile="openclaw", 
        targetUrl="https://api-dashboard.search.brave.com/app/keys")
```

### Step 2: Click reveal button (eye icon)

Take snapshot, find the reveal button, click it:
```
browser(action="act", kind="click", ref="<eye-button-ref>")
```

### Step 3: Extract key via JavaScript (avoids LLM transcription error)

```
browser(action="act", kind="evaluate", 
        fn="(() => { const cells = document.querySelectorAll('td'); for (const cell of cells) { const text = cell.textContent?.trim(); if (text && text.startsWith('BSA') && !text.includes('•') && text.length > 20) return text; } return null; })()")
```

The result field contains the exact API key.

### Step 4: Apply to config (direct file write, no LLM involved)

Relative to skill directory:

```bash
node <skill_dir>/scripts/apply-api-key.js "<extracted-key>"
```

Or use gateway config.patch with the extracted key.

## Why This Approach

**Problem**: LLM can confuse similar characters when transcribing (O vs 0, l vs 1).

**Solution**: 
1. `evaluate` extracts key via JavaScript → returns exact string
2. `apply-api-key.js` writes directly to config → bit-perfect

The key never passes through LLM text generation.

## Manual Account Setup

If user doesn't have an account:
1. Go to https://api-dashboard.search.brave.com
2. Sign up with email
3. Subscribe to Free plan (requires credit card)
4. Create API key in dashboard
5. Then run this skill

## 문의 / Feedback

버그 리포트, 기능 요청, 피드백은 아래로 보내주세요.
- Email: contact@garibong.dev
- Developer: Garibong Labs (가리봉랩스)
