---
name: Branding
description: Build distinctive brand identity with clear positioning, voice, and visual consistency.
metadata: {"clawdbot":{"emoji":"✨","os":["linux","darwin","win32"]}}
---

## Discovery Questions (Ask First)

- What does the product/service actually do? In one sentence.
- Who is the specific customer? Job title, situation, pain.
- What alternatives exist? Direct competitors, indirect solutions, doing nothing.
- Why would someone choose this over alternatives? The real reason.
- What words should customers use to describe you? Pick 3-5.
- What words should they NOT use? 3-5 anti-traits.

## Positioning Statement (Produce This)

Fill in and refine until crisp:
"For [specific audience] who [specific need], [brand] is the [category] that [unique benefit] because [reason to believe]."

Test: Can you say it out loud without cringing? Would customer nod in recognition?

## Brand Voice (Define Precisely)

Create a 2x2 for each trait:
| We are | We are not |
|--------|------------|
| Confident | Arrogant |
| Direct | Rude |
| Playful | Silly |

For each trait, write 3 example sentences showing how it sounds.
Write 3 sentences that violate it—what to avoid.

## Naming Checklist

Before falling in love with a name:
- [ ] .com domain available (or reasonable alternative)
- [ ] Primary social handles available (@name)
- [ ] No trademark conflicts in your category
- [ ] Passes the phone test—spell it over a call
- [ ] No negative meanings in Spanish, Chinese, common languages
- [ ] Fits in a logo, looks good written

## Tagline Formula

Pick one structure:
- Benefit statement: "Move money for free"
- Challenge: "Think different"
- Promise: "15 minutes could save you 15%"
- Category + twist: "The un-agency"

Max 6 words. Test: Would someone repeat this to a friend?

## Visual Direction Brief

Specify before any design:
- Mood: 3 reference brands with right feeling (not competitors)
- Color direction: warm/cool, vibrant/muted, primary color family
- Typography feel: modern/classic, geometric/humanist, bold/light
- Imagery style: photo/illustration, people/abstract, lifestyle/product
- Avoid: specific styles, colors, or approaches that feel wrong

## Logo Requirements

Define constraints:
- Must work at 16px favicon size
- Must work in single color (black, white)
- Wordmark, symbol, or combination?
- Horizontal and square versions needed?

## Consistency System

Create these assets:
- Color palette: 1 primary, 2-3 secondary, 2-3 neutrals with exact codes
- Type scale: specific sizes for H1, H2, H3, body, caption
- Spacing scale: 4, 8, 16, 24, 32, 48, 64px (or similar)
- Component examples: how a button, card, input looks

## Brand Guidelines Document

Minimum contents:
1. Positioning statement + story
2. Voice traits with examples
3. Logo files + usage rules (clear space, minimum size, backgrounds)
4. Color palette with all codes (HEX, RGB)
5. Typography with font files or links
6. Do's and Don'ts gallery

## Quality Check

Before finalizing, verify:
- [ ] Could a stranger create on-brand content from these guidelines?
- [ ] Is it different enough from top 3 competitors?
- [ ] Does it resonate with 3 real people in target audience?
- [ ] Is every element intentional, not arbitrary?
- [ ] Can you apply it consistently across: website, email, social, product UI?

## Common Failures to Avoid

- "We're like X but for Y" without being distinctive—lazy positioning
- Voice traits that any brand would claim—"friendly, professional"
- Logo that only works on white backgrounds—fails in real use
- Colors picked for taste without checking accessibility contrast
- Guidelines too long to read—no one follows 50-page brand books
