# 品牌监控 Skill - 快速参考

## 🚀 立即开始（1 分钟）

```bash
cd brand-monitor-skill/crawler
python search_crawler_serpapi.py "理想汽车" "weibo,zhihu" 5 24 --mock
```

## 📋 核心命令

### 测试爬虫（Mock 模式）

```bash
python search_crawler_serpapi.py "理想汽车" "weibo,xiaohongshu,zhihu" 10 24 --mock
```

### 真实搜索（需要 API Key）

```bash
export SERPAPI_KEY='your_key'
python search_crawler_serpapi.py "理想汽车" "weibo,xiaohongshu,zhihu" 10 24
```

### 运行监控

```bash
openclaw agent --message "执行品牌监控"
```

## 📁 重要文件

| 文件 | 说明 |
|------|------|
| `README.md` | 主文档 |
| `使用指南-SerpAPI版.md` | 详细使用指南 |
| `crawler/SerpAPI使用指南.md` | 技术文档 |
| `config.example.json` | 配置示例 |

## 🎯 支持的平台

```
weibo, xiaohongshu, zhihu, autohome, 
dongchedi, yiche, tieba, douyin, kuaishou
```

## 💰 成本

| 方案 | 成本 | 限制 |
|------|------|------|
| Mock 模式 | $0 | 无限制 |
| SerpAPI 免费 | $0 | 100次/月 |
| SerpAPI 付费 | $50/月 | 5000次/月 |

## 🔧 配置

### 环境变量

```bash
export SERPAPI_KEY='your_api_key'
export SERPAPI_ENGINE='google'  # 可选: baidu, bing
```

### 最小配置

```json
{
  "brand_name": "理想汽车",
  "feishu_webhook": "https://open.feishu.cn/open-apis/bot/v2/hook/你的webhook"
}
```

## 🐛 故障排查

### API Key 未设置
```bash
export SERPAPI_KEY='your_key'
```

### 配额用完
- 使用 Mock 模式：`--mock`
- 升级计划：https://serpapi.com/pricing

### 搜索无结果
- 扩大时间范围
- 使用更通用的关键词

## 🔗 链接

- **获取 API Key：** https://serpapi.com/
- **Dashboard：** https://serpapi.com/dashboard
- **文档：** https://serpapi.com/docs

## ✅ 测试清单

- [ ] 安装依赖：`./install.sh`
- [ ] 测试 Mock 模式
- [ ] 获取 SerpAPI Key
- [ ] 设置环境变量
- [ ] 配置 Skill
- [ ] 运行监控
- [ ] 验证飞书推送

---

**需要帮助？** 查看 `README.md` 或 `使用指南-SerpAPI版.md`
