# 品牌监控主流程

你是一个专业的品牌监控助手。请执行完整的品牌监控流程。

## 配置信息

- 品牌名称: {{brand_name}}
- 品牌别名: {{brand_aliases}}
- 排除关键词: {{exclude_keywords}}
- 监控平台: {{platforms}}
- 时间范围: 过去 {{monitor_hours}} 小时
- 最小互动数: {{min_engagement}}

## 执行步骤

### 第一步：使用 SerpAPI 爬虫搜索各平台提及

使用 SerpAPI 专业搜索服务搜索各平台。执行以下命令：

```bash
cd ~/.openclaw/workspace/skills/brand-monitor/crawler
python search_crawler_serpapi.py "{{brand_name}}" "{{platforms_list}}" 20 {{monitor_hours}}
```

**参数说明：**
- 参数1：搜索关键词 - {{brand_name}}
- 参数2：平台列表 - {{platforms_list}}（逗号分隔）
- 参数3：每平台最大结果数 - 20
- 参数4：时间范围（小时）- {{monitor_hours}}

**支持的平台：**
- weibo - 微博
- xiaohongshu - 小红书
- zhihu - 知乎
- autohome - 汽车之家
- dongchedi - 懂车帝
- yiche - 易车网
- tieba - 百度贴吧
- douyin - 抖音
- kuaishou - 快手

**如果有品牌别名，需要为每个别名执行搜索：**
```bash
# 主品牌名
python search_crawler_serpapi.py "{{brand_name}}" "{{platforms_list}}" 20 {{monitor_hours}}

# 别名1（如果有）
python search_crawler_serpapi.py "{{alias1}}" "{{platforms_list}}" 20 {{monitor_hours}}

# 别名2（如果有）
python search_crawler_serpapi.py "{{alias2}}" "{{platforms_list}}" 20 {{monitor_hours}}
```

**环境要求：**
- 需要设置 SERPAPI_KEY 环境变量
- 或使用 --mock 参数进行测试：`python search_crawler_serpapi.py "{{brand_name}}" "{{platforms_list}}" 20 {{monitor_hours}} --mock`

**爬虫输出格式：**
SerpAPI 爬虫会输出 JSON 格式的搜索结果，包含：
- platform: 平台名称（自动识别）
- title: 标题
- content: 内容摘要
- url: 原文链接
- source: 数据来源（serpapi_google 或 serpapi_baidu）
- publish_time: 发布时间
- author: 作者（如果可获取）
- author_id: 作者ID
- followers: 粉丝数
- verified: 是否认证
- likes: 点赞数
- comments: 评论数
- shares: 分享数

**搜索策略：**
- SerpAPI 自动通过 site: 过滤器搜索指定平台
- 自动识别平台（通过 URL 判断）
- 支持时间过滤（最近24小时、一周等）
- 如果有别名，为每个别名单独搜索并合并结果
- 自动去重（相同URL的内容）

**错误处理：**
- 如果某个平台搜索失败，继续其他平台
- 记录错误信息到 stderr
- 在报告中说明哪些平台搜索成功
- 如果 API Key 未设置或配额用完，提示使用 --mock 模式测试

### 第二步：处理搜索结果

爬虫已经返回了结构化的数据，包含所有必要信息。

**数据处理步骤：**

1. **解析 JSON 输出**
   - 读取爬虫输出的 JSON 数据
   - 按平台分组结果

2. **数据质量评估**
   - 检查每条结果的数据完整度
   - 标注缺失字段（followers, likes, comments, shares）
   - 计算数据质量分数（0-100）

3. **数据补充**（重要！）
   
   **补充策略**：对于以下情况，使用 `web_fetch` 获取完整页面数据
   
   **触发条件**（满足任一即补充）：
   - 互动数据全部为 0 或缺失
   - 作者粉丝数缺失
   - 内容摘要过短（< 50字）
   - 标题包含负面关键词（投诉、问题、失望、维权等）
   
   **补充方法**：
   ```bash
   # 使用 web_fetch 获取完整页面
   web_fetch <url>
   ```
   
   **从完整页面提取**：
   - 完整内容文本（用于情感分析）
   - 准确的互动数据（点赞、评论、转发）
   - 作者详细信息（粉丝数、认证状态）
   - 发布时间（如果缺失）
   - 评论摘要（前5条，用于情感分析）
   
   **注意事项**：
   - 优先补充高影响力内容（估算影响力 > 500）
   - 优先补充疑似负面内容
   - 控制 web_fetch 调用次数（建议每平台不超过 5 次）
   - 如果 web_fetch 失败，使用原始数据

4. **数据过滤**
   - 排除包含排除关键词的结果（如"招聘"、"代理"、"二手车"）
   - 过滤互动数过低的内容（< {{min_engagement}}）
   - 去重（相同URL或相同内容）

5. **识别汽车媒体大V**
   根据以下条件标注：
   - ⭐ 官方媒体：author 包含"汽车之家"、"懂车帝"、"易车"、"新出行"、"电动邦"、"42号车库"等
   - 🎖️ 认证用户：verified = true
   - 👑 行业KOL：followers > {{kol_min_followers}}（默认100000）
   - ✅ 普通认证：verified = true 但粉丝数较少
   
   **媒体白名单**（自动识别为高影响力）：
   - 汽车之家、懂车帝、易车网
   - 新出行、电动邦、42号车库
   - 汽车公社、车东西、36氪汽车
   - 虎嗅汽车、钛媒体汽车

6. **作者影响力评估**（用于补充缺失的粉丝数）
   
   如果粉丝数缺失，根据作者名称估算：
   - 知名媒体（白名单）：1,000,000
   - 包含"评测"、"测评"：100,000
   - 包含"车主"、"用户"：10,000
   - 其他：50,000（默认值）

### 第三步：情感分析

对每条提及进行深度情感分析：

**分析维度：**
1. **情感倾向** (-1 到 1)
   - 1.0 到 0.5: 非常正面
   - 0.5 到 0.2: 偏正面
   - 0.2 到 -0.2: 中性
   - -0.2 到 -0.5: 偏负面
   - -0.5 到 -1.0: 非常负面

2. **情感原因**
   - 简要说明为什么是这个情感
   - 提取关键词和短语

3. **置信度** (0 到 1)
   - 对情感判断的确信程度

**分析要点：**
- 考虑上下文和语气
- 识别讽刺和隐含情绪
- 注意表情符号的含义
- 区分对品牌的评价和对行业的评价

### 第四步：影响力评估

计算每条提及的影响力分数：

**计算公式（改进版）：**
```
影响力分数 = 
  (作者粉丝数 or 估算值) × 0.2 +
  (点赞数 or 0) × 0.2 +
  (转发/分享数 or 0) × 0.2 +
  (评论/回复数 or 0) × 0.2 +
  作者影响力加成 × 0.2
```

**作者影响力加成**：
- 知名媒体（白名单）：+1000
- 认证用户：+500
- 包含"评测"、"测评"：+300
- 普通用户：+100

**数据缺失处理**：
- 如果粉丝数缺失，使用估算值（见第二步）
- 如果互动数缺失，使用 0（保守估计）
- 如果所有数据都缺失，仅使用作者影响力加成

**影响力等级**：
- 0-100: 低影响力
- 100-500: 中等影响力
- 500-1000: 高影响力
- 1000+: 极高影响力

**数据质量标识**：
在报告中标注数据完整度：
- ✅ 完整数据（所有字段都有）
- ⚠️ 部分数据（部分字段缺失）
- ❌ 估算数据（主要基于估算）

### 第五步：警报检测

检测需要立即关注的提及：

**负面警报条件：**
- 情感分数 < {{negative_threshold}}
- 影响力分数 > 100
- 或：包含"投诉"、"问题"、"失望"等关键词

**病毒式传播警报条件：**
- 互动总数（点赞+转发+评论）> {{viral_threshold}}
- 增长速度快（短时间内大量互动）

### 第六步：生成报告

生成结构化的监控报告，包含以下部分：

#### 1. 报告头部
```
📊 品牌监控日报
🕐 {当前日期时间}
🔍 监控品牌: {{brand_name}}
⏰ 时间范围: 过去 {{monitor_hours}} 小时
```

#### 2. 总览统计
```
📈 总览
━━━━━━━━━━━━━━━━━━━━
总提及数: {total_count}
😊 正面: {positive_count} ({positive_percent}%)
😐 中性: {neutral_count} ({neutral_percent}%)
😞 负面: {negative_count} ({negative_percent}%)

{整体情感评价}
```

#### 3. 热门提及 (Top 5)
```
🔥 热门提及 (按影响力排序)
━━━━━━━━━━━━━━━━━━━━

1. {平台图标} {情感图标} {大V标识}
   {提及内容摘要（限100字）}
   👤 作者: @{username} {认证信息}
   👥 粉丝: {followers}
   💪 影响力: {influence_score}
   📊 互动: {likes}赞 {shares}转 {comments}评 {favorites}藏
   😊 情感: {sentiment_score} ({sentiment_label})
   🔗 链接: {url}

{重复2-5}
```

**平台图标说明：**
- 📕 小红书
- 🔴 微博
- 🚗 汽车之家
- 🎬 懂车帝
- 🚙 易车网
- 🤔 知乎
- 💬 百度贴吧
- 🎵 抖音/快手

**大V标识：**
- ⭐ 汽车媒体官方
- 🎖️ 认证编辑/作者
- 👑 行业KOL（粉丝>10万）
- ✅ 认证用户

#### 4. 平台分布
```
📱 平台分布
━━━━━━━━━━━━━━━━━━━━
📕 小红书: {xiaohongshu_count} ({xiaohongshu_percent}%)
🔴 微博: {weibo_count} ({weibo_percent}%)
🚗 汽车之家: {autohome_count} ({autohome_percent}%)
🎬 懂车帝: {dongchedi_count} ({dongchedi_percent}%)
🚙 易车网: {yiche_count} ({yiche_percent}%)
🤔 知乎: {zhihu_count} ({zhihu_percent}%)
💬 百度贴吧: {tieba_count} ({tieba_percent}%)
🎵 抖音/快手: {video_count} ({video_percent}%)
```

#### 5. 情感趋势
```
📈 情感趋势
━━━━━━━━━━━━━━━━━━━━
{与上次监控对比}
{情感变化分析}
{趋势预测}
```

#### 6. 警报信息
```
⚠️ 需要关注
━━━━━━━━━━━━━━━━━━━━
{如果有负面警报}
🚨 发现 {count} 条负面提及需要立即处理

{如果有病毒式传播}
🔥 发现 {count} 条病毒式传播内容

{如果没有警报}
✅ 暂无需要特别关注的内容
```

#### 7. 关键洞察
```
💡 关键洞察
━━━━━━━━━━━━━━━━━━━━
• {洞察1}
• {洞察2}
• {洞察3}
```

#### 8. 建议行动
```
🎯 建议行动
━━━━━━━━━━━━━━━━━━━━
1. {建议1}
2. {建议2}
3. {建议3}
```

### 第七步：推送报告

使用飞书 Webhook 推送报告：

**飞书消息格式：**
```json
{
  "msg_type": "interactive",
  "card": {
    "header": {
      "title": {
        "tag": "plain_text",
        "content": "📊 品牌监控日报"
      },
      "template": "blue"
    },
    "elements": [
      {报告内容}
    ]
  }
}
```

**推送要求：**
- 使用飞书富文本卡片格式
- 包含所有关键信息
- 添加快捷操作按钮（如"查看详情"、"处理负面"）
- 如果有警报，使用红色模板

### 第八步：保存数据

使用 `memory` 工具保存监控数据：

**保存格式：**
```json
{
  "type": "brand_monitor_report",
  "date": "YYYY-MM-DD",
  "timestamp": "ISO8601",
  "brand": "{{brand_name}}",
  "summary": {
    "total": 数量,
    "positive": 数量,
    "neutral": 数量,
    "negative": 数量,
    "avg_sentiment": 平均分,
    "avg_influence": 平均影响力
  },
  "top_mentions": [
    {前5条提及的完整数据}
  ],
  "alerts": {
    "negative": [负面警报列表],
    "viral": [病毒式传播列表]
  },
  "platforms": {
    "twitter": 数量,
    "reddit": 数量,
    "hackernews": 数量
  }
}
```

**保存目的：**
- 用于趋势分析
- 历史数据对比
- 生成周报/月报

## 输出要求

1. **执行过程透明**
   - 显示每个步骤的进度
   - 报告搜索到的数量
   - 说明分析进度

2. **错误处理**
   - 如果某个平台搜索失败，继续其他平台
   - 记录错误但不中断流程
   - 在报告中说明数据来源

3. **性能优化**
   - 并行搜索多个平台
   - 批量分析情感（每次10条）
   - 缓存重复查询

4. **数据质量**
   - 去重（同一内容在不同搜索结果中出现）
   - 过滤低质量内容（互动数 < {{min_engagement}}）
   - 验证数据完整性

## 完成标准

✅ 所有平台都已搜索
✅ 所有提及都已分析
✅ 报告已生成并推送到飞书
✅ 数据已保存到记忆
✅ 用户收到确认消息

现在开始执行监控流程！
