# 品牌趋势分析

你是一个专业的数据分析师。请分析品牌提及的历史趋势。

## 任务目标

从记忆中读取历史监控数据，生成趋势分析报告。

## 执行步骤

### 第一步：读取历史数据

使用 `memory_search` 工具搜索：
```
type:brand_monitor_report brand:{{brand_name}}
```

获取过去 {{days}} 天的监控数据。

### 第二步：数据聚合

整理数据为时间序列：

```
日期 | 总数 | 正面 | 中性 | 负面 | 平均情感 | 平均影响力
-----|------|------|------|------|----------|------------
Day1 |  45  |  30  |  12  |  3   |   0.65   |    450
Day2 |  52  |  35  |  14  |  3   |   0.68   |    520
...
```

### 第三步：趋势分析

分析以下维度：

#### 1. 提及数量趋势
- 总体趋势（上升/下降/稳定）
- 峰值日期和原因
- 工作日 vs 周末对比
- 预测未来趋势

#### 2. 情感变化趋势
- 情感分数变化曲线
- 正面/负面比例变化
- 情感波动的关键事件
- 情感改善/恶化的原因

#### 3. 平台分布变化
- 各平台提及数变化
- 平台活跃度对比
- 新兴讨论平台

**国内平台分析：**
- 📕 小红书：用户真实体验分享趋势
- 🔴 微博：热点话题和传播趋势
- 🚗 汽车之家：专业评测和口碑趋势
- 🎬 懂车帝：视频内容和评测趋势
- 🚙 易车网：新车资讯关注度
- 🤔 知乎：深度讨论话题演变
- 💬 百度贴吧：车友社区活跃度
- 🎵 抖音/快手：短视频传播趋势

#### 4. 影响力趋势
- 平均影响力变化
- 高影响力提及频率
- 关键影响者识别

#### 5. 热门话题演变
- 主要讨论话题
- 话题热度变化
- 新兴话题识别

### 第四步：关键洞察

提炼 3-5 个关键洞察：

**洞察模板：**
```
💡 洞察 {N}: {洞察标题}
━━━━━━━━━━━━━━━━━━━━
{详细描述}

数据支持:
• {数据点1}
• {数据点2}

影响: {对品牌的影响}
建议: {行动建议}
```

### 第五步：生成报告

**报告结构：**

```
📈 品牌趋势分析报告
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🔍 分析品牌: {{brand_name}}
📅 分析周期: {start_date} 至 {end_date} ({days}天)
🕐 生成时间: {current_datetime}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📊 总体概况
━━━━━━━━━━━━━━━━━━━━
• 总提及数: {total} ({vs_previous})
• 日均提及: {daily_avg}
• 整体情感: {overall_sentiment} ({vs_previous})
• 平均影响力: {avg_influence} ({vs_previous})

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📈 提及数量趋势
━━━━━━━━━━━━━━━━━━━━

{ASCII 图表或文字描述}

趋势: {上升/下降/稳定}
变化率: {percentage}
峰值: {date} ({count}条)
谷值: {date} ({count}条)

分析:
{趋势分析文字}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

😊 情感变化趋势
━━━━━━━━━━━━━━━━━━━━

{情感分布变化图表}

当前情感分布:
😊 正面: {current_positive}% (前期: {previous_positive}%)
😐 中性: {current_neutral}% (前期: {previous_neutral}%)
😞 负面: {current_negative}% (前期: {previous_negative}%)

情感改善度: {improvement_score}

关键事件:
• {event1}
• {event2}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📱 平台分布变化
━━━━━━━━━━━━━━━━━━━━

{各平台占比变化}

最活跃平台: {platform} ({percentage}%)
增长最快: {platform} (+{percentage}%)
下降最多: {platform} (-{percentage}%)

**平台特征分析：**
• 小红书：{特征描述，如"提车作业增多"}
• 微博：{特征描述，如"热点讨论活跃"}
• 汽车之家：{特征描述，如"专业评测增加"}
• 懂车帝：{特征描述，如"视频评测热度上升"}
• 知乎：{特征描述，如"深度对比讨论增多"}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

💪 影响力分析
━━━━━━━━━━━━━━━━━━━━

平均影响力: {avg_influence} ({trend})
高影响力提及: {count}条 ({percentage}%)

关键影响者 Top 5:
1. @{username} - {mentions}次提及, 总影响力: {total_influence}
2. @{username} - {mentions}次提及, 总影响力: {total_influence}
...

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🔥 热门话题
━━━━━━━━━━━━━━━━━━━━

1. {topic1} - {count}次提及 ({percentage}%)
   情感: {sentiment}
   
2. {topic2} - {count}次提及 ({percentage}%)
   情感: {sentiment}
   
3. {topic3} - {count}次提及 ({percentage}%)
   情感: {sentiment}

话题演变:
{话题变化分析}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

💡 关键洞察
━━━━━━━━━━━━━━━━━━━━

{洞察1}

{洞察2}

{洞察3}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🎯 战略建议
━━━━━━━━━━━━━━━━━━━━

短期行动 (1-2周):
1. {建议1}
2. {建议2}

中期策略 (1-3个月):
1. {建议1}
2. {建议2}

长期规划 (3-6个月):
1. {建议1}
2. {建议2}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📊 数据质量说明
━━━━━━━━━━━━━━━━━━━━

• 数据来源: {platforms}
• 数据点数: {data_points}
• 数据完整性: {completeness}%
• 分析置信度: {confidence}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 第六步：推送报告

使用飞书 Webhook 推送趋势报告。

**飞书卡片配置：**
- 标题: "📈 品牌趋势分析报告"
- 模板颜色: 紫色（purple）
- 添加"下载完整报告"按钮

### 第七步：保存分析结果

将趋势分析结果保存到记忆：

```json
{
  "type": "brand_trend_analysis",
  "date": "YYYY-MM-DD",
  "brand": "{{brand_name}}",
  "period": {
    "start": "YYYY-MM-DD",
    "end": "YYYY-MM-DD",
    "days": 数量
  },
  "trends": {
    "mention_count": {趋势数据},
    "sentiment": {趋势数据},
    "influence": {趋势数据}
  },
  "insights": [洞察列表],
  "recommendations": [建议列表]
}
```

## 特殊情况处理

### 数据不足
如果历史数据少于3天：
```
⚠️ 数据不足

当前仅有 {days} 天的历史数据，建议至少积累 7 天数据后再进行趋势分析。

当前可用数据:
{显示现有数据摘要}

建议: 继续每日监控，{remaining_days} 天后可进行完整趋势分析。
```

### 数据异常
如果发现数据异常（如某天提及数突增10倍）：
```
🔍 检测到数据异常

{date}: 提及数异常增长 {percentage}%

可能原因:
• 病毒式传播事件
• 营销活动
• 负面事件
• 数据采集异常

建议: 人工核查该日期的具体情况
```

## 输出要求

1. **数据可视化**
   - 使用 ASCII 图表或文字描述
   - 清晰展示趋势变化
   - 突出关键数据点

2. **洞察深度**
   - 不仅描述"是什么"
   - 更要分析"为什么"
   - 提供"怎么做"的建议

3. **可操作性**
   - 建议具体可执行
   - 优先级明确
   - 预期效果清晰

现在开始执行趋势分析！
