# 实时警报检测

你是一个警报系统。请立即检测需要关注的品牌提及。

## 任务目标

快速搜索最新提及，识别紧急情况，立即推送警报。

## 执行步骤

### 第一步：快速搜索

使用 SerpAPI 爬虫快速搜索最新提及（过去 {{alert_hours}} 小时）：

```bash
cd ~/.openclaw/workspace/skills/brand-monitor/crawler
python search_crawler_serpapi.py "{{brand_name}}" "weibo,xiaohongshu,autohome,zhihu" 10 {{alert_hours}}
```

**参数说明：**
- 参数1：搜索关键词 - {{brand_name}}
- 参数2：平台列表 - weibo,xiaohongshu,autohome,zhihu
- 参数3：每平台最大结果数 - 10（快速模式）
- 参数4：时间范围（小时）- {{alert_hours}}

**搜索优先级（按传播速度和影响力）：**
1. weibo - 微博（传播最快，影响力最大）
2. xiaohongshu - 小红书（用户真实体验）
3. autohome - 汽车之家（专业讨论）
4. zhihu - 知乎（深度分析）

**快速模式特点：**
- 每平台只获取最新 10 条
- 时间范围：{{alert_hours}} 小时
- SerpAPI 自动按时间排序
- 优先返回最新内容

### 第二步：快速筛选

只关注以下类型的提及：

#### 类型 A：负面提及
- 包含负面关键词：投诉、问题、失望、糟糕、差评、退订、维权
- 新能源汽车特定问题：续航虚标、充电故障、电池衰减、自燃、断轴、异响
- 情感分数 < {{negative_threshold}}
- 影响力 > 100

#### 类型 B：病毒式传播
- 互动数（点赞+转发+评论+收藏）> {{viral_threshold}}
- 增长速度快（1小时内增长 > 50%）
- 来自高影响力账号（汽车媒体、大V、认证用户）
- 来自汽车媒体官方账号

#### 类型 C：危机信号
- 包含危机关键词：安全、召回、自燃、爆炸、事故、起火、泄露、诉讼、维权、集体投诉
- 多个用户同时提及相同问题（3个以上）
- 汽车媒体账号报道负面新闻
- 监管部门介入相关话题

### 第三步：紧急分析

对筛选出的提及进行快速分析：

**分析内容：**
1. 情感分数和原因
2. 影响力评估
3. 紧急程度（1-5级）
4. 潜在影响范围
5. 建议响应策略

**紧急程度评级：**
- 🔴 5级：危机事件，需要立即公关响应
- 🟠 4级：严重负面，需要当天处理
- 🟡 3级：中等负面，需要24小时内回应
- 🔵 2级：轻微负面，需要关注
- ⚪ 1级：仅供参考

### 第四步：生成警报

**警报格式：**

```
🚨 品牌监控警报
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

⚠️ 警报类型: {类型}
🔴 紧急程度: {级别}
🕐 发现时间: {timestamp}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📝 提及内容
━━━━━━━━━━━━━━━━━━━━

{完整内容或摘要}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📊 详细信息
━━━━━━━━━━━━━━━━━━━━

平台: {platform}
作者: @{username} {认证标识}
粉丝: {followers}
发布时间: {post_time}

互动数据:
• 点赞: {likes}
• 转发: {shares}
• 评论: {comments}
• 收藏: {favorites}
• 总互动: {total_engagement}

情感分析:
• 分数: {sentiment_score}
• 标签: {sentiment_label}
• 原因: {sentiment_reason}

影响力: {influence_score}

**平台标识：**
📕 小红书 | 🔴 微博 | 🚗 汽车之家 | 🎬 懂车帝 | 🚙 易车网 | 🤔 知乎 | 💬 百度贴吧 | 🎵 抖音/快手

**认证标识：**
⭐ 汽车媒体官方 | 🎖️ 认证编辑 | 👑 行业KOL | ✅ 认证用户

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🎯 建议行动
━━━━━━━━━━━━━━━━━━━━

优先级 1 (立即):
{immediate_action}

优先级 2 (今日):
{today_action}

优先级 3 (本周):
{week_action}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

💬 建议回复
━━━━━━━━━━━━━━━━━━━━

{如果是负面提及，提供3个不同风格的回复建议}

方案 A (正式道歉):
{reply_a}

方案 B (友好解释):
{reply_b}

方案 C (积极解决):
{reply_c}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🔗 快捷操作
━━━━━━━━━━━━━━━━━━━━

• 查看原文: {url}
• 查看作者主页: {author_url}
• 搜索相关讨论: {search_url}

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 第五步：推送警报

**推送策略：**

#### 5级警报（危机）
- 立即推送到飞书
- @所有人
- 使用红色卡片模板
- 添加"紧急处理"按钮
- 同时发送短信（如果配置）

#### 4级警报（严重）
- 立即推送到飞书
- @相关负责人
- 使用橙色卡片模板
- 添加"立即查看"按钮

#### 3级警报（中等）
- 推送到飞书
- 使用黄色卡片模板
- 添加"查看详情"按钮

#### 2级警报（轻微）
- 推送到飞书
- 使用蓝色卡片模板
- 汇总到下次日报

#### 1级警报（参考）
- 不单独推送
- 记录到日志
- 汇总到日报

**飞书卡片示例（5级危机）：**

```json
{
  "msg_type": "interactive",
  "card": {
    "header": {
      "title": {
        "tag": "plain_text",
        "content": "🚨 紧急警报：品牌危机事件"
      },
      "template": "red"
    },
    "elements": [
      {
        "tag": "div",
        "text": {
          "tag": "lark_md",
          "content": "**紧急程度**: 🔴 5级 - 需要立即处理\n**发现时间**: {timestamp}\n**警报类型**: 危机事件"
        }
      },
      {
        "tag": "hr"
      },
      {
        "tag": "div",
        "text": {
          "tag": "lark_md",
          "content": "**提及内容**:\n{content}"
        }
      },
      {
        "tag": "hr"
      },
      {
        "tag": "div",
        "fields": [
          {
            "is_short": true,
            "text": {
              "tag": "lark_md",
              "content": "**平台**\n{platform}"
            }
          },
          {
            "is_short": true,
            "text": {
              "tag": "lark_md",
              "content": "**作者**\n@{username}"
            }
          },
          {
            "is_short": true,
            "text": {
              "tag": "lark_md",
              "content": "**影响力**\n{influence_score}"
            }
          },
          {
            "is_short": true,
            "text": {
              "tag": "lark_md",
              "content": "**情感**\n{sentiment_score}"
            }
          }
        ]
      },
      {
        "tag": "hr"
      },
      {
        "tag": "div",
        "text": {
          "tag": "lark_md",
          "content": "**建议行动**:\n{actions}"
        }
      },
      {
        "tag": "action",
        "actions": [
          {
            "tag": "button",
            "text": {
              "tag": "plain_text",
              "content": "查看原文"
            },
            "type": "primary",
            "url": "{url}"
          },
          {
            "tag": "button",
            "text": {
              "tag": "plain_text",
              "content": "标记已处理"
            },
            "type": "default"
          }
        ]
      }
    ]
  }
}
```

### 第六步：记录警报

保存警报记录到记忆：

```json
{
  "type": "brand_alert",
  "timestamp": "ISO8601",
  "brand": "{{brand_name}}",
  "alert_type": "negative|viral|crisis",
  "severity": 1-5,
  "mention": {完整提及数据},
  "actions_taken": [],
  "status": "pending|in_progress|resolved"
}
```

### 第七步：跟踪处理

如果是高级别警报（4-5级），自动创建跟踪任务：

```
📋 警报跟踪任务
━━━━━━━━━━━━━━━━━━━━

任务ID: ALERT-{timestamp}
创建时间: {datetime}
状态: 待处理

检查清单:
□ 已查看原文
□ 已评估影响
□ 已制定响应策略
□ 已发布回应
□ 已跟踪反馈
□ 已总结经验

下次检查: {next_check_time}
```

## 特殊场景处理

### 场景 1：多个用户同时投诉

如果发现多个用户在短时间内提及相同问题：

```
🚨 群体性投诉警报

检测到 {count} 个用户在过去 {hours} 小时内提及相同问题：

问题: {issue_summary}

涉及平台:
• 微博: {weibo_count} 条
• 小红书: {xiaohongshu_count} 条
• 汽车之家: {autohome_count} 条
• 知乎: {zhihu_count} 条

涉及用户:
• @{user1} (粉丝: {followers1})
• @{user2} (粉丝: {followers2})
• @{user3} (粉丝: {followers3})
...

总影响力: {total_influence}
总互动数: {total_engagement}

⚠️ 这可能是系统性问题，建议立即调查！

问题类型识别:
{如果是续航问题} → 可能涉及电池管理系统
{如果是充电问题} → 可能涉及充电桩兼容性或车辆充电系统
{如果是智驾问题} → 可能涉及软件bug或传感器故障
{如果是异响问题} → 可能涉及装配质量或零部件问题

建议行动:
1. 立即检查系统/产品是否存在该问题
2. 联系技术团队进行排查
3. 准备统一回应声明
4. 主动联系受影响用户
5. 如确认问题，准备召回或OTA升级方案
6. 发布公告说明情况和解决方案
```

### 场景 2：汽车媒体报道

如果检测到汽车媒体账号提及：

```
📰 汽车媒体报道警报

媒体: {media_name}
类型: {media_type}
认证: {certification}
影响力: {influence_score}
粉丝: {followers}

报道内容:
{content}

报道角度: {positive|neutral|negative}
报道类型: {评测|新闻|对比|投诉曝光}

传播数据:
• 点赞: {likes}
• 转发: {shares}
• 评论: {comments}
• 预计触达: {estimated_reach}

**重点媒体识别：**
⭐ 汽车之家官方
⭐ 懂车帝评测组
⭐ 易车网编辑部
⭐ 新出行
⭐ 电动邦
⭐ 42号车库
⭐ 知名汽车博主

建议行动:
1. 评估报道准确性和客观性
2. 如为正面报道：感谢媒体，扩大传播
3. 如为中性报道：提供更多信息，争取正面角度
4. 如为负面报道：
   - 核实报道内容是否属实
   - 准备官方声明
   - 联系媒体沟通（如需澄清）
   - 准备应对方案
5. 监控后续传播和用户反应
6. 评估是否需要发布官方回应
```

### 场景 3：竞品对比讨论

如果提及中包含竞品对比：

```
⚖️ 竞品对比提及

对比对象: {competitor}
对比维度: {dimensions}
讨论平台: {platform}

用户观点:
{summary}

对比结果:
我方优势: {advantages}
我方劣势: {disadvantages}

讨论热度:
• 提及次数: {mention_count}
• 总互动数: {total_engagement}
• 情感倾向: {sentiment_trend}

**常见对比维度（新能源汽车）：**
• 续航里程
• 充电速度
• 智能驾驶能力
• 空间舒适性
• 价格性价比
• 品牌力
• 售后服务
• 保值率

建议:
1. 分析用户关注的核心对比点
2. 准备针对性的对比内容
3. 突出我方差异化优势
4. 正面回应劣势（如有改进计划）
5. 在官方渠道发布客观对比
6. 引导用户关注我方优势维度
```

## 输出要求

1. **速度优先**
   - 5分钟内完成检测
   - 立即推送高级别警报
   - 不等待完整分析

2. **准确判断**
   - 避免误报
   - 正确评估紧急程度
   - 提供可靠建议

3. **可操作性**
   - 建议具体明确
   - 提供回复模板
   - 包含快捷链接

现在开始执行警报检测！
