---
name: brand-identity
description: Build a complete brand identity for a solopreneur business from scratch or refresh an existing one. Covers brand personality, voice and tone, visual identity system (colors, typography, logo direction, imagery style), tagline crafting, and a brand guidelines document. Use when creating a new brand, rebranding, or needing to make brand decisions consistent. Trigger on "create my brand", "brand identity", "brand guidelines", "define my brand voice", "brand personality", "what should my brand look like", "brand strategy", "rebrand", "brand tone".
---

# Brand Identity

## Overview
Brand identity is the system of signals that makes your business instantly recognizable and trustworthy. For solopreneurs, a strong brand punches above your weight — it makes a one-person operation feel as polished and credible as a funded startup. This playbook builds your brand from strategy down to execution, in the right order. Getting the strategy wrong and then designing around it is the #1 brand mistake.

---

## Phase 1: Brand Foundations (Strategy First — Always)

Do not pick colors or logos until these are locked. Everything visual flows from here.

**1.1 Brand Purpose**
Why does this business exist beyond making money? One sentence. This is your north star for every brand decision.

Example: "To give independent consultants the client-facing polish that enterprise teams get for free."

**1.2 Brand Values (pick exactly 3)**
Values are the principles your brand consistently embodies. Three is the sweet spot — fewer is too vague, more is forgettable.

Choose from or write your own:
- Simplicity / Clarity
- Trustworthiness / Reliability
- Innovation / Forward-thinking
- Warmth / Human connection
- Efficiency / Respect for time
- Boldness / Confidence
- Transparency / Honesty
- Craftsmanship / Attention to detail

For each value, write one sentence describing what it looks like in practice for your business.

**1.3 Brand Personality (the "If your brand were a person" exercise)**
Describe your brand as if it were a person at a party. What are they like?

Use this framework — pick one from each pair:
- Serious vs. Playful
- Formal vs. Casual
- Reserved vs. Confident
- Traditional vs. Modern
- Understated vs. Bold

Write 3-5 sentences describing this person's personality. This becomes the filter for every brand decision: "Would this person say it this way? Would they design it this way?"

**1.4 Target Audience Reminder**
Pull your primary persona from your niche-selection or market-research work. Your brand must resonate with THEM — not with you personally (unless you are your target customer).

---

## Phase 2: Voice and Tone

Voice is who you are. Tone is how you adjust based on context.

**2.1 Define Your Voice (3 adjectives)**
Pick three words that describe how your brand always sounds, regardless of context.

Examples: "Clear, confident, human" or "Witty, knowledgeable, approachable"

**2.2 Voice Do's and Don'ts**
For each of your three voice words, write:
- One thing you ALWAYS do (e.g., "Use plain language. If a 14-year-old couldn't understand it, rewrite it.")
- One thing you NEVER do (e.g., "Never use corporate jargon like 'synergy' or 'leverage' as a verb.")

**2.3 Tone Adjustments by Context**
Your core voice stays the same, but tone shifts:

| Context | Tone Adjustment | Example |
|---|---|---|
| Marketing copy | Energetic, benefit-forward | Lead with the transformation, not the feature |
| Error messages | Calm, helpful, never blaming | "Something went wrong on our end. Here's how to fix it." |
| Success moments | Warm, celebratory | "You just saved 3 hours this week." |
| Support interactions | Patient, empathetic, solution-focused | Acknowledge frustration before jumping to fixes |
| Social media | Slightly more casual, conversational | Can use humor if it fits your personality |

**2.4 Voice Examples (Write 3)**
Write the same message in your brand voice and in a "generic corporate" voice. The contrast will sharpen your instincts.

Example message: "We updated how invoices are generated."
- Generic: "We have updated our invoice generation functionality to improve user experience."
- Your voice: "Invoices are now 2x faster to create. Here's what changed and why."

---

## Phase 3: Visual Identity System

### 3.1 Color Palette

Do not just pick colors you like. Build a palette with intention.

**Primary color (1):** The color that appears most. Represents your brand at a glance. Should connect to your brand personality (e.g., blue = trust, green = growth, orange = energy).

**Secondary color (1):** Complements the primary. Used for accents, CTAs, highlights.

**Neutral colors (2-3):** Background, text, and UI surface colors. Usually a dark neutral (near-black) for text and a light neutral (near-white) for backgrounds. Avoid pure black (#000) and pure white (#FFF) — slightly off-tones feel more refined.

**Accent/alert color (1):** For success, warning, error states. Functional, not decorative.

**Format for each color:** Name, hex code, and one-sentence usage rule.

**Color psychology quick reference:**
- Blue: Trust, professionalism, calm
- Green: Growth, health, money, success
- Orange: Energy, creativity, friendliness
- Purple: Innovation, luxury, creativity
- Red: Urgency, passion, confidence
- Yellow: Optimism, warmth, attention
- Dark/neutral: Sophistication, seriousness

### 3.2 Typography

Pick two typefaces (one for headings, one for body). No more.

**Heading font:** Can be more expressive. Sets the personality.
**Body font:** Must be highly readable at small sizes. Clarity wins over style here.

**Rules:**
- Both fonts must be available for free (Google Fonts is your friend).
- Test them together. Some pairings clash.
- Define size scales: heading sizes (H1, H2, H3) and body sizes (default, small, large).
- Define weight usage: when to use bold, when regular, when light.

### 3.3 Logo Direction

As a solopreneur, do not spend $5,000 on a custom logo on day one. Instead, define the direction and constraints so you (or a cheap freelancer later) can execute it.

**Logo type — pick one:**
- **Wordmark:** Your business name in a distinctive typeface. Simplest, most scalable.
- **Lettermark:** Initials in a styled format (e.g., "KA" for Khatri Automations).
- **Icon + Wordmark:** A simple icon/symbol alongside your name. More versatile but harder to design well.

**Logo constraints to define:**
- Must work at small sizes (favicon, app icon — 32×32px minimum)
- Must work in one color (for single-color print, embossing, etc.)
- Must work on both dark and light backgrounds

**For now:** Use a clean wordmark in your heading font as a placeholder. Upgrade when you have revenue to justify the investment.

### 3.4 Imagery Style
Define the visual style of photos, illustrations, and graphics across your brand:
- Realistic photography vs. illustration vs. abstract/geometric?
- Bright and airy vs. dark and moody vs. clean and minimal?
- People-focused vs. product-focused vs. concept-focused?
- Stock photo style (if using stock): which aesthetic feels right? (Check Unsplash for tone reference)

---

## Phase 4: Brand Guidelines Document

Compile everything above into a single reference document. This is what you hand to any freelancer, and what you check against every time you make a brand decision. Structure:

```
1. Brand Purpose & Values
2. Brand Personality
3. Voice & Tone (with examples)
4. Color Palette (hex codes + usage rules)
5. Typography (fonts + size scale + weight rules)
6. Logo Usage (rules + placeholder)
7. Imagery Style
8. Brand Decision Filter:
   "Before publishing anything, ask:
    - Does this reflect our brand values?
    - Does this sound like our voice?
    - Does this visually match our palette and type?"
```

---

## Brand Consistency Checklist (Ongoing)
Every time you create something (website, social post, email, slide deck, proposal), run it through:
- [ ] Uses only brand colors (no random colors creeping in)
- [ ] Uses only brand fonts
- [ ] Tone matches the context-specific tone guide
- [ ] Imagery matches defined style
- [ ] Logo usage follows the rules

Inconsistency is the silent brand killer. One off-brand touchpoint erodes the trust you built with ten on-brand ones.
