---
name: brand-dna
version: 1.0.0
description: Build a complete Brand Bible for any business — tone of voice, positioning, target audiences, messaging pillars, and visual identity guidelines. The foundation skill that all other content skills depend on.
tags: [branding, marketing, strategy, tone-of-voice, positioning, content]
author: contentai-suite
license: MIT
---

# Brand DNA — Universal Brand Bible Builder

## What This Skill Does

Creates a complete, professional Brand Bible for any business or solopreneur. Once defined, this brand document becomes the foundation for all content generation — every post, blog, email, and campaign reflects a consistent brand voice.

## How to Use This Skill

**Step 1:** Tell the AI your brand details using this template:

```
BUSINESS NAME: [Your company/personal brand name]
NICHE: [Your industry or specialty]
LOCATION: [City/Country or "Global/Online"]
TARGET AUDIENCE: [Who you serve — age, profession, pain points]
UNIQUE VALUE: [What makes you different from competitors]
TONE: [e.g., professional, casual, bold, empathetic, humorous]
SERVICES/PRODUCTS: [List your main offerings]
FOUNDER STORY: [Optional: your personal story or journey]
```

**Step 2:** The AI generates a complete Brand Bible with all sections below.

---

## Brand Bible Structure

### 1. Brand Identity

```
BRAND NAME: [Name]
TAGLINE: [One powerful sentence that defines what you do]
MISSION: [Why you exist — beyond making money]
VISION: [Where you want to be in 5 years]
CORE VALUES: [3-5 values that guide every decision]
```

### 2. Tone of Voice

#### Personality Keywords
Define 5-7 words that describe how your brand "sounds":
- Examples: Bold · Empathetic · Direct · Expert · Warm · Rebellious · Premium

#### Writing Style Rules
1. **Address your reader directly** — use "you/your" not "one"
2. **Sentence length** — vary between short punchy lines and detailed explanations
3. **Jargon policy** — use industry terms only if your audience knows them
4. **Always include a CTA** — every piece of content should have a next step
5. **Authenticity rule** — share real experiences, not polished marketing speak
6. **Forbidden tone** — list what you will NEVER sound like

#### Forbidden Words/Phrases
List clichés and buzzwords your brand avoids:
- Generic: "game-changer", "world-class", "seamless experience"
- Overpromising: "guaranteed results", "100% success"
- Your custom list: [add your own]

### 3. Target Audience Profiles

#### Primary Audience — [Name your persona]
```
Demographics: [Age range, gender if relevant, location]
Profession: [Job title or life situation]
Pain Points: [Top 3 problems they face]
Goals: [What they want to achieve]
Where they hang out: [Instagram, LinkedIn, YouTube, etc.]
Messaging hook: [The one sentence that makes them stop scrolling]
```

#### Secondary Audience — [Name your persona]
```
[Same structure as above]
```

### 4. Positioning Statement

**You ARE:**
- [Specific strength 1]
- [Specific strength 2]
- [Specific strength 3]

**You are NOT:**
- [Misconception 1 to avoid]
- [Misconception 2 to avoid]

**Your Unfair Advantage:**
[What you offer that no competitor can claim]

### 5. Messaging Pillars

Define 3-5 content pillars — the main topics you always talk about:

| Pillar | Topic | Why You Own This | Content Format |
|--------|-------|-----------------|----------------|
| 1 | [Topic] | [Your expertise/story] | [Post/Blog/Video] |
| 2 | [Topic] | [Your expertise/story] | [Post/Blog/Video] |
| 3 | [Topic] | [Your expertise/story] | [Post/Blog/Video] |

### 6. Visual Identity

```
PRIMARY COLOR: [Hex code or description]
SECONDARY COLOR: [Hex code or description]
ACCENT COLOR: [Hex code or description]
TYPOGRAPHY: [Font style — serif/sans-serif, modern/classic]
IMAGERY STYLE: [Real photos/illustrations/minimalist/bold graphics]
AVOID: [What visual styles clash with your brand]
```

### 7. Brand Voice Examples

**How You Would Say It vs. Generic Marketing:**

| Generic | Your Brand Voice |
|---------|-----------------|
| "We offer premium services" | "[Your authentic version]" |
| "Contact us today" | "[Your CTA in brand voice]" |
| "Quality guaranteed" | "[Your proof-based claim]" |

---

## Quick Brand Audit Checklist

Before publishing any content, verify:
- [ ] Does this match our tone of voice?
- [ ] Would our target audience recognize themselves in this?
- [ ] Does this align with at least one content pillar?
- [ ] Is there a clear next step (CTA)?
- [ ] Have we avoided our forbidden words/phrases?
- [ ] Does this feel authentic, not corporate?

---

## Integration with Other Skills

This Brand DNA skill feeds directly into:
- **Blog Master** (skill 03) — blog tone and authority positioning
- **Instagram Master** (skill 04) — hashtag strategy and visual style
- **LinkedIn Authority** (skill 05) — thought leadership voice
- **Email Campaigns** (skill 08) — newsletter personality
- **All other content skills** — consistent brand voice everywhere

**Always load Brand DNA first before using any other content skill.**

---

## Use with ContentAI Suite

This skill works seamlessly with **[ContentAI Suite](https://contentai-suite.vercel.app)** — a free multi-agent marketing platform that uses your Brand DNA to generate content across all platforms automatically.

→ **Try it free:** https://contentai-suite.vercel.app
