---
name: brand-cog
description: "Other tools make logos. CellCog builds brands. #1 on DeepResearch Bench (Feb 2026) for deep strategic reasoning + the widest modality coverage in AI. Brand identity, brand kits, color palettes, typography, brand guidelines, logo design, visual identity, social media, web design, video — all from one brief."
metadata:
  openclaw:
    emoji: "🏷️"
author: CellCog
dependencies: [cellcog]
---

# Brand Cog - Build Brands, Not Just Logos

**Other tools make logos. CellCog builds brands.** #1 on DeepResearch Bench (Feb 2026) for deep strategic reasoning + the widest modality coverage in AI.

Brand building demands two things: deep understanding of your positioning, audience, and competitors — and the ability to produce assets across every format. CellCog delivers both in one request: logos, color systems, typography, brand guidelines, social templates, web assets, and video, all cohesive from a single brief.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
# Fire-and-forget - returns immediately
result = client.create_chat(
    prompt="[your brand request]",
    notify_session_key="agent:main:main",
    task_label="brand-creation",
    chat_mode="agent"  # Agent mode for most brand work
)
# Daemon notifies you when complete - do NOT poll
```

---

## Why Branding is Complex Work

A brand isn't just a logo. It's a system:

- **Visual Consistency**: Every touchpoint must feel cohesive
- **Strategic Positioning**: Design reflects brand personality and values
- **Versatility**: Works across social media, print, web, merchandise
- **Memorability**: Distinctive enough to stick in minds
- **Scalability**: From favicon to billboard

CellCog creates complete brand systems, not just isolated assets.

---

## What You Can Create

### Complete Brand Kits

Everything you need to launch:

- **Startup Brand Kits**: "Create a complete brand identity for my SaaS startup"
- **Personal Brand Kits**: "Build my personal brand as a content creator"
- **Small Business Branding**: "Create branding for my coffee shop"
- **Project Branding**: "Design branding for my open source project"

**Example prompt:**
> "Create a complete brand kit for 'NomadNest' - a co-living startup for remote workers:
> 
> Brand personality: Modern, adventurous, community-focused, professional but not corporate
> Target audience: 25-40 year old remote workers, digital nomads
> 
> I need:
> - Logo (primary + variations)
> - Color palette (primary, secondary, accent colors)
> - Typography recommendations
> - Brand voice guidelines
> - Social media profile templates
> - Business card design
> - Email signature template
> 
> Vibe: Airbnb meets WeWork, warm and inviting"

### Logo Design

The cornerstone of your brand:

- **Wordmarks**: "Create a text-based logo for my consulting firm"
- **Logomarks**: "Design an icon/symbol logo for my app"
- **Combination Marks**: "Create a logo with both icon and text"
- **Logo Variations**: "I have a logo - create variations for different uses"

**Example prompt:**
> "Design a logo for 'Zenith Analytics' - a data science consultancy:
> 
> Style: Minimal, geometric, professional
> Concept ideas: Could incorporate Z, data/analytics symbolism, or abstract peak (zenith)
> 
> Must work:
> - At small sizes (favicon, app icon)
> - In black and white
> - On dark and light backgrounds
> 
> Colors: Open to suggestions but leaning toward deep blue and silver
> 
> Provide: Primary logo, icon-only version, horizontal lockup, dark mode version"

### Color Palettes

Colors that tell your story:

- **Full Palettes**: "Create a color system for my brand"
- **Mood-Based**: "Design a color palette that feels luxurious but approachable"
- **Industry-Specific**: "Create colors for a healthcare brand that don't feel clinical"
- **Expansion**: "Extend my existing brand colors with complementary accent colors"

### Typography Systems

Fonts that fit your voice:

- **Font Pairings**: "Recommend a heading and body font combination"
- **Type Hierarchy**: "Create a typography system with sizes and weights"
- **Custom Direction**: "I want fonts that feel techy but human"

### Brand Guidelines

Documentation for consistency:

- **Style Guides**: "Create brand guidelines documenting my visual identity"
- **Usage Rules**: "Document do's and don'ts for my logo"
- **Tone of Voice**: "Define my brand's written voice and personality"

---

## Brand Personalities

| Personality | Visual Characteristics | Colors | Typography |
|-------------|----------------------|--------|------------|
| **Luxurious** | Minimal, elegant, refined | Gold, black, deep tones | Serif, thin weights |
| **Playful** | Bold, dynamic, energetic | Bright, saturated | Rounded sans-serif |
| **Professional** | Clean, structured, trustworthy | Blue, gray, white | Classic sans-serif |
| **Eco/Natural** | Organic, earthy, warm | Green, brown, cream | Humanist fonts |
| **Tech/Modern** | Geometric, futuristic, minimal | Electric blue, dark mode | Geometric sans |
| **Friendly** | Soft, approachable, warm | Pastels, warm tones | Rounded, friendly |

---

## Brand Kit Components

A complete brand kit typically includes:

| Component | What It Is |
|-----------|------------|
| **Primary Logo** | Main logo for most uses |
| **Logo Variations** | Icon-only, wordmark-only, stacked, horizontal |
| **Color Palette** | Primary, secondary, accent, neutrals with hex codes |
| **Typography** | Font families, sizes, hierarchy |
| **Imagery Style** | Photo style, illustration guidelines |
| **Voice & Tone** | How the brand speaks |
| **Social Templates** | Profile images, post templates, stories |
| **Business Materials** | Cards, letterhead, email signature |

---

## Chat Mode for Branding

| Scenario | Recommended Mode |
|----------|------------------|
| Logos, color palettes, individual brand assets | `"agent"` |
| Complete brand systems, strategic brand development | `"agent team"` |

**Use `"agent"` for specific brand assets.** Logos, color palettes, and templates execute well in agent mode.

**Use `"agent team"` for complete brand development** - when you need strategic thinking about positioning, comprehensive systems, and multiple creative directions explored.

---

## Example Prompts

**Complete brand identity:**
> "Create a brand identity for 'Bloom' - a mental health app for young professionals:
> 
> Mission: Make therapy-informed self-care accessible and non-stigmatized
> Audience: 22-35, stressed professionals, first time exploring mental health tools
> Competitors: Calm, Headspace (but we want to feel different - less meditation, more practical)
> 
> Brand personality: Warm, knowledgeable, empowering (not patronizing), modern
> 
> Deliver:
> - Logo with variations
> - Color palette (calming but not boring)
> - Font recommendations
> - App icon
> - Social media templates
> - Brand voice guidelines
> 
> Avoid: Clinical/medical feel, overly 'zen'/spiritual aesthetic, childish"

**Logo design:**
> "Design a logo for 'Axiom Ventures' - a tech-focused VC firm:
> 
> Positioning: Smart money, founder-friendly, sector expertise in AI/ML
> 
> Direction:
> - Could be abstract, geometric, or incorporate 'A'
> - Should feel: Confident, forward-thinking, substantial
> - Should NOT feel: Stuffy, generic corporate, startup-bro
> 
> Versatility needed: Website, pitch decks, swag, business cards
> 
> Provide multiple concepts to choose from."

**Personal brand:**
> "Create a personal brand kit for me as a tech content creator:
> 
> Name: Alex Chen
> Platforms: YouTube, Twitter, Newsletter
> Content: Programming tutorials, career advice, tech industry commentary
> Personality: Helpful, slightly nerdy, approachable expert
> 
> I need:
> - A simple logo/avatar that's recognizable
> - Color palette for my content
> - YouTube thumbnail template style
> - Twitter header and profile pic
> - Newsletter banner
> 
> Should feel: Personal but polished, trustworthy, not corporate"

---

## Tips for Better Branding

1. **Know your audience**: "For enterprise clients" vs "for Gen Z" changes everything.

2. **Personality over pretty**: A distinctive brand beats a generic beautiful one.

3. **Competition context**: Tell us who you're competing with so we differentiate.

4. **Versatility matters**: Request assets that work across different contexts and sizes.

5. **Include anti-examples**: "Not corporate" or "avoid clinical feel" is useful direction.

6. **Think long-term**: Your brand should have room to evolve. Don't over-constrain.
