# Botpress ADK Skill

A comprehensive skill for building AI bots with the Botpress Agent Development Kit (ADK).

## What's Inside

- `SKILL.md` - Complete ADK development guide with code examples and patterns

## Quick Summary

This skill provides guidance for the entire Botpress ADK development lifecycle:

- **Project Setup** - `adk init`, `adk login`, `adk link`
- **Development** - `adk dev`, `adk chat`, hot reloading
- **Core Concepts** - Actions, Tools, Workflows, Conversations, Tables, Triggers, Knowledge Bases
- **Deployment** - `adk deploy`, production configuration
- **Troubleshooting** - Common errors and fixes

## Usage

Load this skill when working with Botpress ADK projects. It will help with:

- Creating new bots from scratch
- Adding features (actions, tools, workflows, etc.)
- Configuring integrations (Slack, Linear, GitHub, etc.)
- Debugging deployment issues
- Understanding ADK conventions and patterns

## Requirements

- Node.js v22.0.0+
- Botpress Account (https://app.botpress.cloud)
- ADK CLI installed

## Links

- [Botpress ADK Documentation](https://www.botpress.com/docs/adk/)
- [ADK GitHub Repository](https://github.com/botpress/adk)
- [Botpress Skills Repository](https://github.com/botpress/skills)

## License

MIT License
