---
domain: writer
topic: article-structures-argumentation-evidence
priority: high
ttl: 30d
---

# Article Writing — Structures, Argumentation Frameworks & Evidence Types

## Article Structure Patterns

### 1. Inverted Pyramid

The most important information appears first, with details following in descending order of significance. Ideal for news articles, reports, and time-sensitive content.

**Structure:**
1. **Lead** — The core finding, conclusion, or newsworthy element in 1-2 sentences
2. **Key supporting facts** — The essential context: who, what, when, where, why, how
3. **Background & detail** — Additional context, historical perspective, secondary quotes
4. **Supplementary material** — Related information, further reading, tangential points

**Best for:** News articles, executive summaries, blog posts where readers may not finish

**Strengths:**
- Readers get value even if they stop early
- Forces the writer to prioritize information
- Easy to trim from the bottom for length constraints

### 2. Narrative Arc

Follows a storytelling structure that engages readers emotionally while delivering information. Ideal for feature articles, case studies, and long-form content.

**Structure:**
1. **Hook / Opening scene** — An anecdote, vivid scene, or provocative question that draws the reader in
2. **Context / Rising action** — Background information that sets the stage and introduces complexity
3. **Central tension / Problem** — The core conflict, challenge, or question being explored
4. **Resolution / Insight** — The answer, finding, or transformation revealed through the narrative
5. **Denouement / Reflection** — Broader implications, lessons learned, or forward-looking perspective

**Best for:** Feature articles, profiles, case studies, long-form journalism, storytelling-driven blog posts

**Strengths:**
- High reader engagement through emotional connection
- Complex ideas become accessible through concrete stories
- Memorable — readers retain narrative better than abstract arguments

### 3. Analytical Framework

Presents a systematic examination of a topic through structured analysis. Ideal for opinion pieces, thought leadership, and technical articles.

**Structure:**
1. **Thesis statement** — A clear, arguable claim stated within the first two paragraphs
2. **Framework introduction** — The analytical lens or criteria being applied
3. **Argument block 1** — First supporting argument with evidence and analysis
4. **Argument block 2** — Second supporting argument with evidence and analysis
5. **Argument block 3** — Third supporting argument (or counterargument + rebuttal)
6. **Synthesis** — How the arguments work together to prove the thesis
7. **Conclusion** — Restatement of thesis with broader implications and call to action

**Best for:** Opinion pieces, thought leadership, academic articles, technical analysis, persuasive essays

**Strengths:**
- Rigorous and credible; shows depth of analysis
- Easy for readers to follow the logical chain
- Well-suited to topics requiring evidence-based persuasion

### 4. Listicle / Modular

Organizes content into discrete, numbered or thematic sections that can be read independently. Ideal for practical guides, how-to articles, and reference content.

**Structure:**
1. **Introduction** — Context, scope, and why this list matters
2. **Item 1** — Standalone section with heading, explanation, and supporting detail
3. **Item 2-N** — Each item follows the same internal structure for consistency
4. **Conclusion / Summary** — Ties the items together and provides next steps

**Best for:** How-to guides, "top N" articles, best practice compilations, tool comparisons

**Strengths:**
- Scannable; readers can jump to relevant sections
- Lower cognitive load per section
- Strong SEO performance due to clear heading structure

### 5. Problem-Solution

Identifies a specific problem, explores its dimensions, and presents a solution with evidence. Ideal for technical articles, white papers, and persuasive content.

**Structure:**
1. **Problem statement** — Define the problem clearly with data on its scope and impact
2. **Root cause analysis** — Why the problem exists; underlying factors
3. **Solution proposal** — The recommended approach, method, or framework
4. **Evidence of effectiveness** — Data, case studies, or expert validation supporting the solution
5. **Implementation guidance** — Practical steps for adopting the solution
6. **Conclusion** — Summary of impact and call to action

**Best for:** White papers, technical blog posts, consulting reports, product marketing content

## Argumentation Frameworks

### Toulmin Model

A practical framework for constructing and evaluating arguments:

| Component | Definition | Example |
|-----------|-----------|---------|
| **Claim** | The assertion being made | "Remote work increases productivity" |
| **Data** | The evidence supporting the claim | "Stanford study showing 13% performance increase" |
| **Warrant** | The logical connection between data and claim | "Fewer distractions and flexible schedules enable deeper focus" |
| **Backing** | Support for the warrant itself | "Research on flow states confirms uninterrupted work improves output" |
| **Qualifier** | Conditions or limitations | "For knowledge workers in roles not requiring physical presence" |
| **Rebuttal** | Acknowledgment of counterarguments | "Though some roles benefit from in-person collaboration" |

### Classical Rhetorical Appeals (Aristotle)

| Appeal | Definition | Article Application |
|--------|-----------|-------------------|
| **Ethos** (Credibility) | Establish authority and trustworthiness | Cite expert sources, demonstrate domain knowledge, acknowledge limitations |
| **Pathos** (Emotion) | Connect with the reader emotionally | Use vivid anecdotes, relatable scenarios, human-impact framing |
| **Logos** (Logic) | Appeal through reasoning and evidence | Present data, logical deductions, structured arguments, causal chains |

**Balanced usage:** Strong articles blend all three appeals. Lead with ethos (establish credibility), engage with pathos (make it matter), and convince with logos (prove it with evidence).

### Rogerian Argument

A collaborative approach for contentious topics:
1. **Acknowledge the opposing view** — Present it fairly and accurately
2. **Find common ground** — Identify shared values or goals
3. **Present your position** — With evidence, framed as building on the common ground
4. **Propose a synthesis** — Show how both perspectives can be accommodated

**Best for:** Controversial topics, opinion pieces aiming to persuade skeptics, policy discussions

### PEEL Paragraph Structure

A micro-framework for individual paragraphs within any article structure:
- **P**oint — State the paragraph's main idea in one sentence
- **E**vidence — Provide supporting data, quotes, or examples
- **E**xplain — Analyze how the evidence supports the point
- **L**ink — Connect back to the thesis or transition to the next paragraph

## Evidence Types

### 1. Statistical Data
- Quantitative findings from research studies, surveys, or official reports
- **Strength:** Objective, measurable, difficult to dispute
- **Usage:** "According to a 2024 Gartner report, 65% of enterprises..."
- **Caution:** Always cite the source, sample size, and methodology when available

### 2. Expert Testimony
- Quotes, opinions, or findings from recognized authorities in the field
- **Strength:** Leverages established credibility (ethos)
- **Usage:** Direct quotes for impact, paraphrased for flow
- **Caution:** Verify the expert's credentials and check for conflicts of interest

### 3. Case Studies
- Detailed real-world examples demonstrating a principle in practice
- **Strength:** Concrete, relatable, shows causation in context
- **Usage:** Narrative description of situation, action, and outcome
- **Caution:** Individual cases may not be generalizable; acknowledge limitations

### 4. Analogies & Metaphors
- Comparisons that make abstract concepts accessible
- **Strength:** Bridges the knowledge gap between writer and reader
- **Usage:** "Microservices are like a team of specialists, each handling one task..."
- **Caution:** Analogies simplify; acknowledge where the comparison breaks down

### 5. Historical Precedent
- Past events or decisions that inform the current discussion
- **Strength:** Provides temporal context and pattern recognition
- **Usage:** "The 2008 financial crisis demonstrated that..."
- **Caution:** Context changes over time; historical parallels are imperfect

### 6. Logical Reasoning
- Deductive or inductive chains that lead the reader to a conclusion
- **Strength:** Self-contained; doesn't depend on external sources
- **Usage:** "If A is true, and B follows from A, then C must follow..."
- **Caution:** Ensure premises are sound; avoid hidden assumptions

### 7. Anecdotal Evidence
- Personal stories or individual experiences that illustrate a point
- **Strength:** Highly engaging and relatable (pathos)
- **Usage:** Opening hooks, humanizing abstract topics, illustrating impact
- **Caution:** Not generalizable; should supplement, not replace, systematic evidence
