---
domain: writer
topic: thesis-evidence-style-best-practices
priority: high
ttl: 30d
---

# Article Writing — Best Practices

## Thesis Development

### 1. Thesis Placement & Clarity
- Place the thesis statement within the first two paragraphs — readers should never have to guess the article's central argument
- A strong thesis is **specific**, **arguable**, and **scoped**: it makes a claim that can be supported with evidence and is narrow enough to be fully addressed in the article
- Avoid thesis statements that are merely factual ("Python is a programming language") or too broad ("Technology is changing the world")

### 2. Thesis Formulation Process
1. **Start with a question** — What specific question does this article answer?
2. **Draft a tentative claim** — What is your initial answer to that question?
3. **Stress-test the claim** — Can reasonable people disagree? If not, it's not a thesis
4. **Scope it down** — Add qualifiers to make it defensible: who, when, under what conditions
5. **Refine for precision** — Remove vague language ("some," "many," "interesting")

### 3. Thesis Types by Article Purpose

| Article Purpose | Thesis Type | Example |
|----------------|-------------|---------|
| Persuasive | Value claim | "Companies should adopt four-day workweeks because the productivity and retention gains outweigh the scheduling costs" |
| Analytical | Causal claim | "The rise of remote work has restructured urban real estate markets by shifting demand from commercial to residential space" |
| Explanatory | Interpretive claim | "Kubernetes adoption follows a predictable maturity curve where organizations must pass through three distinct operational phases" |
| Comparative | Evaluative claim | "For early-stage startups, serverless architecture offers better cost efficiency than container orchestration until reaching 10,000 daily active users" |

### 4. Thesis-Argument Alignment
- Every argument block in the article must directly advance the thesis
- Map each argument to a specific aspect of the thesis before drafting
- If an argument doesn't connect to the thesis, either revise the argument, revise the thesis, or remove the argument

## Evidence Integration

### 1. Evidence Selection Criteria
- **Relevance** — Does the evidence directly support the specific claim being made?
- **Recency** — Is the data current enough for the topic? (Technology: < 2 years; Social science: < 5 years; History: age is acceptable)
- **Authority** — Is the source credible and recognized in the field?
- **Representativeness** — Does the evidence reflect the broader reality, or is it an outlier?

### 2. Evidence-to-Argument Ratio
- Every claim should be supported by at least one piece of evidence
- High-stakes claims (central to the thesis) need 2-3 supporting evidence items
- Use different evidence types for the same claim when possible (e.g., a statistic + an expert quote)
- The PEEL structure (Point-Evidence-Explain-Link) ensures every piece of evidence is analyzed, not just dropped in

### 3. Evidence Introduction Patterns

**Signal phrase (attribution first):**
> According to a 2024 McKinsey report, organizations that adopted AI-assisted workflows saw a 40% reduction in repetitive task time.

**Data-first (impact first):**
> A 40% reduction in repetitive task time — that is the finding from McKinsey's 2024 survey of 500 enterprises that adopted AI-assisted workflows.

**Contextual embedding (woven into narrative):**
> When McKinsey surveyed 500 enterprises in 2024, the results surprised even optimists: AI-assisted workflows cut repetitive task time by 40%.

### 4. Evidence Diversity Requirements
- **Never rely on a single evidence type** — An article using only statistics lacks human connection; one using only anecdotes lacks rigor
- Target a minimum of 3 evidence types per article:
  - At least one quantitative source (statistics, data)
  - At least one qualitative source (expert quote, case study)
  - At least one reasoning element (logical argument, analogy)

### 5. Source Attribution Standards
- Always identify: **who** produced the evidence, **when**, and **in what context**
- For statistics: include sample size and methodology when available
- For quotes: include the person's relevant credentials or role
- For studies: note if they are peer-reviewed, pre-print, or industry-commissioned

## Style Consistency

### 1. Tone Selection Framework

| Audience | Context | Recommended Tone | Vocabulary Level |
|----------|---------|-----------------|-----------------|
| General public | Blog, magazine | Conversational, accessible | Common terms; explain jargon |
| Industry professionals | Trade publication | Informed, collegial | Domain terms acceptable; minimal explanation |
| Academic readers | Journal, research report | Formal, precise | Technical vocabulary expected |
| Executive / Decision-maker | White paper, brief | Authoritative, concise | Business terms; focus on impact |
| Developer / Technical | Technical blog, docs | Direct, practical | Code terms, specific tool names |

### 2. Tone Consistency Rules
- **Establish tone in the first paragraph** and maintain it throughout
- If the opening is conversational ("Let's face it, nobody likes debugging"), do not shift to formal academic language in the body
- If the opening is formal ("This analysis examines the causal relationship..."), do not insert casual asides
- Transitions between sections should not shift register — use consistent bridging language

### 3. Voice & Person Conventions
- **First person singular ("I")** — Personal essays, opinion columns, experience-based articles
- **First person plural ("we")** — Collaborative or organizational pieces, tutorials ("Let's build...")
- **Second person ("you")** — How-to guides, advice articles, directly addressing the reader
- **Third person** — News articles, analytical pieces, formal reports
- **Do not mix** person within an article unless there is a deliberate rhetorical reason

### 4. Sentence & Paragraph Rhythm
- Vary sentence length: mix short (8-12 words) and long (20-30 words) sentences to create rhythm
- Short sentences create emphasis. Long sentences build complexity and nuance, allowing the reader to absorb multiple related ideas in a single breath.
- Paragraphs should be 3-6 sentences in digital content; longer paragraphs are acceptable in print
- Each paragraph should contain exactly one main idea — the topic sentence

### 5. Transition Quality
- Every paragraph must connect logically to the one before it
- Use explicit transitions for clarity: "However," "Furthermore," "As a result," "In contrast"
- Use implicit transitions through keyword echo: repeat a key term from the previous paragraph's conclusion in the next paragraph's opening
- Avoid abrupt topic changes — if a new section is necessary, use a subheading

### 6. Readability Standards
- **Flesch-Kincaid grade level** targets:
  - General audience: Grade 8-10
  - Professional audience: Grade 10-12
  - Academic audience: Grade 12-16
- Prefer active voice over passive voice (target 80%+ active sentences)
- Eliminate filler words: "very," "really," "basically," "actually," "just"
- Replace nominalizations with verbs: "made an improvement" becomes "improved"
