---
domain: writer
topic: anti-patterns
priority: medium
ttl: 30d
---

# Article Writing — Anti-Patterns

## Thesis Anti-Patterns

### 1. Weak or Missing Thesis
- **Problem**: The article lacks a clear central argument; the reader finishes without knowing what the article was trying to prove or communicate
- **Symptoms**: No single sentence can be identified as the thesis; the article reads as a collection of loosely related observations
- **Fix**: Before drafting, write a one-sentence answer to "What is this article arguing?" Place it in the first two paragraphs. Every subsequent paragraph should trace back to this sentence

### 2. Overly Broad Thesis
- **Problem**: The thesis attempts to cover too much ground, making it impossible to adequately support with evidence within the article's scope
- **Symptoms**: Phrases like "Technology is transforming everything," "There are many benefits to X," or "The world is changing rapidly"
- **Fix**: Add qualifiers to narrow the scope — specify who, what, when, where, and under what conditions. "AI is transforming healthcare" becomes "AI-powered diagnostic tools have reduced misdiagnosis rates in radiology departments by 23% since 2022"

### 3. Unfalsifiable Thesis
- **Problem**: The thesis is so obvious or vague that no reasonable person would disagree, making the article pointless
- **Symptoms**: "Good communication is important in business," "Cybersecurity is a growing concern"
- **Fix**: Strengthen the claim by adding a specific position, a causal mechanism, or a contested recommendation. The thesis should provoke thought, not nods

### 4. Moving Thesis
- **Problem**: The thesis shifts mid-article as the writer discovers new points during drafting, resulting in an article that argues one thing in the introduction and a different thing in the conclusion
- **Fix**: After completing a first draft, compare the introduction and conclusion. If they argue different things, choose one thesis and revise the entire article to align with it

## Evidence Anti-Patterns

### 5. Unsupported Claims
- **Problem**: Assertions are made without any supporting evidence — the writer expects the reader to take the claim on faith
- **Symptoms**: "It's widely known that..." "Everyone agrees that..." "Obviously..." or simply stating opinions as if they were facts
- **Fix**: For every claim, ask: "How do I know this? What would I cite?" If there is no answer, either find evidence or remove the claim

### 6. Evidence Without Analysis
- **Problem**: Data, quotes, or examples are dropped into the article without explanation of what they mean or how they support the argument
- **Symptoms**: A paragraph that is just a block quote followed by another quote; a statistic stated with no interpretation
- **Fix**: Apply the PEEL structure — after every piece of evidence, include 1-2 sentences explaining its significance and connecting it to the argument

### 7. Cherry-Picked Evidence
- **Problem**: The writer selects only evidence that supports their thesis while ignoring contradicting data, undermining credibility
- **Symptoms**: All statistics trend in the same direction; no counterarguments acknowledged; suspiciously clean narrative
- **Fix**: Actively seek and address counterevidence. Acknowledge limitations. Use the Rogerian approach: present the opposing view fairly, then explain why your position still holds

### 8. Outdated Evidence
- **Problem**: Using data or citations that are no longer current for rapidly evolving topics
- **Symptoms**: Citing a 2018 study about AI capabilities, referencing deprecated technology, using pre-pandemic data for workforce trends
- **Fix**: For technology and current affairs, evidence should be less than 2 years old. For established science or history, older sources are acceptable. Always note the publication date

### 9. Over-Reliance on a Single Source
- **Problem**: The entire article's evidence base draws from one study, one author, or one organization
- **Symptoms**: The same citation appears in every argument block; all expert quotes come from one person
- **Fix**: Use a minimum of 3-5 independent sources per article. Cross-reference key claims across multiple sources. Diversify evidence types (statistics, expert opinion, case studies)

### 10. Appeal to Authority Without Verification
- **Problem**: Citing an "expert" without verifying their credentials or relevance to the specific topic
- **Symptoms**: "A Harvard professor says..." without specifying their field; quoting a tech CEO on medical topics
- **Fix**: Verify that the expert's credentials are relevant to the specific claim being made. Include their specific role, institution, and relevant qualification

## Tone & Style Anti-Patterns

### 11. Tone Inconsistency
- **Problem**: The article shifts between formal and informal, professional and casual, creating a disjointed reading experience that undermines credibility
- **Symptoms**: An opening like "Let's dive into the fascinating world of quantum computing" followed by "The superposition principle posits that quantum bits exist in a probabilistic state vector space"
- **Fix**: Decide on a single tone before writing (see knowledge/best-practices.md tone framework). Read the full article aloud — tonal shifts become obvious when heard

### 12. Register Mismatch
- **Problem**: The vocabulary and complexity level don't match the target audience
- **Symptoms**: Using "synergize cross-functional paradigms" for a general audience; using "cool stuff" in a white paper
- **Fix**: Define the target audience explicitly before writing. Use the vocabulary level guidelines from knowledge/best-practices.md. Have someone from the target audience review if possible

### 13. Passive Voice Overuse
- **Problem**: Excessive passive voice makes the writing feel impersonal, weak, and harder to read
- **Symptoms**: "It was determined that..." "The results were analyzed..." "The decision was made by the committee..."
- **Fix**: Target 80%+ active voice. Convert: "The results were analyzed by the team" to "The team analyzed the results." Reserve passive voice for when the actor is unknown or deliberately de-emphasized

### 14. Filler and Hedge Overload
- **Problem**: Excessive hedging language weakens every claim; filler words add length without substance
- **Symptoms**: "It could perhaps be argued that there may be some potential benefits..." "Basically, it's really quite interesting that..."
- **Fix**: Remove hedge words on first edit pass. If a claim needs qualification, use a single precise qualifier: "In most enterprise contexts" rather than "It could potentially be the case that in some situations"

## Structural Anti-Patterns

### 15. Wall of Text
- **Problem**: Long, unbroken blocks of text with no subheadings, bullet points, or visual breaks
- **Fix**: Break content into scannable sections. Use subheadings every 200-300 words. Use lists for 3+ parallel items. Keep digital paragraphs to 3-6 sentences

### 16. Burying the Lead
- **Problem**: The most important or interesting information appears deep in the article instead of near the top
- **Fix**: Apply the inverted pyramid test even for non-news articles: could a reader stop at paragraph 3 and still understand the core message? If not, restructure

### 17. Weak Conclusion
- **Problem**: The article ends with a vague summary or abruptly stops without synthesizing the arguments or providing forward-looking insight
- **Symptoms**: "In conclusion, X is very important and we should all think about it more"
- **Fix**: A strong conclusion should: (1) restate the thesis in light of the evidence presented, (2) synthesize the key arguments into a higher-order insight, and (3) provide a call to action, prediction, or open question for the reader

### 18. Missing Transitions
- **Problem**: Paragraphs and sections are placed adjacent to each other without logical connectors, forcing readers to infer the relationship
- **Fix**: Every paragraph should begin with a connection to the previous one — either an explicit transition word or an echo of a key term from the prior paragraph
