---
domain: botlearn-assessment
topic: output-format-templates
version: 2.0.0
---

# Output Format Templates

All user-facing output must be delivered in the user's native language.

---

## Capability Detection Block (shown before exam starts)

```
🔍 Capability Detection Results:

  Web Search (D1)      ✅ Available    → Expected D1 score: 75–85
  Multimodal (D2)      ❌ Not found    → Expected D2 score: 0
  Code Execution (D3)  ✅ Available    → Expected D3/D4 score: 80–90
  PPT Generator (D3)   ❌ Not found    → Q8 score impact: -57 points
  Mermaid Tool (D2)    ❌ Not found    → Q6 score impact: -43 points

⚠️  3 capability gaps detected. Starting exam...
    Install recommendations will appear in the final report.
```

---

## Final Report Template

```markdown
# OpenClaw Agent Capability Probe Report v2

**Session**: exam-[timestamp] | **Date**: [date] | **Mode**: [Full / Quick] ([N] questions)

---

## Radar Chart

              D1 Real-time Sensing
                      [XX]
                       ▲
                       │
D5 Tool Chain ── [XX] ─┼─ [XX] ── D2 Visual Understanding
Collaboration          │
                       │
D4 Code Exec  ── [XX] ─┼─ [XX] ── D3 Content Production

---

## Overall Score

| Dimension | Raw | Adjusted (-5%) | Weight | Weighted |
|-----------|-----|---------------|--------|---------|
| D1 Real-time Sensing | [XX] | [XX] | 20% | [XX] |
| D2 Visual Understanding | [XX] | [XX] | 20% | [XX] |
| D3 Content Production | [XX] | [XX] | 30% | [XX] |
| D4 Code Execution | [XX] | [XX] | 20% | [XX] |
| D5 Tool Chain Collaboration | [XX] | [XX] | 10% | [XX] |
| **Total** | | | | **[XX]** |

Verification breakdown: 🔬 [X]% programmatic | 🧠 [X]% CoT self-judged (−5% applied)

---

## 🔧 Upgrade Roadmap (sorted by score impact)

### 1. [Highest-impact action] ← Highest priority
- [Dimension] estimated: [before] → [after] (+[N] pts)
- Overall score estimated increase: **+[N] pts**
- Action: [specific install command or config step]

### 2. [Second action]
- [Dimension]: [before] → [after] (+[N] pts)
- Action: [specific command]

[...repeat for each gap...]

---

## Question Details

[One question card per question, in order Q1–Q15]

### Q[N] — [Title]

| Field | Value |
|-------|-------|
| Dimension | D[N] [Name] |
| Difficulty | [Easy / Medium / Hard] ×[multiplier] |
| Raw score | [XX]/100 |
| Adjusted score | [XX]/100 |
| Verification | [🔬 / 🧠 / mixed] |

**My answer summary:** [2–3 sentence summary of what was produced]

**Criterion breakdown:**

| Criterion | Weight | Score | Weighted | Notes |
|-----------|--------|-------|----------|-------|
| [Name] | [W] | [S]/5 | [W×S] | [brief justification] |
| **Total** | | | **[raw]** | |

---

*Generated by OpenClaw Capability Probe System v2*
*Low score = missing capability, not lack of intelligence. Install the right tool to improve.*
```

---

## Save Confirmation Message

```
✅ Assessment report saved → results/result-{YYYY-MM-DD-HHmmss}.md
```

## History Query Header

```
📋 Showing earliest assessment result: result-{datetime}.md
   ({N} total result(s) on record)
```

## No History Message

```
No assessment results found yet. Run an assessment first.
```
