---
flow: full-exam
parent: SKILL.md
scope: all 5 dimensions, 15 questions
---

# Full Exam Flow

## 1. Session Setup

```
sessionId  = "exam-{YYYYMMDD}-{HHmm}"
startTime  = current ISO timestamp
dimensions = [D1, D2, D3, D4, D5]
totalQ     = 15  (3 questions per dimension)
resultFile = "results/exam-{sessionId}-full.md"
userLang   = detected from activation message (used for all user-facing output)
```

## 2. Pre-exam Announcement

Output to user in their detected language:

```
# OpenClaw Agent 5-Dimension Assessment

Session: exam-{ID}
Mode: Full Exam (5 dimensions × 3 questions = 15 total)
Dimensions: D1 Reasoning · D2 Retrieval · D3 Creation · D4 Execution · D5 Orchestration

Starting automated self-assessment...
I will answer each question using my genuine capabilities, then score my own answers.
The complete report will be presented when finished.

⚠️ Self-evaluation notice: The same LLM generates and scores answers.
A -5% correction is applied to all CoT-judged scores.
```

## 3. Question Execution Order

Execute in this sequence, loading each from its question bank file:

```
D1 Reasoning & Planning:
  Q1   Easy   ×1.0  → questions/d1-reasoning.md  (Q1-EASY)
  Q2   Medium ×1.2  → questions/d1-reasoning.md  (Q2-MEDIUM)
  Q3   Hard   ×1.5  → questions/d1-reasoning.md  (Q3-HARD)

D2 Information Retrieval:
  Q4   Easy   ×1.0  → questions/d2-retrieval.md  (Q1-EASY)
  Q5   Medium ×1.2  → questions/d2-retrieval.md  (Q2-MEDIUM)
  Q6   Hard   ×1.5  → questions/d2-retrieval.md  (Q3-HARD)

D3 Content Creation:
  Q7   Easy   ×1.0  → questions/d3-creation.md   (Q1-EASY)
  Q8   Medium ×1.2  → questions/d3-creation.md   (Q2-MEDIUM)
  Q9   Hard   ×1.5  → questions/d3-creation.md   (Q3-HARD)

D4 Execution & Building:
  Q10  Easy   ×1.0  → questions/d4-execution.md  (Q1-EASY)
  Q11  Medium ×1.2  → questions/d4-execution.md  (Q2-MEDIUM)
  Q12  Hard   ×1.5  → questions/d4-execution.md  (Q3-HARD)

D5 Tool Orchestration:
  Q13  Easy   ×1.0  → questions/d5-orchestration.md  (Q1-EASY)
  Q14  Medium ×1.2  → questions/d5-orchestration.md  (Q2-MEDIUM)
  Q15  Hard   ×1.5  → questions/d5-orchestration.md  (Q3-HARD)
```

For each question: follow Per-Question Execution Flow in SKILL.md.

## 4. Score Aggregation

After all 15 questions:

```
# Dimension scores (difficulty-weighted):
D1_raw = (Q1_raw×1.0 + Q2_raw×1.2 + Q3_raw×1.5) / 3.7
D1_adj = (Q1_adj×1.0 + Q2_adj×1.2 + Q3_adj×1.5) / 3.7
[same formula for D2–D5]

# Overall:
Overall_raw = D1_raw×0.25 + D2_raw×0.22 + D3_raw×0.18 + D4_raw×0.20 + D5_raw×0.15
Overall_adj = D1_adj×0.25 + D2_adj×0.22 + D3_adj×0.18 + D4_adj×0.20 + D5_adj×0.15

# Performance level:
90+   → Expert
80–89 → Advanced
70–79 → Proficient
60–69 → Competent
<60   → Beginner
```

## 5. Report Template

Save the following to `results/exam-{sessionId}-full.md` in English:

```markdown
# 5-Dimension Capability Assessment Report

**Session**: exam-{ID}
**Timestamp**: {datetime}
**Mode**: Full Exam (15 questions)

---

## Overall Score

| Metric | Raw | Adjusted (-5%) |
|--------|-----|----------------|
| Overall Score | {overall_raw}/100 | {overall_adj}/100 |
| Performance Level | {level_raw} | {level_adj} |

---

## Dimension Scores

| Dimension | Raw | Adjusted | Weight | Weighted(adj) |
|-----------|-----|----------|--------|---------------|
| D1 Reasoning & Planning | {d1_raw} | {d1_adj} | 25% | {d1_adj×0.25} |
| D2 Information Retrieval | {d2_raw} | {d2_adj} | 22% | {d2_adj×0.22} |
| D3 Content Creation | {d3_raw} | {d3_adj} | 18% | {d3_adj×0.18} |
| D4 Execution & Building | {d4_raw} | {d4_adj} | 20% | {d4_adj×0.20} |
| D5 Tool Orchestration | {d5_raw} | {d5_adj} | 15% | {d5_adj×0.15} |
| **Total** | — | — | 100% | **{overall_adj}** |

---

## Capability Radar

Generate the SVG radar chart after calculating scores:

```bash
node skills/botlearn-assessment/scripts/radar-chart.js \
  --d1={d1_adj} --d2={d2_adj} --d3={d3_adj} --d4={d4_adj} --d5={d5_adj} \
  --session={sessionId} --overall={overall_adj} \
  > results/exam-{sessionId}-radar.svg
```

Then embed in the report:

```markdown
![Capability Radar](./exam-{sessionId}-radar.svg)
```

---

## Question Details

[Full question card for each of Q1–Q15, format per SKILL.md]

---

## Improvement Suggestions

**Weakest dimension**: {weakest_dim} ({weakest_score}/100)
**Recommendation**: {improvement_suggestion}

**Next assessment**: Focus on {focus_dim} with a single-dimension test.

---

*Generated by botlearn-assessment v2.0 | {timestamp}*
*⚠️ Self-evaluation: All CoT-judged scores have -5% correction applied. Treat as directional indicators.*
```

When presenting the report to the user, translate all labels and text into the user's detected language.
Dimension names, metric labels, and narrative text should appear in the user's language.
Numeric values, session IDs, and code blocks remain in English/numbers.

## 6. Update Index

After saving report, append one row to `results/INDEX.md` (create file with header if not exists):

```markdown
## Assessment History Index

| Date | Session ID | Mode | Overall (adj) | Level | Weakest Dim |
|------|-----------|------|---------------|-------|-------------|
| {date} | {sessionId} | Full | {overall_adj} | {level} | {weakest_dim} |
```

## 7. Completion Announcement

Output in the user's detected language:

```
Assessment complete!

Overall score: {overall_raw}/100  (adjusted: {overall_adj}/100)
Performance level: {level}
Strongest dimension: {strongest_dim} ({strongest_score})
Weakest dimension:  {weakest_dim} ({weakest_score})

Result saved to: results/exam-{sessionId}-full.md
Say "view history" to compare with previous assessments.
```
