---
flow: dimension-exam
parent: SKILL.md
scope: single dimension, 3 questions
---

# Dimension Exam Flow

## 1. Session Setup

```
sessionId  = "exam-{YYYYMMDD}-{HHmm}"
dimension  = D{N}  (1–5, identified from user intent)
totalQ     = 3
resultFile = "results/exam-{sessionId}-d{N}.md"
userLang   = detected from activation message (used for all user-facing output)
```

### Dimension Detection

| User says | Dimension |
|-----------|-----------|
| D1 / reasoning / planning / 知识与推理 / 推理 | D1 |
| D2 / retrieval / search / 信息检索 / 检索 | D2 |
| D3 / creation / writing / 内容创作 / 写作 | D3 |
| D4 / execution / code / build / 执行与构建 / 代码 | D4 |
| D5 / orchestration / tools / 工具编排 / 工具 | D5 |

If unclear, ask in the user's detected language:
  (offer the 5 dimension options for selection)

## 2. Pre-exam Announcement

Output in user's detected language:

```
# D{N} {Dimension Name} — Single Dimension Assessment

Session: exam-{ID}
Dimension: D{N} {Dimension Name}
Questions: 3 (Easy + Medium + Hard)

Starting assessment...
```

## 3. Question Loading

Load 3 questions from the corresponding file:

```
D1 → questions/d1-reasoning.md
D2 → questions/d2-retrieval.md
D3 → questions/d3-creation.md
D4 → questions/d4-execution.md
D5 → questions/d5-orchestration.md
```

Execute order: Easy → Medium → Hard.
For each question: follow Per-Question Execution Flow in SKILL.md.
Output each question card in the user's detected language.

## 4. Dimension Score Calculation

```
DimScore_raw = (Q1_raw×1.0 + Q2_raw×1.2 + Q3_raw×1.5) / 3.7
DimScore_adj = (Q1_adj×1.0 + Q2_adj×1.2 + Q3_adj×1.5) / 3.7
```

## 5. Report Template

Save to `results/exam-{sessionId}-d{N}.md` in English:

```markdown
# D{N} {Dimension Name} — Single Dimension Assessment Report

**Session**: exam-{ID}
**Timestamp**: {datetime}
**Dimension**: D{N} {Dimension Name} (weight: {weight}%)

---

## Dimension Score

| Metric | Raw | Adjusted (-5%) |
|--------|-----|----------------|
| {Dimension Name} | {dim_raw}/100 | {dim_adj}/100 |
| Performance Level | {level_raw} | {level_adj} |

---

## Question Breakdown

| Question | Difficulty | Multiplier | Raw | Adjusted |
|----------|-----------|-----------|-----|----------|
| Q1 | Easy | ×1.0 | {q1_raw} | {q1_adj} |
| Q2 | Medium | ×1.2 | {q2_raw} | {q2_adj} |
| Q3 | Hard | ×1.5 | {q3_raw} | {q3_adj} |
| **Weighted avg** | | | **{dim_raw}** | **{dim_adj}** |

---

## Question Details

[Q1 full question card]
[Q2 full question card]
[Q3 full question card]

---

## Diagnosis & Suggestions

**Performance analysis**: {performance_analysis}
**Improvement suggestion**: {improvement_suggestion}

---

*Generated by botlearn-assessment v2.0 | {timestamp}*
```

When presenting the report to the user, translate all labels and narrative text into the user's detected language.
Numeric values, session IDs, and code blocks remain in English/numbers.

## 6. Update Index

Append to `results/INDEX.md` (create with header if not exists):

```
| {date} | {sessionId} | D{N} {Dimension Name} | {dim_adj} | {level} | — |
```

## 7. Completion Announcement

Output in the user's detected language:

```
D{N} {Dimension Name} assessment complete!

Dimension score: {dim_raw}/100  (adjusted: {dim_adj}/100)
Performance level: {level}

Easy:   {q1_adj}/100
Medium: {q2_adj}/100
Hard:   {q3_adj}/100

Result saved to: results/exam-{sessionId}-d{N}.md
Say "full exam" to run the complete 5-dimension assessment.
```
