import { exec } from "node:child_process";

function execAsync(command, options = {}) {
  return new Promise((resolve) => {
    exec(command, options, (err, stdout) => {
      if (err) resolve({ ok: false, output: "" });
      else resolve({ ok: true, output: stdout.toString().trim() });
    });
  });
}

export async function collect(config) {
  const ds = config.devServers;
  if (!ds) return [];

  const grep = ds.processGrep || "next dev";
  const basePath = ds.projectBasePath || "/";

  const res = await execAsync(
    `ps aux | grep '${grep}' | grep -v grep | grep 'node.*next'`,
    { timeout: 3000 }
  );

  if (!res.ok || !res.output) return [];

  const ps = res.output.split("\n").filter(Boolean);
  const seen = new Set();

  return ps
    .map((line) => {
      const parts = line.split(/\s+/);
      const pid = parts[1];
      const portMatch = line.match(/--port\s+(\d+)/);
      const port = portMatch ? portMatch[1] : "3000";
      if (seen.has(port)) return null;
      seen.add(port);
      const escapedBase = basePath.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
      const dirMatch = line.match(new RegExp(`${escapedBase}([^/]+)`));
      const project = dirMatch ? dirMatch[1] : "unknown";
      return {
        project,
        status: "running",
        url: `${config.hostIp || "127.0.0.1"}:${port}`,
        pid: parseInt(pid),
      };
    })
    .filter(Boolean);
}
