# bot-status-api

A lightweight, zero-dependency status API for OpenClaw bots. Exposes runtime health, service connectivity, cron jobs, installed skills, and system metrics as JSON.

Built for dashboard integration — but works great as a standalone health endpoint too.

## Features

- **Bot Core** — Online status, model, context usage, uptime, heartbeat timing
- **Services** — Configurable health checks (HTTP, CLI, file-based)
- **Email** — Unread counts from any provider (himalaya, gog, etc.)
- **Cron Jobs** — Reads directly from OpenClaw's job store
- **Docker** — Container health via Portainer API
- **Dev Servers** — Auto-detects running dev servers
- **Skills** — Lists installed/available OpenClaw skills
- **System** — CPU, RAM, Disk from `/proc`

## Quick Start

```bash
# Clone
git clone https://github.com/youruser/bot-status-api.git
cd bot-status-api

# Configure
cp config.example.json config.json
# Edit config.json with your services, paths, credentials

# Run
node server.js
```

## Endpoints

| Endpoint | Description |
|----------|-------------|
| `GET /status` | Full status JSON (cached, ~10ms response) |
| `GET /health` | Simple health check |

## Configuration

Everything lives in `config.json` (gitignored). See `config.example.json` for the full schema.

### Service Check Types

| Type | What it does | Key config |
|------|-------------|------------|
| `http` | Fetch URL, expect HTTP 200 | `url`, `healthPath`, `method`, `headers`, `body` |
| `command` | Run shell command, expect exit 0 | `command`, `timeout` |
| `file-exists` | Check if path exists | `path` |

### Key Config Fields

| Field | Description |
|-------|-------------|
| `name` | Your bot's name |
| `workspace` | Path to OpenClaw workspace |
| `openclawHome` | Path to `.openclaw` directory |
| `model` | Current model name |
| `skillDirs` | Array of paths to scan for skills |
| `services` | Array of service health checks |
| `email` | Array of email accounts to monitor |
| `docker` | Portainer connection details |
| `devServers` | Process detection config |
| `cache.ttlMs` | Background refresh interval (default: 10s) |

## Production Deployment

### systemd (recommended)

```ini
# ~/.config/systemd/user/bot-status.service
[Unit]
Description=Bot Status API
After=network.target

[Service]
Type=simple
WorkingDirectory=/path/to/bot-status-api
ExecStart=/usr/bin/node server.js
Restart=always
RestartSec=5
Environment=PORT=3200
Environment=HOME=/home/youruser

[Install]
WantedBy=default.target
```

```bash
systemctl --user daemon-reload
systemctl --user enable --now bot-status
loginctl enable-linger $USER
```

## Architecture

- **Zero dependencies** — Node.js built-ins only
- **Non-blocking** — All collectors use async `exec`, never `execSync`
- **Background refresh** — Cache updates on interval; requests always served instantly from cache
- **Modular collectors** — Each data source is a separate module in `collectors/`

```
bot-status-api/
├── server.js              # HTTP server + cache + routing
├── config.json            # Your config (gitignored)
├── config.example.json    # Template
├── collectors/
│   ├── core.js            # Bot status, context, heartbeat
│   ├── services.js        # Dynamic service health checks
│   ├── email.js           # Email unread counts
│   ├── docker.js          # Container health via Portainer
│   ├── devservers.js      # Dev server detection
│   ├── skills.js          # Installed OpenClaw skills
│   └── system.js          # CPU, RAM, Disk
└── SKILL.md               # OpenClaw skill definition
```

## License

MIT
