---
name: bot-status-api
description: "Deploy a lightweight status API that exposes your OpenClaw bot's runtime health, service connectivity, cron jobs, skills, system metrics, and more. Use when setting up a monitoring dashboard, health endpoint, or status page for an OpenClaw agent. Supports any services via config (HTTP checks, CLI commands, file checks). Zero dependencies — Node.js only."
---

# Bot Status API

A configurable HTTP service that exposes your OpenClaw bot's operational status as JSON. Designed for dashboard integration, monitoring, and transparency.

## What It Provides

- **Bot Core:** Online status, model, context usage, uptime, heartbeat timing
- **Services:** Health checks for any HTTP endpoint, CLI tool, or file path
- **Email:** Unread counts from any email provider (himalaya, gog, etc.)
- **Cron Jobs:** Reads directly from OpenClaw's `cron/jobs.json`
- **Docker:** Container health via Portainer API
- **Dev Servers:** Auto-detects running dev servers by process grep
- **Skills:** Lists installed and available OpenClaw skills
- **System:** CPU, RAM, Disk metrics from `/proc`

## Setup

### 1. Copy the service files

Copy `server.js`, `collectors/`, and `package.json` to your desired location.

### 2. Create config.json

Copy `config.example.json` to `config.json` and customize:

```json
{
  "port": 3200,
  "name": "MyBot",
  "workspace": "/path/to/.openclaw/workspace",
  "openclawHome": "/path/to/.openclaw",
  "cache": { "ttlMs": 10000 },
  "model": "claude-sonnet-4-20250514",
  "skillDirs": ["/path/to/openclaw/skills"],
  "services": [
    { "name": "myservice", "type": "http", "url": "http://...", "healthPath": "/health" }
  ]
}
```

### Service Check Types

| Type | Description | Config |
|------|-------------|--------|
| `http` | Fetch URL, check HTTP 200 | `url`, `healthPath`, `method`, `headers`, `body` |
| `command` | Run shell command, check exit 0 | `command`, `timeout` |
| `file-exists` | Check path exists | `path` |

### 3. Run

```bash
node server.js
```

### 4. Persist (systemd user service)

```ini
# ~/.config/systemd/user/bot-status.service
[Unit]
Description=Bot Status API
After=network.target

[Service]
Type=simple
WorkingDirectory=/path/to/bot-status
ExecStart=/usr/bin/node server.js
Restart=always
RestartSec=5
Environment=PORT=3200
Environment=HOME=/home/youruser
Environment=PATH=/usr/local/bin:/usr/bin:/bin

[Install]
WantedBy=default.target
```

```bash
systemctl --user daemon-reload
systemctl --user enable --now bot-status
loginctl enable-linger $USER  # survive logout
```

### 5. Context/Vitals from OpenClaw

The bot should periodically write vitals to `heartbeat-state.json` in its workspace:

```json
{
  "vitals": {
    "contextPercent": 62,
    "contextUsed": 124000,
    "contextMax": 200000,
    "model": "claude-opus-4-5",
    "updatedAt": 1770304500000
  }
}
```

Add this to your HEARTBEAT.md so the bot updates it each heartbeat cycle.

## Endpoints

| Endpoint | Description |
|----------|-------------|
| `GET /status` | Full status JSON (cached) |
| `GET /health` | Simple `{"status":"ok"}` |

## Architecture

- **Zero dependencies** — Node.js built-ins only (`http`, `fs`, `child_process`)
- **Non-blocking** — All shell commands use async `exec`, never `execSync`
- **Background refresh** — Cache refreshes on interval, requests always served from cache instantly (~10ms)
- **Config-driven** — Everything in `config.json`, no hardcoded values
