# Visitor Tips — Boston

## Getting Around

### The T (MBTA Subway)
- **Four lines**: Red, Orange, Blue, Green
- **Green Line quirk**: It's a trolley, slower, branches into B/C/D/E
- **CharlieCard**: Reloadable card, cheaper than cash ($2.40 vs $2.90)
- **Get a CharlieCard**: At Downtown Crossing, Harvard, airport stations
- **Hours**: 5am-12:30am roughly. No true 24-hour service.
- **Weekend track work**: Common. Check MBTA.com before Saturday/Sunday travel.

### Walking
Boston is America's most walkable city. Most tourist areas within 30-minute walk of each other.

**Useful walks:**
- Boston Common to North End: 20 min
- Harvard Square to MIT: 25 min along river
- Back Bay to Seaport: 25 min

**Watch out:**
- Cobblestones (Beacon Hill, North End) — wear good shoes
- Aggressive drivers at crosswalks

### Ride-hailing
- Uber and Lyft both work well
- Logan Airport has designated pickup areas (follow signs)
- Surge pricing during games, bad weather

### Biking
- **Bluebikes**: City bike share, stations everywhere
- $2.95 per ride (30 min) or day passes
- Charles River paths are beautiful
- Watch for car doors in bike lanes

## Money Matters

### Tipping
- Restaurants: 18-20% standard
- Bars: $1-2 per drink
- Hotel housekeeping: $3-5/night
- Uber/Lyft: Optional but appreciated

### Cash Still Matters
Some Boston institutions are cash-only:
- Regina Pizzeria (North End)
- Santarpio's Pizza (East Boston)
- Some dive bars
- Street performers, farmer's markets

### Sales Tax
- 6.25% on most goods
- No tax on clothing under $175
- Restaurant meals: 7% (6.25% + 0.75% local)

## Weather Preparation

### Winter (Dec-Mar)
**Pack:**
- Heavy waterproof coat
- Waterproof boots (sidewalks get slushy)
- Layers (buildings are overheated)
- Gloves, hat, scarf

**Know:**
- Wind chill makes 25F feel like 5F
- The T runs slowly in snow
- Heated underground walkways connect some buildings downtown

### Summer (Jun-Aug)
**Pack:**
- Light breathable clothes
- Sunscreen
- Light rain jacket (afternoon storms)

**Know:**
- Humidity can be brutal
- AC inconsistent in old buildings
- Subway platforms are hot

### Spring/Fall
**Pack:**
- Layers (40-degree morning, 70-degree afternoon possible)
- Light jacket always

## Cultural Notes

### Boston Directness
- Bostonians are direct, not rude
- Don't expect Southern charm or Midwest friendliness
- Locals warm up but initial interactions are brief

### Jaywalking
- Everyone does it
- Follow local traffic rhythm
- Tourists sometimes get tickets (rare but happens)

### Sports
- Don't mock Boston sports teams
- Don't wear Yankees gear (you will get comments)
- Game days: plan around traffic/crowds

### Townies vs. Transplants
Boston has strong neighborhood identities. Lifelong residents ("townies") in Southie, Charlestown, Dorchester have distinct culture. Be respectful, don't gentrify too hard.

## Food Tips

### Ordering Seafood
- "Lobster roll" comes two ways:
  - **Maine style**: Cold, mayo-based (most common)
  - **Connecticut style**: Hot, butter-based
- Specify if you have preference
- Legal Sea Foods: tourist trap but reliable quality
- James Hook, Yankee Lobster: better value

### Clam Chowder
- Always "New England" (cream-based) here
- Never order "Manhattan" (tomato-based) chowder in Boston
- Pronounced "chowdah" — don't mock it

### Coffee Culture
- Dunkin' (not Dunkin' Donuts) is religion here
- Locals order "regular" = cream and sugar
- "Iced" is year-round, even in blizzards
- Fancy coffee: George Howell, Pavement, Gracenote

### North End Dining
- Make reservation for popular spots
- Cash only at some places (Regina's, Giacomo's)
- Skip: Anything on main Hanover Street drag
- Do: Ask locals or hotel concierge for current favorites

## Day Trips

### Cape Cod (1-2 hours)
**Getting there:** Drive (1.5h without traffic) or bus (Plymouth & Brockton)
**Best for:** Summer beaches, seafood, quaint towns
**Where:**
- Provincetown: LGBTQ-friendly, artsy, far tip
- Chatham: Classic New England charm
- Hyannis: Kennedy connections, ferry to islands

### Salem (30-45 min)
**Getting there:** Commuter Rail from North Station
**Reality:** Witch tourism is very kitschy
**Worth it:** Peabody Essex Museum (world-class), architecture
**When:** Avoid October unless you want Halloween chaos

### Newport, RI (1.5 hours)
**Getting there:** Drive or bus
**Best for:** Gilded Age mansions, sailing, summer vibes
**Do:** Cliff Walk, The Breakers mansion tour

### Concord/Lexington (30 min)
**Getting there:** Drive or commuter rail + bike
**Best for:** Revolutionary War history, literary history
**See:** Minute Man park, Walden Pond, Louisa May Alcott's home

### Portland, Maine (2 hours)
**Getting there:** Drive or Amtrak Downeaster
**Best for:** Food scene, working waterfront, lobster
**Reality:** Better lobster rolls than Boston, honestly

## Safety

### Generally Safe But...
- **Pickpockets**: Faneuil Hall, crowded T platforms
- **Phone snatching**: Don't use phone at T door opening
- **Bike theft**: Lock both wheels, thieves are skilled
- **Car break-ins**: Don't leave anything visible

### Areas with Caution
- **Late night T stations**: Fine but stay aware
- **Methadone Mile** (Mass/Cass area): Avoid, especially at night
- **Some parks after dark**: Boston Common, Esplanade — use main paths

### Emergency
- **911**: Police, fire, ambulance
- **MBTA Police**: 617-222-1212
- **Non-emergency**: 311

## Connectivity

### WiFi
- Free in most cafes (buy something)
- Boston Public Library: Free, no purchase needed
- Starbucks: Ubiquitous free WiFi

### Cell Coverage
All major carriers work fine. T tunnels have coverage on most of Red/Orange lines.

### SIM Cards
- T-Mobile, AT&T stores downtown
- Or: eSIM apps (Airalo, Holafly) for international visitors

## Practical Reminders

1. **Uber from Logan**: Follow airport signs to ride-share pickup. It's organized but takes 10-15 min to get there.

2. **Luggage storage**: No lockers at most T stations. Vertoe, Bounce apps connect to shops that hold bags ($6-10/day).

3. **Pharmacy**: CVS everywhere, 24-hour location in Back Bay (Boylston St).

4. **Restrooms**: Hard to find. Best bets: Quincy Market, malls, hotel lobbies, Starbucks.

5. **Electric outlets**: 120V, Type A/B plugs. Bring adapter if from outside North America.

6. **Last call**: 2am everywhere. The T stops around 12:30am, plan accordingly.

7. **Sunday alcohol**: Liquor stores open at noon, not earlier.

8. **Grocery**: Star Market, Trader Joe's, Whole Foods all downtown. Roche Bros for local chain.
