# Visitor Lodging — Boston

## Best Areas to Stay

### Back Bay / Copley
**Best for:** First-time visitors, walkability, shopping
- Walking distance to Newbury Street, Freedom Trail start, Public Garden
- T access: Green Line (Copley), Orange Line (Back Bay)
- Price: $250-450/night mid-range, $500+ luxury

**Top picks:**
- Colonnade Hotel — rooftop pool, good value
- Lenox Hotel — historic charm
- Fairmont Copley Plaza — classic luxury

### Downtown / Financial District
**Best for:** Business travelers, Freedom Trail focus
- Central location, easy T access to everywhere
- Quieter at night (business district)
- Price: $200-350/night

**Top picks:**
- Godfrey Hotel — boutique, good rooftop bar
- Ames Boston — design-forward
- Club Quarters — reliable business hotel

### Seaport
**Best for:** Modern vibe, restaurants, waterfront
- Newest neighborhood, shiny hotels
- 15-20 min walk to downtown
- Price: $250-400/night

**Top picks:**
- Envoy Hotel — rooftop bar with views
- Yotel Boston — budget-modern hybrid
- Omni Boston — convention center adjacent

### Cambridge
**Best for:** Tech workers, academic visitors, quieter vibe
- Harvard and MIT accessible
- Red Line to downtown (15-20 min)
- Price: $200-350/night

**Top picks:**
- Charles Hotel — Harvard Square classic
- Freepoint Hotel — budget boutique
- Le Meridien Cambridge — MIT area business

### North End
**Best for:** Foodies, Italian neighborhood immersion
- Few hotels but great Airbnb options (check legality)
- Walking distance to waterfront and Freedom Trail
- Loud at night (restaurants, tourists)
- Price: Limited hotels, mostly vacation rentals

### South End
**Best for:** Food scene, LGBTQ-friendly, local feel
- Boston's trendiest dining neighborhood
- Brownstones, art galleries
- Orange Line access, walkable to Back Bay
- Price: Limited hotels, vacation rentals $150-250/night

## Price Tiers

### Budget ($100-180/night)
- **HI Boston Hostel** — Chinatown, dorm or private rooms, clean
- **Found Hotel** — basic but downtown location
- **La Quinta** — Somerville/Cambridge edge, T accessible
- **Revolution Hotel** — South End, hip budget option

### Mid-Range ($180-300/night)
- **Godfrey Hotel** — Financial District, rooftop bar
- **Verb Hotel** — Fenway, retro vibe, near games
- **Boxer Hotel** — North Station, boutique
- **Freepoint Hotel** — Cambridge, modern budget

### Luxury ($350+/night)
- **Four Seasons** — Back Bay, classic luxury
- **Mandarin Oriental** — Back Bay, best spa
- **Boston Harbor Hotel** — Waterfront, views
- **XV Beacon** — Beacon Hill, boutique luxury

## Seasonal Pricing

| Season | Price Impact | Notes |
|--------|-------------|-------|
| September | +30-50% | College move-in, conventions |
| October | +20-40% | Foliage, Head of the Charles |
| Marathon (April) | +50-100% | Book 6+ months ahead |
| Summer | +20-30% | Tourism peak |
| Winter (Jan-Feb) | -20-30% | Lowest prices |
| Graduation (May) | +30-50% | University weekends |

**Book early for:**
- Boston Marathon weekend (third Monday in April)
- Harvard/MIT graduation weeks (late May/early June)
- Red Sox home openers
- New Year's Eve (First Night)

## Airbnb / Short-Term Rentals

**Legal status:** Complex. Boston heavily regulates short-term rentals.

- Must be owner-occupied or registered as investor unit
- Many listings technically illegal
- Enforcement increasing
- Safest: Book licensed/registered units

**Best for:**
- Groups (can be cheaper than multiple hotel rooms)
- Longer stays (1+ weeks)
- Kitchen needs

**Avoid:**
- Unregistered listings in strict buildings (risk of cancellation)
- Anything too good to be true

## Specific Event Lodging

### Red Sox Games
**Stay near Fenway:**
- Verb Hotel (across the street)
- Hotel Commonwealth (upscale)
- Or: Stay anywhere on Green Line (D branch)

**Book early** for Yankees series, playoffs

### Conventions (BCEC)
**Stay in Seaport:**
- Westin Boston Seaport
- Aloft Boston Seaport
- Omni Boston Hotel

### Academic Visits
**Harvard:** Charles Hotel, Sheraton Commander
**MIT:** Le Meridien Cambridge, Marriott Cambridge
**BU:** Hotel Commonwealth, Buckminster Hotel

### Medical Visits
**Mass General:** Liberty Hotel, Beacon Hill area
**Dana-Farber/Brigham:** Inn at Longwood, Holiday Inn Brookline
**Boston Children's:** Same Longwood area

## Neighborhoods to Avoid for Lodging

Not dangerous, but inconvenient for tourists:

- **Dorchester** — Far from sights, limited T
- **Mattapan** — Same issues
- **Roxbury** — Improving but limited lodging options
- **Revere** — Beach town but far from city center
- **Lynn** — Too far, crime concerns

## Transport from Lodging

### Best T Access by Area
| Area | T Line | To Downtown |
|------|--------|-------------|
| Back Bay | Green/Orange | 5-10 min |
| Cambridge | Red | 15-20 min |
| Seaport | Silver (bus) | 10-15 min |
| Somerville | Red/Orange | 15-25 min |
| Brookline | Green (C/D) | 15-20 min |

### From Airport (Logan)
- **Blue Line** to downtown (free shuttle to T)
- **Taxi/Uber**: $25-40 to Back Bay
- **Water taxi**: To Seaport ($15), scenic

## Pro Tips

1. **September 1st**: Avoid this exact date. City is chaos with student move-ins.

2. **Parking**: Don't assume hotel parking. Add $40-60/night if driving.

3. **Historic buildings**: Beautiful but may lack AC, small elevators, thin walls.

4. **Rooftop bars**: Envoy, Godfrey, Colonnade — worth visiting even if not staying.

5. **Last-minute deals**: HotelTonight app works well in Boston off-season.

6. **Loyalty programs**: Marriott and Hilton have most Boston inventory.
