# Visas & Work Permits — Boston

## Overview

Boston has a large international population due to universities and tech companies. Immigration pathways are federal (not state-specific), but Boston's ecosystem provides advantages.

### Boston Advantages
- **University pipeline**: OPT, CPT opportunities
- **Major employers**: Sponsor H-1B regularly
- **Biotech**: Many visa sponsors
- **Research institutions**: J-1 opportunities

---

## Student Pathways

### F-1 Student Visa
For full-time students at accredited institutions.

**Work authorization:**
| Type | Description | Duration |
|------|-------------|----------|
| On-campus | Limited work on campus | During enrollment |
| CPT | Curricular training (internship) | During program |
| OPT | Post-graduation work | 12 months |
| STEM OPT | Extension for STEM fields | Additional 24 months |

### OPT (Optional Practical Training)
Most common pathway from student to worker:

1. Apply through university international office
2. File with USCIS 90 days before graduation
3. Receive EAD (Employment Authorization Document)
4. Work for any employer in your field

**STEM OPT Extension:**
- Additional 24 months (36 total)
- Must be registered STEM field
- Employer must be E-Verify registered
- Training plan required

### Key Timelines
| Milestone | Timeline |
|-----------|----------|
| Apply for OPT | 90 days before to 60 days after graduation |
| OPT processing | 3-5 months |
| Start work | Within 90 days of approval |
| Apply for STEM OPT | Before OPT expires |

---

## Work Visas

### H-1B (Specialty Occupation)
Most common work visa for tech/biotech.

**Requirements:**
- Bachelor's degree (or equivalent)
- Job requires specialized knowledge
- Employer sponsorship
- Lottery selection (if cap-subject)

**Cap and Lottery:**
- 65,000 regular cap
- 20,000 master's cap
- Registration period: March
- Lottery: Late March
- If selected: File by June
- Start date: October 1

**Cap-Exempt Employers:**
Universities and research institutions don't count against cap:
- Harvard, MIT, BU, etc.
- Teaching hospitals
- Nonprofit research orgs

### H-1B Timeline
| Step | When |
|------|------|
| Registration | March 1-20 (approx) |
| Lottery results | Late March |
| File petition | April-June |
| Approval | 3-6 months (or premium: 15 days) |
| Start work | October 1 |

### H-1B Alternatives

**L-1 (Intracompany Transfer)**
- Transfer from foreign office of same company
- No lottery
- Must have worked abroad 1 year

**O-1 (Extraordinary Ability)**
- For those with "extraordinary achievement"
- No lottery, no cap
- High bar to qualify
- Common in academia, some tech

**E-2 (Treaty Investor)**
- Requires investment in US business
- Country-specific treaties
- Good for entrepreneurs from treaty countries

---

## Green Card (Permanent Residence)

### Employment-Based Categories

| Category | Who | Wait Time |
|----------|-----|-----------|
| EB-1 | Extraordinary ability, professors, multinational execs | Shortest |
| EB-2 | Advanced degree or exceptional ability | Varies by country |
| EB-3 | Bachelor's degree | Varies by country |

**Country Backlogs:**
- India, China: Long waits (years to decades for EB-2/EB-3)
- Most other countries: Current or short waits

### PERM Process (EB-2, EB-3)
Typical employer-sponsored green card:

1. **PERM Labor Certification** (6-12 months)
   - Employer proves no qualified US workers
   - Recruitment and documentation

2. **I-140 Petition** (6-12 months)
   - Employer files with USCIS

3. **I-485 Adjustment** (varies wildly)
   - Wait for priority date to be current
   - File for adjustment of status

### EB-1 Categories
For those who qualify, faster path:
- **EB-1A**: Extraordinary ability (self-petition possible)
- **EB-1B**: Outstanding professors/researchers
- **EB-1C**: Multinational managers

---

## Entrepreneur Pathways

### Limited Options
US doesn't have a dedicated "startup visa." Options:

**O-1A (Extraordinary Ability)**
- If you can demonstrate extraordinary achievement
- Awards, media coverage, high salary, etc.

**L-1A (Multinational Manager)**
- If you have a foreign company
- Set up US subsidiary
- Transfer yourself

**E-2 (Treaty Investor)**
- If from treaty country
- Invest substantial funds
- Operate and direct the business

**International Entrepreneur Rule**
- Limited program for startup founders
- Requires significant funding or endorsement
- 2.5 years, renewable

---

## Immigration Lawyers

### Finding a Lawyer
Important for complex cases. Options:

**Major Firms:**
- Mintz Levin (immigration practice)
- WilmerHale
- Berry Appleman & Leiden

**Boutique Immigration:**
- Many Boston-area specialists
- Harvard/MIT area lawyers experienced with academics

**Employer Programs:**
Major employers often provide immigration support.

### Costs
| Service | Typical Cost |
|---------|--------------|
| H-1B (attorney) | $3,000-6,000 |
| H-1B (filing fees) | $2,000-5,000 |
| Green Card (full) | $10,000-20,000+ |
| O-1 | $5,000-10,000 |

---

## University Resources

### International Student Offices
Every university has one:
- Harvard: HIO
- MIT: ISO
- BU: ISSO
- Northeastern: ISSI

**Services:**
- Visa documentation
- OPT processing
- CPT authorization
- Status questions

### Employer Sponsorship
Major Boston employers that sponsor:
- Google, Microsoft, Amazon, Meta
- Biotech companies (Moderna, Biogen, Vertex)
- Hospitals (Mass General, Brigham)
- Universities
- Many tech startups

---

## Practical Tips

### Before Coming
- Understand your visa status and work authorization
- Keep all immigration documents organized
- Know your visa expiration vs. I-94 expiration

### While Here
- Maintain valid status
- Don't overstay
- Keep passport valid (6+ months recommended)
- Keep copies of all documents

### Changing Status
- Can often change within US (file I-539 or I-129)
- Some changes require leaving US
- Consult lawyer for complex situations

### Travel
- Check visa stamp validity before international travel
- Some visa stamps can be renewed in US (limited)
- Reentry may require valid visa stamp
- Automatic revalidation for short trips to Canada/Mexico

---

## Resources

### Government
- USCIS.gov (official source)
- Travel.state.gov (visas)
- ICE.gov (SEVP for students)

### Community
- Immigration legal aid organizations
- University international offices
- Employer HR/legal teams

### Updates
Immigration policy changes frequently. Always verify current rules with:
- USCIS website
- Immigration lawyer
- University international office
