# Transport — Boston

## MBTA Overview ("The T")

America's oldest subway system (1897). Four color-coded lines plus buses, commuter rail, and ferries.

### The Lines

| Line | Route | Key Stops | Notes |
|------|-------|-----------|-------|
| **Red** | Alewife to Ashmont/Braintree | Harvard, Central, Park St, South Station | Most useful, branches south |
| **Orange** | Oak Grove to Forest Hills | North Station, Downtown Crossing, Back Bay | Second most useful |
| **Blue** | Wonderland to Bowdoin | Airport, Aquarium, Government Center | Airport access |
| **Green** | Multiple branches (B/C/D/E) | Copley, Kenmore, Park St | Trolley, slowest |

### Green Line Branches
- **B (Boston College)**: Through Allston/Brighton. Slowest. Avoid if possible.
- **C (Cleveland Circle)**: Through Brookline. Better than B.
- **D (Riverside)**: Through Brookline/Newton. Express sections, faster.
- **E (Heath Street)**: Through Longwood Medical. Runs above ground.

### Fares
- **Single ride**: $2.40 (CharlieCard), $2.90 (cash/ticket)
- **Monthly pass**: $90 (unlimited bus/subway)
- **Weekly pass**: Available via app
- **Commuter rail**: $2.40-$13.25 depending on zone

### CharlieCard
Reloadable plastic card. Get at:
- Downtown Crossing station (staffed kiosk)
- Harvard station
- Airport
- Some convenience stores

**Always use CharlieCard** — saves $0.50 per ride and faster boarding.

### Hours
- **Weekdays**: ~5am to 12:30am
- **Weekends**: ~6am to 12:30am
- **No overnight service** (unlike NYC)

Plan your night accordingly. After 12:30am = rideshare only.

---

## MBTA Realities

### Reliability Issues
The T has... problems. Be prepared:
- **Winter**: Delays common during snow/cold
- **Signal problems**: Regular occurrence
- **Disabled trains**: Happens weekly
- **Slow zones**: Track maintenance causes delays

### Survival Tips
1. **Build in buffer time** — 15+ min for important appointments
2. **Check @MBTA on Twitter** — real-time alerts
3. **Download MBTA app** — track delays
4. **Have backup plan** — know bus alternatives

### Rush Hour
- **Peak times**: 7-9am, 5-7pm
- **Most crowded**: Red Line (Harvard to Downtown), Orange Line (Oak Grove inbound)
- **Avoid if possible**: Park Street transfers during rush

---

## Buses

### When Buses Help
- Areas not served by subway
- Crosstown routes (connecting lines)
- Late night (some buses run later than T)

### Useful Routes
| Route | From-To | Why Useful |
|-------|---------|------------|
| 1 | Harvard - MIT - BU | Mass Ave corridor |
| 66 | Harvard - Allston - Brookline | Crosstown |
| 77 | Harvard - Porter - Arlington | North |
| CT2 | Kendall - BU Medical | Crosstown |

### Bus Fares
- Same as subway with CharlieCard
- Free transfer from subway to bus within 2 hours

---

## Commuter Rail

For suburbs and regional travel. Runs from North Station and South Station.

### From North Station
- Lowell, Haverhill, Newburyport (north)
- Fitchburg (west)

### From South Station
- Providence, RI
- Worcester
- Plymouth, Cape Cod
- Framingham

### Fares
Zone-based, $2.40 (Zone 1A) to $13.25 (furthest zones)

### Frequency
- Peak hours: Every 20-30 min
- Off-peak: Every 1-2 hours
- Weekends: Limited service

---

## Ride-Hailing

### Apps
- **Uber**: Works everywhere
- **Lyft**: Works everywhere
- **Local taxis**: Boston Cab, Metro Cab (apps available)

### Typical Costs
| Route | Uber/Lyft |
|-------|-----------|
| Back Bay to Airport | $25-40 |
| Cambridge to Seaport | $20-30 |
| Somerville to Downtown | $15-25 |

### Surge Pricing
Common during:
- Red Sox games
- Bad weather
- Bar close (2am)
- Rush hour

### Airport Pickup
Logan has designated rideshare pickup areas. Follow signs to your terminal's pickup zone. Apps will guide you.

---

## Biking

### Bluebikes (Bike Share)
City bike share with 400+ stations.

**Pricing:**
- Single ride: $2.95 (30 min)
- Day pass: $10
- Monthly: $20
- Annual: $119

**How it works:**
1. Download Bluebikes app
2. Unlock bike at any station
3. Ride
4. Dock at any station

### Bike Infrastructure
- Charles River paths: Excellent, scenic
- Cambridge: Best bike lanes in metro
- Boston proper: Improving but patchy
- Protected lanes: Growing network

### Bike Rules
- Required: Helmet under 16 (recommended for all)
- Required: Lights at night
- Allowed: Riding on roads (most)
- Not allowed: Sidewalks in business districts

### Bike Theft
Serious problem. Always:
- Use U-lock (not cable)
- Lock both wheels and frame
- Lock inside if possible
- Register bike with police

---

## Driving

### Should You Have a Car?

**Don't need a car if:**
- Living near T (Back Bay, Cambridge, Somerville)
- Working along T line
- Budget-conscious (parking expensive)

**Might want a car if:**
- Living in suburbs
- Working outside transit network
- Frequent trips outside city
- Family with kids

### Parking Reality

**Street Parking:**
- Resident permit required ($25/year)
- Waitlists in popular areas
- Snow emergency = instant tow
- Meters expensive ($2-4/hour)

**Garage Parking:**
- Monthly: $200-500 depending on area
- Back Bay/Beacon Hill: $400-500
- Cambridge: $200-350
- Seaport: $300-400

### Traffic
Boston has consistently worst traffic in US (per capita). Avoid:
- I-93 during rush hour
- Storrow Drive (local highway) during rush
- Route 2 inbound mornings
- Game days near Fenway

### Boston Driving Quirks
- **Rotaries**: Traffic circles. Yield to traffic in circle.
- **Aggressive drivers**: Boston drivers are... assertive
- **Confusing streets**: Not a grid. GPS essential.
- **Massholes**: Local term for aggressive MA drivers

---

## Airport (Logan)

### Getting There

**By T (Blue Line):**
- Free shuttle from Airport station to terminals
- Total time from downtown: 30-40 min
- Cheapest option: $2.40

**By Rideshare:**
- $25-40 from Back Bay
- Designated pickup areas at each terminal

**By Taxi:**
- Flat rates from some areas
- Metered otherwise
- Similar to rideshare cost

**By Water Taxi:**
- From Seaport/Waterfront
- $15, scenic, 10 minutes
- Limited schedule

### Terminal Tips
- **Terminal A**: Delta
- **Terminal B**: United, others
- **Terminal C**: JetBlue
- **Terminal E**: International

Free shuttle connects all terminals.

---

## Regional Travel

### To New York
| Mode | Time | Cost |
|------|------|------|
| Amtrak Acela | 3.5 hours | $100-200 |
| Amtrak Regional | 4.5 hours | $50-100 |
| Bus (Greyhound, Bolt) | 4-5 hours | $20-50 |
| Driving | 4-5 hours | Gas + tolls |
| Flying | 1 hour (+ airport time) | $100-200 |

### To Providence
- Train: 45 min, $12
- Drive: 1 hour

### To Cape Cod
- Drive: 1.5-3 hours (traffic dependent)
- Bus: Plymouth & Brockton from South Station
- Ferry: From Boston to Provincetown (seasonal)

### To Maine
- Drive: Portland 2 hours, Acadia 5 hours
- Train: Amtrak Downeaster to Portland

---

## Transport Apps

| App | Purpose |
|-----|---------|
| MBTA | Official T app, schedules |
| Transit | Real-time arrivals, multi-modal |
| Citymapper | Best overall navigation |
| Google Maps | Reliable routing |
| Bluebikes | Bike share |
| Uber/Lyft | Rideshare |
