# Tech Industry — Boston

## Overview

Greater Boston is a **top-5 US tech hub**, with unique strengths in biotech, healthcare tech, and robotics. Different flavor than Bay Area — more enterprise, less consumer.

### Boston Tech DNA
- **Harvard/MIT pipeline**: Constant talent and startup flow
- **Biotech capital**: More biotech than anywhere on Earth
- **Healthcare tech**: World's best hospitals drive innovation
- **Enterprise focus**: B2B over B2C
- **Defense/aerospace**: Raytheon, Draper, Lincoln Labs

---

## Tech Geography

### Kendall Square (Cambridge)
**The center of Boston tech.** Biotech companies, Google, Microsoft, startups.

| What's Here | Examples |
|-------------|----------|
| Big Tech | Google, Microsoft, Amazon, Meta |
| Biotech giants | Moderna, Biogen, Vertex |
| Startups | Hundreds |
| VC firms | Major presence |

**Vibe**: Corporate but innovative. Expensive. New buildings.

### Seaport / Innovation District
Newer tech hub, Amazon HQ2 overflow, startups.

| What's Here | Examples |
|-------------|----------|
| Amazon | Large office |
| Wayfair | HQ |
| Startups | MassMutual, Rapid7 |

**Vibe**: Corporate, shiny, somewhat sterile.

### Route 128 Corridor
Traditional tech belt (Waltham, Burlington, Lexington).

| What's Here | Examples |
|-------------|----------|
| Enterprise | Dell EMC, Raytheon, Oracle |
| Biotech | Thermo Fisher |
| Legacy companies | Many |

**Vibe**: Suburban, car-dependent, older feel.

### Back Bay / Financial District
More fintech, consulting, corporate offices.

| What's Here | Examples |
|-------------|----------|
| Fintech | Fidelity, State Street |
| Consulting | McKinsey, BCG, Bain |
| Enterprise | HubSpot, Pegasystems |

---

## Industries

### Biotech/Pharma
**Boston = biotech capital of the world.**

| Company | Focus | Size |
|---------|-------|------|
| Moderna | mRNA (vaccines) | 3000+ |
| Biogen | Neuroscience | 7000+ |
| Vertex | Rare diseases | 4000+ |
| Sarepta | Genetic therapies | 1500+ |
| Blueprint | Oncology | 500+ |

**Why Boston**: MIT/Harvard research, hospital partnerships, concentrated talent.

### Healthcare Tech
Hospitals drive innovation.

| Company | Focus |
|---------|-------|
| Athenahealth | EHR |
| Flatiron Health | Oncology data |
| Devoted Health | Medicare |
| Buoy Health | AI diagnosis |

### Pure Software
Less dominant than Bay Area, but strong.

| Company | Focus | Size |
|---------|-------|------|
| HubSpot | Marketing SaaS | 5000+ |
| Wayfair | E-commerce | 10000+ |
| Toast | Restaurant SaaS | 4000+ |
| Rapid7 | Cybersecurity | 2000+ |
| Datadog | Monitoring | 2000+ |
| DraftKings | Sports betting | 2000+ |

### Robotics/Hardware
Strong presence due to MIT influence.

| Company | Focus |
|---------|-------|
| Boston Dynamics | Robotics |
| iRobot | Consumer robotics |
| Locus Robotics | Warehouse |
| Desktop Metal | 3D printing |

---

## Compensation

### Software Engineering

| Level | Base | Total Comp |
|-------|------|------------|
| New Grad | $100-130K | $110-150K |
| Mid (3-5 yrs) | $130-170K | $150-200K |
| Senior (5-8 yrs) | $160-200K | $180-260K |
| Staff (8+ yrs) | $190-240K | $220-320K |
| Principal | $220-280K | $280-400K |

### By Company Type

| Type | Comp vs. Bay Area |
|------|-------------------|
| Big Tech (Google, Meta) | 90-95% of Bay Area |
| Biotech | Competitive, strong equity |
| Startups | Variable, equity-heavy |
| Enterprise | Lower base, stable |

### Biotech/Pharma

| Role | Range |
|------|-------|
| Research Scientist | $80-150K |
| Senior Scientist | $120-180K |
| Principal Scientist | $160-250K |
| Director | $200-350K |
| VP | $300-500K+ |

---

## Job Market

### Demand Areas
- **Machine Learning/AI**: High demand
- **Biotech/computational biology**: Very hot
- **Cloud/DevOps**: Steady demand
- **Security**: Growing
- **Data engineering**: Strong

### Hiring Patterns
- **Big Tech**: Standard SWE interviews
- **Biotech**: Domain knowledge valued
- **Startups**: Move fast, varied processes
- **Enterprise**: More traditional

### Getting Hired

**Networking matters.** Boston tech scene is smaller than Bay Area; relationships count.

**Key events:**
- Cambridge Innovation Center events
- Boston New Tech meetups
- Industry conferences (HLTH, etc.)
- Harvard/MIT events (many open to public)

---

## Work Culture

### Boston vs. Bay Area

| Aspect | Boston | Bay Area |
|--------|--------|----------|
| Pace | Steady, less frantic | Fast, burnout culture |
| Work-life | Better balance typical | Varies widely |
| Remote | Hybrid common | More remote-friendly |
| Dress | Slightly more formal | Very casual |
| After-work | Goes home earlier | More work socializing |

### Hybrid/Remote
Post-COVID reality:
- Most companies: 2-3 days in office
- Some fully remote
- Few fully in-office
- Biotech: More in-person (lab work)

---

## Startups

### Ecosystem
Strong startup scene, different from Bay Area:
- More B2B, enterprise
- Heavy biotech/healthtech
- Less consumer/social
- Strong university ties

### Funding Environment
Top VC firms with Boston presence:
- General Catalyst
- Battery Ventures
- Bessemer
- GV (Google Ventures)
- F-Prime (Fidelity)
- Flagship (biotech focused)

### Co-working / Incubators
| Space | Focus |
|-------|-------|
| Cambridge Innovation Center (CIC) | General |
| LabCentral | Biotech |
| Greentown Labs | Climate tech |
| Mass Challenge | Accelerator |
| Harvard Innovation Labs | Student startups |

---

## Education Pipeline

### Universities
- **MIT**: CS, engineering, biotech
- **Harvard**: CS, business, biotech
- **Northeastern**: Strong co-op program
- **Boston University**: Solid CS
- **Tufts**: Research-focused
- **UMass**: State school talent

### Continuing Education
- Harvard Extension
- MIT Professional Education
- General Assembly
- Numerous coding bootcamps

---

## Cost Considerations

### Tech Salary vs. Cost
Boston pays ~85-95% of Bay Area but costs ~70-80%. Net purchasing power often better.

| Factor | Boston | SF |
|--------|--------|-----|
| Senior SWE salary | $200K | $240K |
| 1BR rent | $2,800 | $3,500 |
| State tax | 5% flat | Up to 13% |
| Net advantage | Boston often wins | — |

### Tax Note
Massachusetts: Flat 5% income tax (now 9% on income over $1M)
No sales tax on clothing under $175

---

## For Tech Workers

### Best Neighborhoods
| Neighborhood | Why |
|--------------|-----|
| Cambridge (Central/Kendall) | Walk to work |
| Somerville | Value, Red Line |
| South End | Trendy, Orange Line |
| Back Bay | Central, transit |

### Commute Patterns
- **Kendall Square**: Red Line or bike
- **Seaport**: Silver Line (bus) or bike
- **Route 128**: Car required

### Tech Social Scene
- Less dominant than SF
- Good tech meetups
- Not everyone talks about work
- Work-life separation more common
