# Startups & Funding — Boston

## Boston Startup Ecosystem

Boston/Cambridge is a **top-5 US startup hub**, with distinct character:
- Heavy biotech/healthtech
- Strong enterprise B2B
- Less consumer/social than Bay Area
- University-driven innovation
- Conservative (in startup sense): focus on real business models

### 2024-2026 Reality
- Funding tighter than 2021 peak
- Biotech still strong
- AI companies well-funded
- More focus on profitability
- Hybrid work is norm

---

## Geography

### Kendall Square
**Startup central.** Walk around and you'll hit VCs, startups, incubators.

What's here:
- 200+ biotech companies
- Major tech offices
- VC firms
- LabCentral, CIC

### Seaport
Newer startup area:
- Mass Challenge HQ
- Newer startups
- More corporate feel

### Harvard Square / Allston
University-adjacent startups:
- Student ventures
- University spinouts
- Earlier stage

---

## Incubators & Accelerators

| Program | Focus | Stage | Equity |
|---------|-------|-------|--------|
| MassChallenge | All | Early | 0% (no equity) |
| Techstars Boston | Tech | Seed | 6% |
| Harvard Innovation Labs | Harvard-affiliated | Early | 0% |
| LabCentral | Biotech | Early | Rent only |
| Greentown Labs | Climate tech | Early | 0% |
| MIT delta v | MIT students | Pre-seed | 0% |

### MassChallenge
Largest no-equity accelerator. Worth applying:
- No equity taken
- $100K+ in prizes
- Strong network
- Seaport location

### Techstars Boston
Standard Techstars model:
- $120K investment
- 6% equity
- 3-month program
- Strong mentor network

---

## Venture Capital

### Top Boston/Cambridge VCs

| Firm | Stage | Check Size | Focus |
|------|-------|------------|-------|
| General Catalyst | Seed-Growth | $1-100M | Generalist |
| Battery Ventures | Growth | $10-100M+ | Tech |
| Bessemer | All | $1-50M | Generalist |
| Polaris Partners | Early | $500K-20M | Tech, healthcare |
| F-Prime Capital | All | $1-50M | Biotech, tech |
| Underscore VC | Early | $500K-10M | B2B tech |
| Pillar VC | Seed | $500K-3M | B2B |
| OpenView | Growth | $10-100M | PLG SaaS |

### Biotech-Focused VCs

| Firm | Focus | Notes |
|------|-------|-------|
| Flagship Pioneering | Early | Created Moderna |
| Third Rock Ventures | Early | Biotech creation |
| Atlas Venture | Early | Biotech |
| Arch Ventures | Early-Growth | Life sciences |
| RA Capital | Growth | Crossover |

### National Firms with Boston Presence
- Andreessen Horowitz
- Sequoia
- Accel
- NEA
- Greylock

---

## Angel Investors

### Angel Groups
| Group | Focus | Check Size |
|-------|-------|------------|
| Launchpad Venture Group | Tech | $25-500K |
| Golden Seeds | Women founders | $25-500K |
| Hub Angels | Tech | $25-100K |
| MIT Angels | MIT-connected | $25-250K |
| CommonAngels | Tech | Merged with Launchpad |

### Finding Angels
- LinkedIn (search Boston angels)
- AngelList
- University networks
- Founder introductions (best)

---

## Funding by Stage

### Pre-Seed ($250K-$1M)
Sources:
- Friends and family
- Angel investors
- Pre-seed funds (Pillar, Underscore)
- Accelerators

### Seed ($1-4M)
Sources:
- Seed-stage VCs
- Angel syndicates
- Strategic angels

### Series A ($8-20M)
Sources:
- Multi-stage VCs
- Growth funds
- Strategic investors

---

## Grants & Non-Dilutive Funding

### Federal Programs
| Program | Amount | Focus |
|---------|--------|-------|
| SBIR Phase I | $150-250K | R&D |
| SBIR Phase II | $750K-1.5M | Development |
| STTR | Similar | University partnership |
| NIH grants | Varies | Healthcare |
| DOD grants | Varies | Defense |

### State Programs
| Program | Amount | Focus |
|---------|--------|-------|
| MassVentures | $250K-500K | Matching fund |
| Mass Life Sciences | Varies | Biotech |
| MassTech | Varies | Tech |

### SBIR Tips
- 6-9 month process
- Worth it if you qualify
- Many Boston companies use
- Helps with investor narrative

---

## Workspace

### Coworking

| Space | Location | Cost | Notes |
|-------|----------|------|-------|
| CIC | Kendall, Boston | $500-800/desk | Ecosystem, events |
| WeWork | Multiple | $400-600/desk | Corporate |
| Workbar | Multiple | $300-500/desk | Local |
| Industrious | Multiple | $500-700/desk | Premium |

### Lab Space

| Space | Focus | Stage |
|-------|-------|-------|
| LabCentral | Biotech | Early |
| BioLabs | Biotech | Early-Mid |
| Greentown Labs | Climate | Early |
| Alexandria | Biotech | Growth |

Lab space is expensive ($100-200/SF) and scarce. Plan ahead.

---

## Talent

### Hiring Advantages
- MIT, Harvard, BU, Northeastern pipeline
- Strong graduate programs
- Co-op programs (Northeastern)
- Less competition than Bay Area

### Hiring Challenges
- Competition for senior talent
- Biotech competes with tech
- Big Tech offices (Google, Meta) compete
- Expensive to relocate people

### Where to Hire
- LinkedIn
- AngelList
- Handshake (students)
- University career offices
- Startup communities

---

## Legal

### Standard Startup Lawyers
- Cooley (national, Boston office)
- Goodwin (Boston HQ)
- Mintz Levin
- Gesmer Updegrove (startup focused)
- Foley Hoag

### Deferred Fees
Many firms offer deferred fee arrangements:
- Pay when you raise funding
- Standard for VC-backed companies
- Ask about it

### Delaware vs. Massachusetts
Most VC-backed startups incorporate in **Delaware** (C-corp), even if operating in Massachusetts:
- VC-standard
- Well-established law
- Delaware Court of Chancery

---

## Community

### Events
| Event | Frequency | Focus |
|-------|-----------|-------|
| Venture Cafe | Weekly (Thurs) | Networking |
| Boston New Tech | Monthly | Demo night |
| Startup Boston Week | Annual | Conference |
| HubWeek | Annual | Innovation |

### Online Communities
- Boston Startups Slack
- Reddit r/bostontech
- LinkedIn groups
- Twitter/X tech Boston

### Key People to Know
- Get intros through founders
- VC partners are accessible
- Ecosystem is smaller than Bay Area
- Relationships matter

---

## Boston vs. Bay Area

| Factor | Boston | Bay Area |
|--------|--------|----------|
| Biotech | Much stronger | Good |
| Consumer | Weaker | Much stronger |
| B2B SaaS | Strong | Strong |
| Funding (amount) | Lower | Higher |
| Competition (talent) | Lower | Higher |
| Cost of living | High | Higher |
| Quality of life | Good | Good |
| Founder network | Tight-knit | Larger |

### When to Start in Boston
- Biotech/healthtech
- Healthcare tech (hospital access)
- Enterprise B2B
- Climate tech
- Robotics/hardware
- Defense/gov tech

### When Bay Area Might Be Better
- Consumer apps
- Social/media
- Need massive funding
- Need certain specific talent pools
