# Safety — Boston

## Overall Safety

Boston is one of the **safest major US cities**. Violent crime is relatively low and concentrated in specific areas. Most tourists and residents never experience issues.

### Crime Statistics Context
- Property crime more common than violent crime
- Most incidents in specific neighborhoods, not downtown/tourist areas
- Night safety generally good in populated areas

---

## Safe Areas (Tourist/Residential)

### Very Safe
- Back Bay
- Beacon Hill
- North End
- Cambridge (most)
- Brookline
- Seaport

### Safe with Normal Urban Awareness
- South End
- Somerville
- Jamaica Plain
- Charlestown
- East Boston (most areas)
- Fenway

### Use Caution (Research Specific Blocks)
- Parts of Dorchester
- Parts of Roxbury
- Parts of Mattapan

**Note:** "Use caution" areas have safe blocks and rough blocks. Research your specific address.

---

## Common Concerns

### Pickpocketing
Most common tourist crime. Hotspots:
- Faneuil Hall / Quincy Market
- Crowded T platforms
- Tourist attractions

**Prevention:**
- Front pocket or cross-body bag
- Don't flash expensive items
- Stay aware in crowds

### Phone Snatching
Growing problem on the T.

**Method:** Snatcher grabs phone as train doors open, runs out.

**Prevention:**
- Don't use phone near doors
- Maintain grip on device
- Stay alert at stops

### Bike Theft
Serious problem. Boston has high bike theft rates.

**Prevention:**
- U-lock (not cable lock)
- Lock both wheels and frame to fixed object
- Don't leave overnight outside
- Register with police (helps recovery)

### Package Theft
Common in apartment buildings without secure lobby.

**Prevention:**
- Amazon Locker
- Delivery to workplace
- Require signature
- Package lockbox

### Car Break-ins
Don't leave valuables visible. Ever.

**Hotspots:**
- Beacon Hill side streets
- Public parking lots
- Near tourist attractions

---

## Neighborhood Safety Details

### Downtown / Back Bay / Beacon Hill
**Very safe.** Well-lit, populated, police presence.
- Normal urban awareness
- Late night fine on main streets
- Boston Common: stick to paths at night

### North End
**Very safe.** Dense, lots of foot traffic.
- Tourist crowds until late
- Very low crime
- Watch for pickpockets in crowds

### South End
**Safe.** Gentrified, busy, well-lit.
- Fine at night
- Some rougher edges near Mass Ave/Methadone Mile

### Cambridge
**Very safe.** Harvard/MIT areas heavily policed.
- Central Square slightly edgier
- Fine at night in main areas

### Somerville
**Safe.** Rapidly gentrifying.
- Davis and Union Squares fine
- Some quieter areas at night

### Seaport
**Very safe.** New, corporate, well-lit.
- Can feel empty late night (few residents)
- More sterile than dangerous

### Jamaica Plain
**Safe.** Community-oriented.
- Centre Street area busy and safe
- Some quieter blocks, use judgment

### Allston/Brighton
**Generally safe.** Student area.
- Petty crime (bike theft)
- Loud but not dangerous
- Drunk students, not criminals

### East Boston
**Mostly safe, improving.**
- Maverick Square area fine
- Some blocks still transitional
- Research specific streets

### Roxbury
**Mixed.** Rapidly changing.
- Dudley Square area improving
- Some blocks have issues
- Research your specific area

### Dorchester
**Varies significantly by block.**
- Ashmont/Fields Corner areas improving
- Some blocks have serious crime
- ALWAYS research specific address
- Don't generalize — huge neighborhood

### South Boston
**Safe now.** Heavily gentrified.
- Broadway area popular with young people
- Fine at night

---

## T (Subway) Safety

### General Safety
The T is **generally safe**, even late night.

**Tips:**
- Stay in populated cars
- Stand back from platform edge
- Don't use phone at train doors
- Have situational awareness

### Station Notes
- **Downtown Crossing**: Busy, safe, some panhandlers
- **Park Street**: Crowded, safe
- **Harvard**: Very safe
- **State/Government Center**: Safe, quieter late night

### Late Night
Service ends ~12:30am. After:
- Rideshare is primary option
- Some areas quieter than others
- Main streets generally fine

---

## Specific Concerns

### Mass Ave and Methadone Mile
**Area around Massachusetts Ave / Melnea Cass Blvd** has visible homelessness, substance abuse issues.

**What to know:**
- Not typically dangerous to passersby
- Can be uncomfortable to walk through
- Avoid late night
- Concentrated in small area

### Boston Common After Dark
**Stick to main paths.** The park itself is fine on lit paths but darker areas less populated.

### Alleys and Side Streets
Most Boston streets are safe. Use judgment on:
- Poorly lit alleys
- Isolated areas
- Empty parking garages

---

## Emergency Information

### Emergency Numbers
- **911**: Police, Fire, Ambulance
- **311**: Non-emergency city services

### Police Districts
Boston Police has multiple districts. For non-emergency:
- Look up your district station
- Call non-emergency line

### Hospitals (Emergency)
| Hospital | Location | Notes |
|----------|----------|-------|
| Mass General | Downtown | Top-ranked |
| Brigham and Women's | Longwood | Major trauma |
| Beth Israel | Longwood | Good ER |
| Boston Medical Center | South End | Safety net hospital |
| Tufts Medical | Downtown | Central location |

### Urgent Care
For non-emergencies:
- CVS MinuteClinic (multiple)
- CareWell Urgent Care
- AFC Urgent Care

---

## Safety for Specific Groups

### Women
Boston is relatively safe for women.
- Trust your instincts
- Normal urban precautions apply
- T generally fine alone
- Many well-lit, populated areas

### LGBTQ+
Boston is among the most LGBTQ-friendly US cities.
- South End is historic gay neighborhood
- Cambridge very accepting
- Pride events widely supported
- Little public harassment

### People of Color
Boston has complicated racial history.
- Most areas welcoming
- Some neighborhoods have reputations
- Cambridge/Somerville very diverse
- Discrimination incidents rare but not unknown

### Students
250,000 students, city is used to them.
- Campus police in addition to BPD
- Most crime = petty theft
- Don't walk home drunk alone

---

## Winter Safety

### Cold Weather
- Hypothermia risk in extreme cold
- Proper gear essential (see `climate.md`)
- Check on elderly neighbors

### Ice and Snow
- Sidewalks can be treacherous
- Black ice on streets
- Wear appropriate footwear
- Watch for falling ice from buildings

### Snow Emergencies
- Move car from snow emergency routes
- Parking bans enforced immediately
- Know the rules or get towed

---

## General Tips

1. **Trust your instincts** — if something feels wrong, leave
2. **Stay aware** — headphones fine, but know your surroundings
3. **Avoid confrontation** — not worth it
4. **Know your route** — especially late night
5. **Travel populated streets** — even if slightly longer
6. **Keep phone charged** — for emergencies and navigation
7. **Share location** — with friend when meeting someone new
8. **Don't flash valuables** — common sense
