# Moving & Settling — Boston

## Before You Arrive

### Timeline
| Weeks Before | Task |
|--------------|------|
| 8-12 | Start apartment search (especially Sept 1 leases) |
| 6-8 | Secure apartment, sign lease |
| 4 | Set up utilities accounts |
| 2 | Book movers (CRITICAL for Sept 1) |
| 1 | Forward mail, notify banks |
| Day of | Arrive, meet landlord, get keys |

### September 1st Reality
65% of Boston leases turn over on September 1st. This is chaos.

**What happens:**
- Streets packed with moving trucks
- Double-parked vehicles everywhere
- Elevators in buildings backed up for hours
- Mattresses and furniture on every sidewalk

**How to survive:**
- Book movers by June (seriously)
- Move August 31 or September 2 if possible
- Start at 6am to beat traffic
- Have backup transportation plan

---

## Finding an Apartment

### Boston-Specific Realities

**Broker Fees**
Most Boston rentals require a broker fee: one month's rent to the broker.
- Total upfront: First + Last + Security + Broker = 4 months rent
- "No fee" apartments exist but are competitive
- Fee is paid by tenant, not landlord (unlike most US cities)

**September Cycle**
- Most leases run Sept 1 - Aug 31
- Finding off-cycle leases (Feb, June) = less competition
- Off-cycle sometimes means lower rent

**Student Competition**
250,000 students compete for housing. Be prepared to:
- Move fast (same-day decisions)
- Have documents ready
- Pay deposit immediately

### Where to Search

| Platform | Notes |
|----------|-------|
| Zillow | Good inventory, some broker listings |
| Apartments.com | Standard listings |
| Craigslist | Still works in Boston, watch for scams |
| Facebook groups | "Boston Housing", neighborhood-specific |
| Padmapper | Aggregates multiple sources |
| Walk-ins | Some landlords don't list online |

### Required Documents
- Photo ID
- Proof of income (pay stubs, offer letter)
- Bank statements
- Credit report
- References (previous landlords)
- Guarantor info (if needed)

### Guarantor Requirements
Many landlords require income = 3x rent. If you don't meet this:
- Guarantor (usually parent) with 5x rent income
- Larger security deposit
- Prepay several months

---

## Utilities Setup

### Electricity
**Provider:** Eversource (most of Boston), National Grid (some areas)
- Call/online setup before move-in
- Budget: $50-150/month depending on AC usage
- Deposits sometimes required for new accounts

### Gas
**Provider:** National Grid
- Required for heating in most apartments
- Winter bills: $100-200/month
- Summer bills: $20-40/month (just cooking)

### Internet
| Provider | Coverage | Notes |
|----------|----------|-------|
| Xfinity/Comcast | Most areas | Most common |
| RCN | Some areas | Good alternative |
| Verizon Fios | Limited areas | Fiber, best if available |
| Starry | Some buildings | Newer option |

**Typical cost:** $50-80/month for decent speed

### Water
Usually included in rent. If not, Boston Water and Sewer.

### Trash/Recycling
City of Boston handles. Free curbside pickup.
- Trash: Weekly
- Recycling: Weekly (single stream)
- Yard waste: Seasonal
- Large items: Call for pickup

---

## Getting IDs and Registrations

### Massachusetts Driver's License
**RMV (Registry of Motor Vehicles)** handles licenses.

Requirements (if from another state):
- Current out-of-state license
- Proof of MA residency (utility bill, lease)
- Social Security card
- Passport or birth certificate

**Book appointment online** — walk-ins have terrible wait times.

### Vehicle Registration
If bringing a car:
1. Get MA inspection within 7 days
2. Get MA insurance (required before registration)
3. Register at RMV (bring title, insurance, ID)
4. Get plates

**MA insurance is expensive** — $100-200/month typical.

### Voter Registration
- Online at sec.state.ma.us
- Or at RMV when getting license
- Same-day registration available at polls

---

## Neighborhood Permits

### Resident Parking Permit
Most neighborhoods require permit for street parking.
- Apply at City Hall or online
- Bring: lease, vehicle registration, ID
- Cost: $25/year (varies by neighborhood)
- Wait time: 1-2 weeks typically

**WARNING:** Without permit, you will get ticketed ($40) and eventually towed.

### Snow Emergency
Boston declares snow emergencies during major storms.
- Must move car from marked routes within 2 hours
- Towing is immediate and expensive ($100+ tow + storage)
- Check boston.gov for emergency declarations
- Sign up for text alerts

---

## Banking

### Opening Accounts
Major banks have good Boston presence:
- Bank of America (headquarters here)
- Citizens Bank (regional, good service)
- Santander (regional)
- TD Bank (convenient hours)
- Eastern Bank (local, community focused)

### What You Need
- Two forms of ID
- Proof of address
- Social Security Number (or ITIN for non-citizens)
- Initial deposit ($25-100)

### Credit Unions
Often better rates, more personal service:
- Metro Credit Union
- DCU (Digital Federal Credit Union)
- Harvard FCU (if affiliated)

---

## Healthcare Setup

### Finding a Doctor
Boston has world-class healthcare but can be confusing.

**Major Health Systems:**
- Mass General Brigham (MGH, Brigham, others)
- Beth Israel Lahey
- Boston Medical Center (safety net hospital)
- Tufts Medical Center

**How to Choose:**
1. Check your insurance network
2. Major systems accept most insurance
3. MGH/Brigham often has longest wait times
4. BMC good for those without insurance

### Health Insurance
Massachusetts requires health insurance (state law predates ACA).
- Through employer (most common)
- MassHealth (Medicaid) if income-eligible
- Health Connector marketplace
- Penalty for uninsured: tax penalty

---

## Getting Around Initially

### Without a Car
Totally doable in Boston/Cambridge/Somerville.

**First week priorities:**
1. Get a CharlieCard (T stations)
2. Download MBTA app
3. Download Citymapper or Google Maps
4. Get Bluebikes membership (bike share)

### With a Car
**Immediate needs:**
1. Find parking (garage or permit)
2. Get MA inspection within 7 days
3. Get MA insurance
4. Register vehicle
5. Get resident permit

---

## Important Numbers and Resources

| Service | Contact |
|---------|---------|
| City services | 311 |
| Police/Fire (non-emergency) | 311 |
| Emergency | 911 |
| Electricity (Eversource) | 1-800-592-2000 |
| Gas (National Grid) | 1-800-233-5325 |
| MBTA | 617-222-3200 |
| RMV appointments | mass.gov/rmv |

### Useful Websites
- boston.gov — city services
- mass.gov — state services
- mbta.com — transit
- reddit.com/r/boston — community advice

---

## First Month Checklist

### Week 1
- [ ] Utilities on and working
- [ ] Internet setup
- [ ] Get CharlieCard
- [ ] Find nearest grocery store
- [ ] Locate nearest pharmacy

### Week 2
- [ ] Driver's license appointment (if needed)
- [ ] Resident parking permit application
- [ ] Register to vote
- [ ] Find a primary care doctor

### Week 3
- [ ] Explore neighborhood on foot
- [ ] Find go-to restaurants
- [ ] Get library card (BPL)
- [ ] Join local Facebook/Reddit groups

### Week 4
- [ ] Vehicle registration (if applicable)
- [ ] Finalize commute routine
- [ ] Set up auto-pay for utilities
- [ ] Start planning for winter (if arriving fall)
