# North Neighborhoods — Boston

## North End

### Overview
Boston's Little Italy. Oldest residential neighborhood, densely packed, incredible Italian restaurants, tourist destination.

### Character
- Narrow colonial-era streets
- Italian restaurants, bakeries, cafes
- Paul Revere House, Old North Church
- Strong Italian-American identity
- Tourist crowds year-round

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 10/10 | Everything walkable |
| Transit | 8/10 | Haymarket (Green/Orange) |
| Dining | 10/10 | Italian, seafood, legendary |
| Nightlife | 6/10 | Some bars, restaurants close early |
| Grocery | 5/10 | Small markets, specialty Italian |
| Parking | 1/10 | Essentially impossible |

### Cost of Living
- 1BR: $2,400-3,200/month
- Studios: $1,800-2,400/month
- Small apartments typical (old buildings)

### Who Lives Here
- Long-term Italian-American families (shrinking)
- Young professionals who love food
- People who don't need cars
- Empty nesters

### Food Highlights
- Regina Pizzeria (cash only, worth any line)
- Neptune Oyster (book ahead)
- Modern Pastry vs Mike's (tourist debate)
- Giacomo's (cash only, portions huge)

### Best Streets
- Hanover: Main drag, restaurants, crowds
- Salem: Slightly quieter
- Side streets: Residential, charming

### Downsides
- Tourists everywhere
- Parking is a fantasy
- Small apartments (colonial buildings)
- Can feel like Disneyland
- Loud (restaurants, tourists)

---

## Charlestown

### Overview
Historic neighborhood, site of Bunker Hill. Gentrifying former working-class Irish area. Water views, community feel.

### Character
- Bunker Hill Monument
- Navy Yard (USS Constitution)
- Historic row houses
- Long-term "townie" families + new money
- Tension between old and new residents

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 7/10 | Hilly, good within area |
| Transit | 5/10 | Bus to North Station, Orange Line walk |
| Dining | 6/10 | Some good spots |
| Nightlife | 5/10 | Local bars |
| Grocery | 5/10 | Whole Foods in Navy Yard |
| Parking | 5/10 | Permit, easier than downtown |

### Cost of Living
- 1BR: $2,400-3,200/month
- 2BR: $3,000-4,000/month
- Prices climbed with gentrification

### Who Lives Here
- Long-term Charlestown families
- Young professionals
- Families wanting community feel
- People working at Navy Yard (tech companies)

### Best Areas
- City Square: Near bridge to Boston, restaurants
- Navy Yard: Modern apartments, waterfront
- Monument area: Historic, residential

### Downsides
- Transit limitations (no direct T)
- Can feel isolated from rest of Boston
- Townies vs. newcomers tension
- Hills challenging in winter

---

## East Boston (Eastie)

### Overview
Diverse, immigrant-rich neighborhood across harbor from downtown. Blue Line access, airport adjacent, rapidly gentrifying.

### Character
- Latin American (Colombian, Salvadoran) community
- Ethnic restaurants everywhere
- Waterfront with skyline views
- Near Logan Airport
- Rapid development/gentrification

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 7/10 | Maverick/Central Square areas |
| Transit | 8/10 | Blue Line (Maverick, Airport, etc.) |
| Dining | 8/10 | Best Latin food in Boston |
| Nightlife | 5/10 | Local bars, some clubs |
| Grocery | 7/10 | Latino markets, Stop & Shop |
| Parking | 6/10 | Easier than most Boston |

### Cost of Living
- 1BR: $1,900-2,500/month
- 2BR: $2,400-3,200/month
- Still relatively affordable but rising fast

### Who Lives Here
- Latin American immigrants
- Long-term East Boston families
- Young professionals seeking value
- Artists priced out of other areas

### Best Areas
- Maverick Square: Blue Line, restaurants, bars
- Jeffries Point: Waterfront, skyline views
- Orient Heights: Quieter, residential
- Central Square: Authentic Latin scene

### Downsides
- Airport noise (planes overhead constantly)
- Gentrification displacing community
- Some areas still rough
- Feels separate from rest of Boston

### Strengths
- Authenticity
- Food scene (Colombian, Salvadoran, etc.)
- Skyline views from waterfront
- Value for Boston
- Blue Line to downtown (15 min)

---

## Waterfront / Wharf District

### Overview
Boston's harbor edge. Hotels, restaurants, New England Aquarium, Long Wharf. More tourist/business than residential.

### Character
- Harbor views everywhere
- Tourist focused
- Aquarium, whale watching
- Limited residential

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 9/10 | Waterfront, connected to North End |
| Transit | 8/10 | Aquarium (Blue Line) |
| Dining | 7/10 | Waterfront restaurants (pricey) |
| Nightlife | 5/10 | Hotel bars |
| Grocery | 3/10 | Very limited |
| Parking | 4/10 | Garage only |

### Cost of Living
- 1BR: $3,500-5,000/month
- Very limited inventory
- Mostly luxury condos

### Who Lives Here
- Wealthy professionals
- Empty nesters with money
- Some corporate housing

### Downsides
- Very expensive
- Tourist crowds
- Limited neighborhood feel
- Few residents means less community

---

## West End

### Overview
Largely destroyed by 1960s urban renewal. Now mostly TD Garden, Mass General Hospital, and new development. Not really a "neighborhood" anymore.

### Character
- TD Garden (Celtics, Bruins)
- Mass General Hospital campus
- Some new residential development
- Historic West End mostly demolished

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 7/10 | MGH area |
| Transit | 9/10 | North Station (Green/Orange/Commuter) |
| Dining | 5/10 | Limited, some hospital area spots |
| Nightlife | 6/10 | Sports bars near TD Garden |
| Grocery | 4/10 | Limited |
| Parking | 5/10 | Garage options |

### Cost of Living
- 1BR: $2,800-3,600/month
- New construction dominates

### Who Lives Here
- Medical professionals (MGH)
- Sports fans (TD Garden adjacent)
- People wanting transit access

### Downsides
- Not a real neighborhood
- Game day chaos
- Limited dining/shopping
- No historic character (demolished)

---

## Allston / Brighton

### Overview
Student central. Boston University, Boston College students. Cheap, young, lively. September 1st moving day chaos.

### Character
- Student housing dominates
- Cheap ethnic food
- Music venues, dive bars
- Triple-deckers and apartment buildings
- Harvard Ave commercial strip

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 7/10 | Harvard Ave area |
| Transit | 6/10 | Green B Line (slow) |
| Dining | 7/10 | Cheap, diverse, student-focused |
| Nightlife | 8/10 | Bars, music, house parties |
| Grocery | 7/10 | Star Market, ethnic markets, Super 88 |
| Parking | 5/10 | Permit, competitive |

### Cost of Living
- 1BR: $1,700-2,300/month
- Rooms: $800-1,200/month
- Cheapest Boston-proper neighborhood

### Who Lives Here
- BU, BC students
- Recent graduates
- Young professionals on budget
- Immigrant communities (Brazilian, Asian)

### Best Areas
- Lower Allston: Near Harvard Business School, quieter
- Brighton Center: More residential, families
- Cleveland Circle: BC adjacent, restaurants

### Downsides
- Loud (students, parties)
- Transient population
- September 1st chaos
- Green B Line is slowest T branch
- Can feel like college extension
