# Choosing a Neighborhood — Boston

## Decision Framework

### Step 1: Define Priorities

Rank these 1-5:
- [ ] Commute (where do you work?)
- [ ] Budget
- [ ] Walkability
- [ ] Nightlife/dining
- [ ] Space (apartment size)
- [ ] Safety
- [ ] Character/charm

### Step 2: Match to Neighborhoods

## By Work Location

### Kendall Square / Cambridge Tech
Best neighborhoods:
1. **Cambridge (Central/Kendall)** — walk/bike to work
2. **Somerville** — Red Line or bike, cheaper
3. **Porter Square** — Red Line direct
4. **Back Bay** — Red Line (Charles/MGH) + walk

Avoid: South Boston, Jamaica Plain (long commutes)

### Financial District / Downtown
Best neighborhoods:
1. **Back Bay** — walk or quick T
2. **South End** — Orange Line direct
3. **Beacon Hill** — walk
4. **Cambridge** — Red Line (15-20 min)

Avoid: Allston/Brighton (slow Green Line)

### Seaport / Innovation District
Best neighborhoods:
1. **Seaport** — walk
2. **South Boston** — walk/bike
3. **Financial District** — walk
4. **Back Bay** — Silver Line or walk

Avoid: Cambridge, Somerville (no direct transit)

### Longwood Medical Area
Best neighborhoods:
1. **Fenway** — walk
2. **Brookline** — Green D Line
3. **Jamaica Plain** — bus/bike
4. **Mission Hill** — walk

### Harvard / MIT Area
Best neighborhoods:
1. **Cambridge** (obvious)
2. **Somerville** — bike/Red Line
3. **Porter Square** — Red Line
4. **Allston** — bike across river

## By Budget

### Under $1,800/month (1BR)
- Dorchester (near Red Line)
- East Boston
- Allston/Brighton
- Mattapan
- Revere (Blue Line)
- Malden (Orange Line)

### $1,800-2,500/month
- Somerville
- Jamaica Plain
- Roxbury (improving areas)
- Charlestown (smaller units)
- Brighton (nicer parts)
- Cambridge (studios, roommates)

### $2,500-3,500/month
- South End
- Cambridge (1BR)
- Back Bay (smaller units)
- Brookline
- North End
- South Boston

### $3,500+/month
- Back Bay (nice 1BR)
- Beacon Hill
- Seaport
- Kendall Square
- Waterfront

## By Lifestyle

### Young Professional, First Job
**Priorities:** Social scene, value, other young people
- **Allston/Brighton**: Cheapest, most social
- **Somerville**: Hip, affordable, bars
- **South Boston**: Bros, bars, beach
- **East Boston**: Value, Blue Line, diverse

### Couple, No Kids
**Priorities:** Dining, walkability, dual commutes
- **South End**: Best restaurants, walkable
- **Cambridge (Central)**: Diverse, interesting
- **Somerville (Union)**: Food scene, Green Line
- **Back Bay**: Classic Boston, easy commutes

### Family with Kids
**Priorities:** Schools, space, safety
- **Brookline**: Best public schools in metro
- **Newton**: Excellent schools, suburban
- **Arlington**: Good schools, Red Line access
- **West Cambridge**: Schools, quiet

### Graduate Student
**Priorities:** Budget, proximity to campus, other students
- **Allston**: BU, BC students
- **Cambridge**: Harvard, MIT (pricier)
- **Somerville**: Near Tufts, cheaper than Cambridge
- **Mission Hill**: Northeastern, medical schools

### Tech Worker
**Priorities:** Commute to Kendall, walkability, scene
- **Cambridge (Central)**: Walk to work, nightlife
- **Somerville**: Value, hip, Red Line
- **Kendall**: Walk to work, sterile but convenient
- **South End**: Longer commute but better life

### Remote Worker
**Priorities:** Quality of life, not commute
- **Jamaica Plain**: Nature, community, cafes
- **Somerville**: Walkable, diverse
- **South End**: Restaurants, walkability
- **Brookline**: Safe, quiet, Green Line when needed

### LGBTQ+
**Priorities:** Community, acceptance, scene
- **South End**: Historic gay neighborhood, best scene
- **Jamaica Plain**: Lesbian community historically
- **Cambridge**: Progressive, accepting
- **Somerville**: Progressive, diverse

### Foodie
**Priorities:** Restaurants, markets, scene
- **South End**: Best dining in Boston
- **Somerville (Union)**: Emerging food scene
- **Cambridge (Central)**: Diverse ethnic
- **North End**: Italian (but touristy)

## Common Mistakes

### Mistake 1: Underestimating Commute
The T is slower than it looks on a map. Green Line branches take 45+ min from BC to downtown. Check actual commute times on Google Maps during rush hour.

### Mistake 2: September 1st Lease
65% of leases turn over. If possible, find off-cycle lease (February, October). Less competition, sometimes lower prices.

### Mistake 3: Ignoring Winter
That charming walk to the T becomes brutal in February. Proximity to transit matters more than you think.

### Mistake 4: Choosing for Nightlife Only
You'll go out 1-2 nights a week. You'll live there 7 days. Prioritize daily life over weekend convenience.

### Mistake 5: Skipping In-Person Visits
Photos lie. Always visit apartments in person. Check:
- Noise levels
- Natural light
- Heating system (radiators? forced air?)
- Water pressure
- Laundry situation

## Apartment Hunting Tips

### Best Timing
- **February-April**: Most inventory, less competition
- **May-August**: September 1st leases, most competition
- **October-January**: Least inventory, but motivated landlords

### Boston-Specific Issues
- **Broker fees**: One month rent, common in Boston
- **Security deposit**: First, last, security = 3 months upfront
- **No-fee apartments**: Exist but competitive
- **September 1st**: Avoid moving on this exact date if possible

### Resources
- Zillow, Apartments.com
- Craigslist (still works in Boston)
- Facebook groups (Boston Housing, specific neighborhoods)
- Walk-ins (some landlords don't list online)

### Red Flags
- Can't see apartment before signing
- Cash only, no lease
- Price significantly below market
- Pushy landlord, won't answer questions
- No working smoke/CO detectors
