# Cambridge & Somerville — Boston

## Cambridge Overview

Separate city from Boston, across Charles River. Home to Harvard and MIT. More progressive, academic, tech-focused than Boston proper.

Population: ~120,000
Known for: Universities, biotech, liberal politics, bike infrastructure

---

## Harvard Square

### Overview
Heart of Cambridge. Bookstores, cafes, street performers, tourists. Harvard University dominates.

### Character
- Harvard Yard and university buildings
- Historic Harvard Coop bookstore
- Street performers, chess players
- Mix of students, tourists, academics

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 10/10 | Everything within walking distance |
| Transit | 10/10 | Red Line terminus, buses |
| Dining | 8/10 | Good variety, some tourist traps |
| Nightlife | 6/10 | Bars exist but closes relatively early |
| Grocery | 6/10 | Cardullo's gourmet, Harvard Market |
| Parking | 2/10 | Street nearly impossible, garages expensive |

### Cost of Living
- 1BR: $2,600-3,500/month
- Studios: $2,000-2,500/month
- Competition intense from students and affiliates

### Who Lives Here
- Harvard students, staff, faculty
- Young professionals
- Long-term Cambridge residents
- Tech workers who prefer Cambridge vibe

### Best Parts
- Brattle Street: Elegant residential, historic homes
- Off Mass Ave: Quieter residential pockets

### Downsides
- Tourist crowds
- Student noise
- Expensive
- Chain stores replacing independent shops

---

## Central Square

### Overview
Cambridge's grittier, more diverse commercial district. Music venues, dive bars, ethnic restaurants.

### Character
- Music scene (Middle East, Sonia, etc.)
- Diverse restaurants (Ethiopian, Indian, Korean)
- Mix of long-term residents and young professionals
- Rapidly gentrifying but retains edge

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 9/10 | Good but slightly less than Harvard |
| Transit | 10/10 | Red Line Central stop |
| Dining | 9/10 | Best ethnic food in Cambridge |
| Nightlife | 9/10 | Best in Cambridge, live music |
| Grocery | 7/10 | Whole Foods, ethnic markets |
| Parking | 3/10 | Slightly easier than Harvard |

### Cost of Living
- 1BR: $2,400-3,200/month
- Slightly cheaper than Harvard Square

### Who Lives Here
- Young professionals
- Musicians, artists
- Graduate students
- Long-term Cambridge residents

### Downsides
- Gentrification changing character
- Can be louder at night
- Homeless population visible
- Some blocks rougher than others

---

## Kendall Square / MIT

### Overview
Biotech capital of America. MIT campus, Google, Microsoft, hundreds of startups and pharma companies.

### Character
- Massive biotech/tech company presence
- MIT campus architecture (Stata Center!)
- New luxury apartments everywhere
- Very corporate Monday-Friday, quiet weekends

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 8/10 | Good within area |
| Transit | 10/10 | Red Line Kendall/MIT stop |
| Dining | 7/10 | Corporate lunch spots, improving dinner |
| Nightlife | 5/10 | Limited, mostly hotel bars |
| Grocery | 6/10 | Whole Foods nearby, H Mart |
| Parking | 5/10 | Garage parking in buildings |

### Cost of Living
- 1BR: $3,200-4,500/month
- Luxury new construction dominates
- Amenity buildings (gyms, pools, rooftops)

### Who Lives Here
- Tech and biotech workers
- MIT students and postdocs
- Young professionals
- Corporate relocations

### Best Parts
- CambridgeSide area: Near mall and river
- Third Street corridor: Restaurants emerging

### Downsides
- Sterile feel (compared to older Cambridge)
- Dead on weekends
- Expensive
- Corporate culture dominates

---

## Porter Square / North Cambridge

### Overview
Quieter residential area north of Harvard. Good value, community feel, Japanese market (Lesley University area).

### Character
- Residential streets, families
- Porter Exchange (Japanese food hall)
- Lesley University presence
- Less touristy than Harvard Square

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 8/10 | Good commercial strips |
| Transit | 9/10 | Red Line Porter stop |
| Dining | 7/10 | Porter Exchange, local spots |
| Nightlife | 4/10 | Quiet |
| Grocery | 7/10 | Star Market, specialty shops |
| Parking | 5/10 | Easier than other Cambridge areas |

### Cost of Living
- 1BR: $2,200-2,900/month
- Better value than Harvard/Kendall

### Who Lives Here
- Families
- Graduate students
- Young professionals wanting quiet
- Long-term residents

---

## Somerville

### Overview
Bordering Cambridge to the north. Historically working-class, now hip destination for young professionals. Multiple distinct squares.

Population: ~80,000
Known for: Davis Square nightlife, Union Square food, Assembly Row development

---

## Davis Square

### Overview
Somerville's main hub. Red Line access, restaurants, bars, music venues. Youthful energy.

### Character
- Indie shops, cafes, bookstores
- Somerville Theatre (indie films)
- Tufts University nearby
- Strong community identity

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 9/10 | Excellent square |
| Transit | 9/10 | Red Line Davis stop |
| Dining | 8/10 | Good variety, improving |
| Nightlife | 8/10 | Bars, music venues |
| Grocery | 7/10 | Star Market, McKinnon's meat |
| Parking | 4/10 | Permit system, limited |

### Cost of Living
- 1BR: $2,200-2,800/month
- Good value compared to Cambridge

### Who Lives Here
- Young professionals
- Tufts students and affiliates
- Creative types
- Families (outskirts)

---

## Union Square

### Overview
Somerville's food destination. Recently got Green Line extension. Rapidly developing but retains grit.

### Character
- Restaurant scene (acclaimed spots)
- Bow Market (shipping container food hall)
- Green Line extension opened 2022
- Gentrifying quickly

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 8/10 | Square is excellent |
| Transit | 8/10 | New Green Line stop |
| Dining | 9/10 | Best food in Somerville |
| Nightlife | 7/10 | Improving |
| Grocery | 6/10 | Market Basket (further), specialty |
| Parking | 5/10 | Better than Davis |

### Cost of Living
- 1BR: $2,000-2,600/month
- Prices rising with Green Line

### Who Lives Here
- Foodies
- Young professionals
- Artists, musicians
- Tech workers

---

## Assembly Row / East Somerville

### Overview
New development on former industrial land. Mall, apartments, movie theater. Convenient but lacking soul.

### Character
- Assembly Row outdoor mall
- New apartment buildings
- Orange Line Assembly stop
- Very new, still developing identity

### Living Here

| Factor | Rating | Notes |
|--------|--------|-------|
| Walkability | 7/10 | Within development |
| Transit | 8/10 | Orange Line direct |
| Dining | 6/10 | Chain-heavy at mall |
| Nightlife | 5/10 | Movie theater, some bars |
| Grocery | 7/10 | Trader Joe's at Assembly |
| Parking | 7/10 | Garages available |

### Cost of Living
- 1BR: $2,600-3,400/month
- All new construction

### Who Lives Here
- Young professionals wanting modern
- Commuters who value Orange Line
- People less concerned with "character"
