# Local Services — Boston

## Banking

### Major Banks
| Bank | Notes |
|------|-------|
| Bank of America | Headquarters in Boston, most ATMs |
| Citizens Bank | Strong regional presence |
| Santander | Regional, decent |
| TD Bank | Convenient hours (open Sundays) |
| Eastern Bank | Local, community-focused |

### Credit Unions
Often better rates and service:
- Metro Credit Union
- DCU (Digital Federal Credit Union)
- Harvard FCU (if affiliated)
- MIT FCU (if affiliated)

### Opening an Account
Requirements:
- Two forms of ID
- Proof of address (utility bill, lease)
- Social Security Number (or ITIN)
- Initial deposit ($25-100)

### ATMs
- Bank ATMs everywhere
- CVS has ATMs
- 7-Eleven ATMs (fee)
- Avoid random ATMs (high fees)

---

## Phone & Internet

### Mobile Carriers
All major carriers work well:
- Verizon (best coverage)
- AT&T (good coverage)
- T-Mobile (good value)
- Mint Mobile (budget MVNO)

### Getting a Phone
- Carrier stores in malls, downtown
- Best Buy
- Apple Store (Cambridge, Back Bay)

### Home Internet
| Provider | Type | Coverage | Notes |
|----------|------|----------|-------|
| Xfinity/Comcast | Cable | Most areas | Dominant provider |
| RCN | Cable | Some areas | Good alternative |
| Verizon Fios | Fiber | Limited | Best if available |
| Starry | Fixed wireless | Some buildings | Newer |

**Typical speed/cost**: $50-80/month for 200-400 Mbps

### TV Options
- Streaming (Netflix, Hulu, etc.)
- Xfinity TV bundles
- YouTube TV, Hulu Live for local channels

---

## Postal Services

### USPS
Post offices throughout the city.
- Main branch: 25 Dorchester Ave (near South Station)
- Find locations: usps.com

### Package Services
- UPS Store (multiple locations)
- FedEx Office (multiple locations)
- Amazon Locker (for package security)

### Mail Forwarding
When moving:
- USPS.com address change ($1.10 verification)
- Takes 7-10 days to activate
- Lasts 12 months

---

## Healthcare

### Finding a Doctor
Major health systems (accept most insurance):
- **Mass General Brigham**: MGH, Brigham and Women's
- **Beth Israel Lahey**: Beth Israel, multiple facilities
- **Boston Medical Center**: Safety net hospital
- **Tufts Medical Center**: Downtown

### Urgent Care (Non-Emergency)
- CVS MinuteClinic (multiple)
- CareWell Urgent Care
- AFC Urgent Care
- Atrius Health urgent care

### Pharmacies
| Chain | Notes |
|-------|-------|
| CVS | Most locations, 24-hour in Back Bay |
| Walgreens | Common |
| Rite Aid | Some locations |

### Health Insurance
Massachusetts requires insurance (since 2006).
- Through employer (most common)
- MassHealth (state Medicaid)
- Health Connector (marketplace)

---

## Grocery & Food

### Major Chains
| Store | Vibe | Price |
|-------|------|-------|
| Whole Foods | Organic, upscale | $$$$ |
| Trader Joe's | Unique items, value | $$ |
| Star Market | Standard grocery | $$$ |
| Stop & Shop | Standard grocery | $$ |
| Market Basket | Value, basic | $ |
| Roche Bros | Local chain | $$$ |

### Specialty Markets
- **H Mart**: Asian groceries (Cambridge)
- **Super 88**: Asian (Allston)
- **Boston Public Market**: Local vendors
- **Eataly**: Italian (Prudential)

### Delivery
- Instacart (most stores)
- Amazon Fresh/Whole Foods
- Individual store apps
- Imperfect Foods (budget option)

---

## Laundry

### In-Building
Many apartments have:
- Shared basement laundry
- Coin-operated (bring quarters)
- Some have card readers now

### Laundromats
- Sudsy Water (multiple)
- Many neighborhood laundromats
- Some offer wash-and-fold service

### Dry Cleaning
- Zoots (chain)
- Many neighborhood dry cleaners
- Pickup/delivery services available

---

## Home Services

### Emergency Services
- **Plumber**: Search Yelp, Angi — expect $100+ call fee
- **Electrician**: Licensed required in MA
- **Locksmith**: 24-hour services available
- **HVAC**: Heating emergencies in winter

### Moving
- Book early (especially for Sept 1)
- Local movers: Gentle Giant, Olympia
- Compare quotes from 3+ companies
- Read reviews carefully

### Cleaning
- TaskRabbit for one-time
- Handy for recurring
- Local services on Yelp/Angi

---

## City Services

### 311
Call or use 311 app for:
- Pothole reports
- Broken streetlights
- Graffiti removal
- Trash issues
- General questions

### Library (BPL)
Boston Public Library:
- Free library card with MA address
- Multiple branches
- Museum passes (free!)
- E-books, streaming
- WiFi, study spaces

### Trash & Recycling
City of Boston handles:
- Weekly trash pickup
- Weekly recycling (single stream)
- Yard waste (seasonal)
- Large item pickup (call ahead)

---

## Transportation Services

### RMV (Registry of Motor Vehicles)
For driver's license, vehicle registration:
- **Book appointment online** (walk-ins terrible)
- Locations: Boston, Cambridge, Watertown, others
- mass.gov/rmv

### Parking Permits
Resident parking permit:
- Apply at City Hall or online
- Bring: lease, registration, ID
- $25/year
- Takes 1-2 weeks

### Vehicle Inspection
Massachusetts requires annual inspection:
- Within 7 days of registration
- Any licensed inspection station
- $35 fee

---

## Legal Services

### Finding a Lawyer
- Massachusetts Bar Referral Service
- Legal Aid (income-qualified)
- Law school clinics (Harvard, BU, Northeastern)

### Common Needs
- **Housing disputes**: Tenant rights strong in MA
- **Immigration**: Many specialized attorneys
- **Traffic/parking**: Usually not worth fighting

---

## Pet Services

### Licensing
Dogs must be licensed in Boston:
- City Hall or online
- $15-30/year
- Rabies vaccination required

### Veterinary
- Angell Animal Medical Center (MSPCA) — emergency
- VCA hospitals — multiple locations
- Neighborhood vets throughout

### Pet Supplies
- Petco, PetSmart (chains)
- Polka Dog Bakery (local)
- Pet stores in most neighborhoods

### Dog Parks
- Peters Park (South End)
- Esplanade (Charles River)
- Fresh Pond (Cambridge)
- Many neighborhood spots

---

## Useful Apps

| App | Purpose |
|-----|---------|
| 311 | City services |
| MBTA | Transit |
| Bluebikes | Bike share |
| BPL | Library services |
| ParkBoston | Meter parking |
| SpotHero | Garage parking |
| Nextdoor | Neighborhood info |

---

## Important Numbers

| Service | Number |
|---------|--------|
| Emergency | 911 |
| Non-emergency | 311 |
| Eversource (electric) | 1-800-592-2000 |
| National Grid (gas) | 1-800-233-5325 |
| MBTA | 617-222-3200 |
| Poison Control | 1-800-222-1222 |
| State Info | 211 |
