# Healthcare — Boston

## Overview

Boston has the **best healthcare in America**, arguably the world. More top-ranked hospitals per capita than anywhere. Medical tourism brings international patients.

### Why Boston Healthcare
- Harvard Medical School pipeline
- Major research institutions
- Biotech ecosystem
- Competition drives excellence

---

## Major Hospital Systems

### Mass General Brigham (MGB)
Largest system, Harvard-affiliated:

| Hospital | Specialty | Rank |
|----------|-----------|------|
| Massachusetts General Hospital | Everything | #4 US (US News 2024) |
| Brigham and Women's | Women's health, research | Top 20 |
| Dana-Farber Cancer Institute | Oncology | #4 cancer center |
| McLean Hospital | Psychiatry | #1 psychiatric |
| Spaulding Rehab | Rehabilitation | #2 rehab |

### Beth Israel Lahey
Another major Harvard-affiliated system:

| Hospital | Notes |
|----------|-------|
| Beth Israel Deaconess | Major research, good ER |
| Lahey Hospital (Burlington) | Suburban flagship |
| Mount Auburn (Cambridge) | Community, Harvard teaching |

### Boston Medical Center (BMC)
**Safety net hospital** — serves all regardless of ability to pay:
- Level 1 Trauma Center
- BU-affiliated
- Excellent care
- More accessible than elite systems

### Other Major Hospitals
| Hospital | Specialty |
|----------|-----------|
| Boston Children's | #1 pediatric in US |
| Tufts Medical Center | Good general, downtown |
| New England Baptist | Orthopedics |
| Joslin Diabetes Center | Diabetes specialty |
| Massachusetts Eye and Ear | Eye, ENT |

---

## Finding a Doctor

### Primary Care
Getting established with a PCP (primary care physician):

**Through a System:**
1. Go to hospital website (MGH, Beth Israel, etc.)
2. Search "Find a Doctor"
3. Filter by accepting new patients, insurance
4. Call for appointment

**Wait Times:**
- New patient appointments: 2-8 weeks
- Established patients: 1-2 weeks
- MGH/Brigham often longest waits

**Tips:**
- Community health centers have faster access
- Cambridge Health Alliance (Cambridge/Somerville)
- East Boston Community Health Center
- Codman Square (Dorchester)

### Specialists
Usually need PCP referral for:
- Dermatology (long waits)
- Psychiatry (very long waits)
- Most other specialists

**Workaround:** Some specialists accept self-referral. Call and ask.

---

## Insurance

### Requirement
Massachusetts requires health insurance (since 2006).

**Penalty:** Tax penalty for being uninsured.

### Sources
| Source | Who |
|--------|-----|
| Employer | Most common |
| MassHealth | Income-eligible (Medicaid) |
| Health Connector | Marketplace (ACA) |
| University | Students |
| Medicare | 65+ |

### MassHealth
State Medicaid program:
- Free or low-cost
- Income-eligible
- Good coverage
- Most providers accept

### Health Connector
ACA marketplace:
- Subsidies available based on income
- Multiple plan options
- Open enrollment Nov-Jan
- Special enrollment for qualifying events

### Typical Costs
| Plan Type | Monthly Premium | Notes |
|-----------|-----------------|-------|
| Employer (employee share) | $0-500 | Varies widely |
| Marketplace (subsidized) | $0-400 | Based on income |
| Marketplace (unsubsidized) | $400-800 | Individual |

---

## Urgent Care vs. ER

### Use Urgent Care For:
- Minor injuries
- Cold/flu
- Minor infections
- Sprains
- Rashes

**Urgent Care Options:**
- CareWell (multiple)
- AFC Urgent Care
- CVS MinuteClinic
- Hospital-affiliated urgent cares

**Cost:** $50-150 copay typical

### Use ER For:
- Chest pain
- Difficulty breathing
- Severe bleeding
- Signs of stroke
- Major trauma
- Psychiatric emergency

**Cost:** $200-500+ copay typical

### 911
Call for life-threatening emergencies:
- Chest pain
- Can't breathe
- Severe injury
- Stroke symptoms (FAST)

---

## Mental Health

### The Challenge
Mental health care access is difficult nationally, Boston included:
- Long waits for psychiatrists (months)
- Therapy wait times improving
- Demand exceeds supply

### Finding Help

**Through Insurance:**
- Call member services
- Search online provider directory
- Ask for referrals

**Other Resources:**
- Psychology Today directory
- Open Path Collective (sliding scale)
- Community health center behavioral health
- University training clinics (lower cost)

**Crisis Resources:**
- 988 (Suicide & Crisis Lifeline)
- Cambridge Health Alliance Crisis Team
- Emergency rooms for acute crisis

### McLean Hospital
Harvard-affiliated, top psychiatric hospital:
- Inpatient and outpatient
- Specialized programs
- Belmont location
- Excellent but competitive access

---

## Dental Care

### Finding a Dentist
Not always covered by health insurance:
- Dental insurance often separate
- Many employers offer
- Individual plans available

**Options:**
- Private dentists (many)
- Dental schools (Tufts, BU, Harvard)
- Community health center dental

**Dental School Clinics:**
Lower cost, supervised students:
- Tufts Dental (Boston)
- BU Dental (Boston)
- Harvard Dental (Boston)

---

## Pharmacies

### Major Chains
| Chain | Notes |
|-------|-------|
| CVS | Most locations, 24-hour in Back Bay |
| Walgreens | Common |
| Rite Aid | Some locations |

### Specialty Pharmacies
For complex medications:
- Hospital-affiliated pharmacies
- CVS Specialty
- Express Scripts (mail order)

### Cost Savings
- Generic when available
- GoodRx for discounts
- Mail order for maintenance meds
- Patient assistance programs

---

## For International Patients

### Medical Tourism
Boston attracts international patients for:
- Cancer treatment (Dana-Farber)
- Cardiac care (MGH)
- Pediatrics (Children's)
- Complex cases

### International Patient Services
Major hospitals have dedicated services:
- Translation
- Visa letters
- Travel coordination
- International insurance

### Self-Pay
Without US insurance, expect:
- High costs (US healthcare expensive)
- Negotiate cash prices
- Require payment arrangements
- Get cost estimates before procedures

---

## For Visitors

### Travel Insurance
Recommended for international visitors:
- Medical evacuation coverage
- Hospital stays expensive
- Outpatient care costly
- Check policy carefully

### If You Need Care
**Minor Issues:**
- CVS MinuteClinic (no appointment)
- Urgent care clinic

**Serious Issues:**
- Hospital ER
- Call 911 if emergency

---

## Healthcare Jobs

### Major Employer
Healthcare is ~20% of Boston employment:
- Hospitals
- Research institutions
- Biotech companies
- Insurance companies

### Types of Roles
| Role | Where |
|------|-------|
| Nurses (RN, NP) | Hospitals, clinics |
| Physicians | Hospitals, practices |
| Researchers | Hospitals, biotech |
| Administration | All settings |
| Allied health | Hospitals, clinics |

### Getting Hired
- Apply through hospital websites
- Strong nursing demand
- Research positions through labs
- Competitive for physicians

---

## Quick Reference

### Emergency Numbers
| Service | Number |
|---------|--------|
| Emergency | 911 |
| Poison Control | 1-800-222-1222 |
| Mental Health Crisis | 988 |

### Major ERs by Area
| Area | Hospital |
|------|----------|
| Downtown | Tufts Medical Center, MGH |
| Back Bay | Mass General |
| Cambridge | Mount Auburn, Cambridge Health Alliance |
| Longwood | Brigham and Women's, Children's, Beth Israel |
| South Boston | Carney Hospital |
| Dorchester | BMC (Trauma Center) |
