# Food Practical — Boston

## Dietary Accommodations

### Vegetarian
Boston does vegetarian well. Options everywhere.

**Dedicated Vegetarian:**
- Clover (multiple locations) — fast casual, creative
- Life Alive (Cambridge, Back Bay) — bowls, healthy
- Veggie Galaxy (Cambridge) — diner, vegan options

**Vegetarian-Friendly:**
- Most South End restaurants accommodate
- Oleana (Cambridge) — many veggie dishes
- Myers + Chang — good options

### Vegan
Growing scene, not comprehensive.

**Best Options:**
- Life Alive — extensive vegan menu
- Veggie Galaxy — vegan diner items
- By Chloe (Seaport) — chain, trendy
- Red Lentil (Watertown) — fully vegan

**Tips:**
- Most upscale places accommodate with notice
- Asian restaurants often have vegan by default
- Asking staff usually gets helpful responses

### Gluten-Free
Most restaurants accommodate. Quality varies.

**Best Bets:**
- Legal Sea Foods — trained staff, GF menu
- Dedicated GF bakeries exist
- Ask about cross-contamination if celiac

### Kosher
Limited but exists, mostly Brookline.

**Options:**
- Rami's (Brookline) — Middle Eastern, kosher
- Kupel's Bakery (Brookline) — baked goods
- Ruth's Kitchen (Brookline)

### Halal
Growing options in diverse areas.

**Best Areas:**
- Allston — Shawarma King, others
- Cambridge — several options
- East Boston — some Latin spots

---

## Alcohol Rules

### Legal Basics
- **Drinking age**: 21 (strictly enforced)
- **ID required**: Always carry ID, even if older
- **Bars close**: 2am (no exceptions)
- **Last call**: 1:30-1:45am typically
- **Liquor stores**: Close 11pm max

### Happy Hour Ban
**Massachusetts banned happy hour drink specials in 1984.**

- No discounted drinks at bars
- No two-for-one deals
- Food specials OK, drink specials not

**Why**: Drunk driving accident involving a bar with happy hour led to law.

**What exists instead:**
- Food specials (apps, oysters)
- Prix fixe dinners
- Reverse happy hour (late night food deals)

### Sunday Sales
- Liquor stores open at noon
- Bars/restaurants serve all day
- Some regional restrictions relaxed recently

### Where to Buy
- **Liquor stores**: Wine, beer, spirits
- **Grocery stores**: Beer and wine only (recent change)
- **Convenience stores**: Beer only, limited selection

---

## Restaurant Week

Twice yearly: March and August.

### How It Works
- Participating restaurants offer prix fixe menus
- Typically $28 lunch, $40 dinner
- 1-2 weeks, reservations required

### Is It Worth It?
- Good for trying expensive places cheaper
- Some restaurants phone it in
- Best: high-end places with real value
- Avoid: places that are always affordable

### Tips
- Book early (reservations go fast)
- Check menu before booking
- Lunch often better value
- Some places better deals than others

---

## Brunch Culture

Boston loves brunch. Weekend phenomenon.

### Reservations
- Popular spots require booking
- 10am-11am slots go first
- Walk-in possible at 2pm+ usually

### Best Brunch Areas
- South End — multiple options
- Cambridge — Harvard Square, Inman
- Somerville — Davis Square
- Brookline — Coolidge Corner

### Notable Brunches
- Tatte (multiple) — Israeli-style
- The Gallows (South End) — boozy, social
- Highland Kitchen (Somerville) — Southern
- Zaftigs (Brookline) — Jewish deli style

### Tips
- Earlier = easier to get table
- Many places do bottomless mimosas/bloody marys
- Brunch = lunch prices, not breakfast prices

---

## Late Night Eating

Boston shuts down early. Options after midnight:

### Chinatown (Best Option)
- Gourmet Dumpling House
- Peach Farm
- Many others until 2-3am

### Other Options
- Bova's Bakery (North End) — 24 hours
- IHOP (Cambridge) — chain, 24 hours
- South Street Diner (Leather District) — 24 hours
- The Sil's (Allston) — pizza, late

### Reality
After 10pm options thin dramatically outside Chinatown. Plan accordingly.

---

## Coffee Culture

### Local Chains
- **Tatte** — Israeli bakery/cafe, popular
- **Flour** — Joanne Chang's bakery
- **Pavement** — Boston-based, good espresso
- **George Howell** — serious specialty coffee

### Third Wave / Specialty
- George Howell (multiple) — founder of specialty coffee
- Gracenote (Fort Point) — serious, small
- Broadsheet (Cambridge) — quality

### Reality
Dunkin' (not Dunkin' Donuts) is religion here. You'll see one every block. Locals order "regular" (cream and sugar). Iced coffee year-round, even in blizzards.

---

## Food Delivery

### Apps
- DoorDash — largest coverage
- Uber Eats — good selection
- Grubhub — Boston-strong
- Caviar — higher-end

### Tips
- Delivery fees add up
- Many restaurants do their own delivery
- Call direct often cheaper
- Cold weather = long waits

---

## Tipping Guide

| Service | Amount |
|---------|--------|
| Sit-down restaurant | 18-20% |
| Counter service | $1-2 or 15% |
| Bartender | $1-2 per drink |
| Delivery | 15-20% |
| Takeout | 10-15% if prompted |
| Coffee shop | Optional, $1 |

### Notes
- 20% increasingly expected at restaurants
- Some places add automatic gratuity for large groups
- Check your bill (sometimes included)

---

## Grocery Shopping

### Chains
| Store | Vibe | Price |
|-------|------|-------|
| Whole Foods | Organic, upscale | $$$$ |
| Trader Joe's | Unique items, value | $$ |
| Star Market | Standard grocery | $$$ |
| Stop & Shop | Standard grocery | $$ |
| Market Basket | Value, basic | $ |
| H Mart | Asian groceries | $$ |

### Specialty
- Boston Public Market — local vendors
- Eataly — Italian groceries
- Savenor's (Cambridge) — high-end butcher

### Tips
- Market Basket is beloved for low prices
- Whole Foods everywhere but expensive
- Asian markets (H Mart, Super 88) for specialty

---

## Food Festivals

| Event | When | What |
|-------|------|------|
| Taste of Cambridge | June | Restaurant sampling |
| Boston Seafood Festival | August | Seafood focus |
| Chowderfest | July | Chowder competition |
| SoWa Open Market | Sundays (warm months) | South End food/art |

### Seasonal Events
- Restaurant Week (March, August)
- Dine Out Boston
- Various neighborhood festivals
