# Food Overview — Boston

## The Boston Food Identity

Boston isn't a "food city" like NYC or LA, but has genuine strengths:
- **Seafood**: Lobster, clams, oysters — best in America
- **Italian**: North End is legitimate
- **New American**: South End restaurant scene
- **Asian**: Chinatown authentic, suburban diversity
- **Irish pubs**: What you'd expect
- **Innovation**: Kendall/Cambridge chef-driven spots

## What Boston Does Best

### Seafood
This is why you're here. Boston Harbor means fresh catch daily.

**Must-try:**
- Lobster roll (Maine style = cold/mayo, Connecticut = warm/butter)
- New England clam chowder (never Manhattan style here)
- Oysters (Island Creek, local farms)
- Fried clams (belly clams, not strips)

### North End Italian
Real Italian-American tradition, not trendy. Multi-generation family restaurants.

### South End New American
Boston's foodie neighborhood. Chef-driven, seasonal, reservations recommended.

### Cambridge Innovation
Near Harvard/MIT: interesting fusion, health-conscious, international influences.

## Dining Neighborhoods

| Area | Style | Price | Best For |
|------|-------|-------|----------|
| South End | New American, upscale | $$-$$$$ | Foodies, dates |
| North End | Italian, seafood | $$-$$$ | Classic Boston |
| Cambridge | Diverse, innovative | $$-$$$ | Variety |
| Chinatown | Chinese, Asian | $-$$ | Authentic, late night |
| Seaport | Trendy, waterfront | $$$-$$$$ | Views, scene |
| Somerville | Diverse, value | $-$$$ | Hidden gems |

## Price Guide

| Symbol | Per Person | Example |
|--------|------------|---------|
| $ | Under $20 | Clover, El Pelon |
| $$ | $20-40 | Row 34, Area Four |
| $$$ | $40-70 | Myers + Chang, Neptune |
| $$$$ | $70+ | No. 9 Park, Menton |

## Reservations

**Book ahead (1-2 weeks+):**
- Neptune Oyster
- Toro
- No. 9 Park
- Uni

**Walk-in friendly:**
- Most North End places
- Chinatown
- Casual spots everywhere

**OpenTable/Resy work well.** Some hot spots use Resy exclusively.

## Local Chains Worth Knowing

| Chain | What | Where |
|-------|------|-------|
| Legal Sea Foods | Reliable seafood | Multiple |
| Flour Bakery | Bakery, sandwiches | Multiple |
| Clover | Fast-casual vegetarian | Multiple |
| b.good | Healthy fast food | Multiple |
| Tatte | Israeli bakery/cafe | Multiple |

## Seasonal Considerations

### Summer
- Outdoor dining everywhere
- Rooftop bars peak season
- Lobster prices lower (peak catch)
- Reservations harder

### Winter
- Restaurant Week (March, August) — deals
- Fewer tourists, easier reservations
- Oyster season peak
- Comfort food focus

## Meal Timing

| Meal | Typical Time | Notes |
|------|--------------|-------|
| Breakfast | 7-10am | Cafes open early |
| Brunch | 10am-2pm | Weekend thing, book ahead |
| Lunch | 12-2pm | Business district packed |
| Dinner | 6-9pm | Earlier than NYC |
| Late night | After 10pm | Limited options, Chinatown |

**Boston eats early.** Many kitchens close by 10pm. Chinatown for late night.

## Tipping

- **Restaurants**: 18-20% standard
- **Bars**: $1-2 per drink
- **Counter service**: $1-2 or tip jar
- **Takeout**: 10-15% if prompted

## Dietary Accommodations

| Diet | How Boston Does |
|------|-----------------|
| Vegetarian | Good, Clover excellent |
| Vegan | Growing, By Chloe, Life Alive |
| Gluten-free | Most places accommodate |
| Kosher | Limited, Brookline has options |
| Halal | Decent in diverse areas |

## Food Media

**Critics to follow:**
- Boston Globe food section
- Eater Boston
- Boston Magazine "Best of Boston"

**Best of Boston awards** (Boston Magazine) are the local Oscars of dining.
