# Education — Boston

## Higher Education Capital

Boston metro has **50+ colleges and universities** with ~250,000 students. Education shapes the city's identity, economy, and culture.

---

## Major Universities

### Research Universities

| University | Location | Students | Known For |
|------------|----------|----------|-----------|
| Harvard | Cambridge | 23,000 | Everything, oldest US university |
| MIT | Cambridge | 11,500 | Engineering, tech, science |
| Boston University | Boston (Comm Ave) | 34,000 | Large, urban, research |
| Northeastern | Boston (Fenway) | 22,000 | Co-op program, career focus |
| Tufts | Medford/Somerville | 12,000 | Research, international relations |
| Boston College | Chestnut Hill | 14,500 | Catholic, business, law |
| Brandeis | Waltham | 5,800 | Research, Jewish heritage |

### Specialized Schools

| School | Focus | Location |
|--------|-------|----------|
| Berklee | Music | Back Bay |
| New England Conservatory | Classical music | Back Bay |
| Emerson | Communications, arts | Theater District |
| Massachusetts College of Art | Art, design | Fenway |
| Wentworth | Engineering, architecture | Fenway |
| Suffolk | Business, law | Downtown |

### Community Colleges

| School | Location | Notes |
|--------|----------|-------|
| Bunker Hill CC | Charlestown | Largest in MA |
| Roxbury CC | Roxbury | Affordable access |
| MassBay CC | Wellesley/Framingham | Suburban |

---

## The Harvard-MIT Axis

### Harvard University
Founded 1636. America's oldest and most prestigious.

**Key Facts:**
- Cambridge, near Harvard Square
- Undergraduate (Harvard College) + 12 graduate schools
- $50+ billion endowment (largest in world)
- Admissions: ~3% acceptance rate

**Graduate/Professional Schools:**
- Harvard Business School (HBS)
- Harvard Law School
- Harvard Medical School
- Kennedy School (public policy)
- Harvard Graduate School of Education

**For the Public:**
- Harvard Yard: Open to walk through
- Harvard Art Museums: Public admission
- Many public lectures
- Harvard Extension: Open enrollment

### MIT
Founded 1861. World's top technical university.

**Key Facts:**
- Cambridge, Kendall Square
- Engineering, science, technology focus
- Startup culture (hundreds of companies founded)
- Admissions: ~4% acceptance rate

**Notable:**
- Stata Center (Frank Gehry architecture)
- Media Lab (innovation center)
- Hacks (legendary student pranks)
- Strong AI/robotics research

**For the Public:**
- Campus open to walk
- MIT Museum
- Public lectures common

---

## Student Life

### Where Students Live

| University | Student Areas |
|------------|---------------|
| Harvard | Harvard Square, Somerville |
| MIT | Cambridge, Kendall area |
| BU | Allston, Brookline |
| Northeastern | Fenway, Mission Hill |
| BC | Brighton, Newton |
| Emerson | Theater District, Back Bay |

### Cost of Attendance (2024-2025)
| School | Tuition + Room/Board |
|--------|---------------------|
| Harvard | ~$80,000 |
| MIT | ~$80,000 |
| BU | ~$80,000 |
| Northeastern | ~$78,000 |
| BC | ~$80,000 |
| Tufts | ~$82,000 |

**Financial Aid:** Top schools meet full demonstrated need. Many students pay far less than sticker price.

### Student Budget (Living Off-Campus)
| Expense | Monthly |
|---------|---------|
| Rent (shared) | $1,000-1,500 |
| Food | $400-600 |
| Transportation | $90 (T pass) |
| Books/supplies | $100-200 |
| Personal | $200-400 |
| **Total** | **$1,800-2,700** |

---

## K-12 Education

### Public Schools

**Boston Public Schools (BPS):**
- ~49,000 students
- Mixed performance
- Some excellent exam schools
- Choice-based system

**Exam Schools (Selective):**
| School | Grades | Notes |
|--------|--------|-------|
| Boston Latin School | 7-12 | Oldest public school in America (1635) |
| Boston Latin Academy | 7-12 | Strong academics |
| John D. O'Bryant | 7-12 | Math/Science focus |

**Suburban Public Schools:**
Top-ranked districts (expensive towns):
- Brookline
- Newton
- Lexington
- Wellesley
- Weston
- Concord-Carlisle

### Private Schools

**Day Schools:**
| School | Grades | Notes |
|--------|--------|-------|
| Buckingham Browne & Nichols | K-12 | Cambridge, competitive |
| Noble and Greenough | 7-12 | Dedham, prep school |
| Roxbury Latin | 7-12 | Boys, oldest in continuous operation |
| Milton Academy | K-12 | Day and boarding |
| Winsor | 5-12 | Girls, Boston |

**Tuition:** $40,000-60,000/year typical

### Boarding Schools
Boston area has several famous boarding schools:
- Phillips Academy Andover
- Groton School
- Milton Academy (also day)
- St. Mark's School
- Middlesex School

---

## Continuing Education

### For Adults

**University Extension Programs:**
| Program | Notes |
|---------|-------|
| Harvard Extension | Open enrollment, degrees available |
| MIT Professional Education | Certificates, short courses |
| BU Metropolitan College | Evening/weekend degrees |
| Northeastern Professional Studies | Online and in-person |

**Harvard Extension School:**
- No admissions requirements
- Take Harvard courses
- Degrees available (with requirements)
- Much more affordable than regular Harvard

### Test Prep & Tutoring
Many options for SAT, GRE, GMAT, LSAT:
- Kaplan
- Princeton Review
- Private tutors (expensive but effective)
- Free: Khan Academy (SAT)

### English Language
For non-native speakers:
- University ESL programs
- Community college ESL
- Private language schools
- Library programs (free)

---

## Research Opportunities

### For Students
- Undergraduate research common at research universities
- Summer research programs (REUs)
- Lab positions available
- Strong STEM opportunities

### For Professionals
- Research positions at universities
- Hospital research (many options)
- Biotech companies
- Collaborations between sectors

---

## Libraries

### Boston Public Library (BPL)
**Free with MA address:**
- Main branch: Copley Square (beautiful building)
- 25+ neighborhood branches
- E-books, streaming, databases
- Museum passes (free!)
- Research resources

### University Libraries
Many open to public (reading access):
- Widener Library (Harvard)
- MIT Libraries
- Boston University

---

## Calendar Effects

### September
- Student move-in (chaos, especially Sept 1)
- City population swells
- Restaurants, bars busier
- Traffic increases

### December
- Students leave for break
- City quieter
- Restaurants less crowded

### May
- Student move-out
- Graduation ceremonies (traffic around universities)
- City empties slightly

### Summer (June-August)
- Many students gone
- City feels different
- Good time for locals
- Some areas quieter

---

## For Prospective Students

### Visiting Boston Schools
**Best Times:**
- Fall (Sept-Nov): Campus active
- Spring (March-April): Accepted student days
- Avoid: Finals (Dec, May), breaks

**Campus Tours:**
- Most schools offer daily tours
- Book through admissions website
- Combine multiple schools in one trip

### Application Tips
- Boston schools are very competitive
- Strong academics required
- Extracurriculars matter
- Legacy helps at some schools
- Financial aid available at top schools

---

## Education Employment

### Teaching Jobs
| Level | Where to Look |
|-------|---------------|
| K-12 Public | SchoolSpring, district websites |
| K-12 Private | School websites, AISNE |
| Higher Ed | HigherEdJobs, university HR |

### Research Jobs
- University lab websites
- Nature Jobs
- Science Careers
- Hospital research portals

### Administration
- University HR portals
- Higher Ed Jobs
- LinkedIn
