# Driving & Car Ownership — Boston

## Should You Have a Car?

### You Probably Don't Need One If:
- Living in Boston/Cambridge/Somerville near T
- Working along transit lines
- Budget-conscious (car costs $600-1,400/month total)
- Comfortable with occasional rideshare

### You Might Want One If:
- Living in suburbs
- Working outside transit network
- Family with kids
- Frequent weekend trips
- Job requires travel

### Compromise Options
- Zipcar (hourly rental)
- Turo (daily rental)
- Uber/Lyft for occasional needs
- Rent for weekend trips

---

## Parking Realities

### Street Parking
Resident permit required in most neighborhoods:
- Apply at City Hall or online
- Bring: lease, registration, ID
- Cost: $25/year
- Wait time: 1-2 weeks

**Even with permit:**
- Not guaranteed a spot
- Competition varies by neighborhood
- Snow = nightmare
- Some areas have waitlists

### Garage Parking
| Area | Monthly Cost |
|------|--------------|
| Back Bay | $400-500 |
| Beacon Hill | $400-500 |
| South End | $300-400 |
| Seaport | $350-450 |
| Cambridge | $250-350 |
| Somerville | $200-300 |
| Jamaica Plain | $150-250 |

### Snow Emergencies
**CRITICAL: Learn this or pay hundreds.**

When Boston declares snow emergency:
1. Must move car from snow emergency routes
2. Within 2 hours of declaration
3. Cars towed immediately (no grace period)
4. Tow fee: $100+ plus storage

**How to Know:**
- Sign up for text alerts (boston.gov)
- Check social media
- Look for signs on your street
- When in doubt, assume emergency

**Space Savers:**
Controversial Boston tradition:
- After shoveling, residents "claim" spot with furniture
- Technically allowed for 48 hours after emergency
- Not legal but tolerated
- Moving someone's saver = rage

---

## Vehicle Registration

### Timeline for New Residents
1. **Within 30 days**: Begin process
2. **Before registration**: Get MA inspection
3. **Inspection**: $35, any licensed station
4. **Insurance**: Required before registration
5. **RMV**: Register and get plates

### What You Need at RMV
- Out-of-state title
- Massachusetts insurance (in effect)
- Completed registration form
- Photo ID
- Payment ($75 registration)

### RMV Tips
- **Book appointment online** (walk-ins terrible)
- Bring all documents
- Expect to wait even with appointment
- Main locations: Boston, Cambridge, Watertown

---

## Insurance

### Massachusetts Requirements
- Bodily injury: $20,000/$40,000
- Property damage: $5,000
- Personal injury protection: $8,000
- Uninsured motorist: $20,000/$40,000

### Cost Reality
Massachusetts has high insurance rates:
- Average: $1,500-2,000/year
- Boston proper: Higher
- Clean record: Lower
- Young drivers: Much higher

### Finding Insurance
- Shop around (rates vary significantly)
- Common insurers: Geico, Liberty Mutual, Progressive, Arbella
- Bundle with renter's insurance for discount
- Ask about discounts (safe driver, low mileage)

---

## Driving in Boston

### The Reality
Boston is notoriously difficult to drive:
- **Streets**: Not a grid, confusing layout
- **Drivers**: Aggressive ("Massholes")
- **Traffic**: Among worst in US
- **Parking**: Near impossible downtown

### Navigation
- **GPS essential**: Don't try without it
- **Waze**: Good for traffic avoidance
- **Google Maps**: Reliable routing
- **Apple Maps**: Improved, works fine

### Rush Hour
**Avoid if possible:**
- Morning: 7-9am
- Evening: 4-7pm
- I-93: Always bad
- Storrow Drive: Packed
- Mass Pike (I-90): Busy

### Boston Driver Culture
What to expect:
- Aggressive merging
- Horn honking
- Fast lane changes
- Running yellow/red lights
- Parking anywhere (badly)

**Defensive driving essential.**

---

## Traffic Laws

### Speed Limits
- City streets: 25 mph (reduced 2020)
- Highways: 55-65 mph
- School zones: 20 mph

### Right Turn on Red
- Allowed unless posted otherwise
- Come to complete stop first
- Yield to pedestrians (they have right of way)

### Cell Phone Law
- Hands-free only
- No handheld use while driving
- Heavy fines for violations

### Pedestrian Laws
- Pedestrians have right of way in crosswalks
- Stop for anyone in crosswalk
- Boston pedestrians jaywalk constantly

---

## Common Routes

### Major Highways
| Highway | Where It Goes |
|---------|---------------|
| I-93 | North-south through Boston |
| I-90 (Mass Pike) | East-west, connects to NY |
| I-95/Route 128 | Circumferential, suburbs |
| Route 2 | West to suburbs, Concord |
| Route 1 | North to airport area |

### Storrow Drive
- Local highway along Charles River
- Beautiful but stressful
- Low bridges (trucks get stuck, meme)
- Very congested rush hour

### Avoiding Traffic
- Use Waze religiously
- Avoid highways during rush
- Back roads sometimes faster
- Red Sox games = avoid Fenway area

---

## Tolls

### All-Electronic Tolling
Massachusetts uses E-ZPass and Pay By Plate:
- No toll booths
- Cameras read plates
- E-ZPass: Discounted rates
- Pay By Plate: Bill mailed, higher rate

### Getting E-ZPass
- Online at mass.gov/ezpass
- Or at participating retailers
- Works in 17+ states
- Essential for Mass Pike

### Toll Costs
| Route | Cost (E-ZPass) |
|-------|----------------|
| Mass Pike (full length) | ~$8 |
| Tobin Bridge | $1.75 |
| Ted Williams Tunnel | $1.75 |

---

## Car Ownership Costs

### Monthly Breakdown (Typical)
| Expense | Cost |
|---------|------|
| Car payment | $300-600 |
| Insurance | $125-200 |
| Parking | $200-500 |
| Gas | $100-200 |
| Maintenance | $50-100 |
| Tolls | $20-50 |
| **Total** | **$795-1,650** |

### Vs. No Car
If you don't own a car:
- T pass: $90/month
- Occasional Uber: $100-200/month
- Zipcar/rental: $50-100/month
- **Total: $240-390/month**

**Savings: $500-1,200/month**

---

## Car Sharing

### Zipcar
Hourly car rental:
- Membership: $70/year
- Hourly rates: $10-15/hour
- Daily rates: $80-100
- Gas and insurance included
- Cars parked throughout city

### Turo
Peer-to-peer car rental:
- Like Airbnb for cars
- Good for weekend trips
- Prices vary widely

### Enterprise/Hertz
Traditional rental:
- Good for longer trips
- Weekend specials available
- Airport locations

---

## Maintenance

### Finding a Mechanic
- Ask for neighborhood recommendations
- Yelp reviews helpful
- Dealerships more expensive
- Many good independent shops

### Common Issues
- Pothole damage (Boston roads rough)
- Winter wear (salt, cold)
- Brake wear (city driving)
- Battery issues (cold weather)

### Inspection
- Annual state inspection required
- $35 fee
- Any licensed station
- Sticker valid 12 months

---

## Day Trips by Car

### Popular Drives
| Destination | Time | Notes |
|-------------|------|-------|
| Cape Cod | 1.5-3 hours | Traffic dependent, summer brutal |
| Salem | 30-45 min | Fall very busy |
| Portland, ME | 2 hours | Easy drive |
| Newport, RI | 1.5 hours | Scenic |
| White Mountains, NH | 2-2.5 hours | Skiing, hiking |
| Berkshires | 2.5 hours | Fall foliage |
| Providence | 1 hour | Easy day trip |

### Tips
- Leave early (avoid traffic)
- Check traffic before going
- Weekend vs. weekday matters
- Summer to Cape = plan for delays
