# Cost of Living — Boston

## Overview

Boston is the **3rd most expensive US metro** after NYC and San Francisco. Housing drives most of the cost.

### Monthly Budget Estimates

| Lifestyle | Monthly Total | Notes |
|-----------|---------------|-------|
| Student/minimal | $2,500-3,200 | Roommates, careful spending |
| Young professional | $3,500-4,500 | 1BR, moderate dining |
| Comfortable single | $4,500-6,000 | Nice 1BR, dining out |
| Couple (no kids) | $6,000-8,500 | 2BR, comfortable |
| Family (2 kids) | $10,000-15,000 | 3BR, childcare, schools |

---

## Housing Costs

### Rent by Neighborhood (1BR)

| Area | Range | Notes |
|------|-------|-------|
| Back Bay | $2,800-3,800 | Premium, walkable |
| Beacon Hill | $3,000-4,500 | Historic, charming |
| South End | $2,600-3,500 | Foodie neighborhood |
| Seaport | $3,200-4,500 | New construction |
| Cambridge (Harvard) | $2,600-3,500 | Academic, walkable |
| Cambridge (Kendall) | $3,200-4,500 | Tech hub, modern |
| Somerville | $2,200-2,900 | Hip, value |
| Jamaica Plain | $1,900-2,500 | Artsy, nature |
| Allston/Brighton | $1,700-2,300 | Student, cheapest |
| East Boston | $1,900-2,500 | Diverse, improving |
| Dorchester | $1,500-2,200 | Diverse, value |

### Rent by Unit Size

| Type | Boston Proper | Cambridge | Suburbs |
|------|---------------|-----------|---------|
| Studio | $1,800-2,400 | $2,000-2,600 | $1,400-1,800 |
| 1BR | $2,200-3,500 | $2,400-3,500 | $1,600-2,200 |
| 2BR | $2,800-4,500 | $3,000-4,500 | $2,000-2,800 |
| 3BR | $3,500-6,000 | $3,800-6,000 | $2,500-3,500 |

### Additional Housing Costs

| Cost | Amount | Notes |
|------|--------|-------|
| Broker fee | 1 month rent | Most rentals |
| Security deposit | 1 month rent | Standard |
| First/last month | 2 months rent | Required upfront |
| Renter's insurance | $15-30/month | Recommended |
| Heat (winter) | $100-200/month | Often tenant-paid |

**Total upfront for $2,500/month apartment:**
First + Last + Security + Broker = **$10,000**

---

## Utilities

### Monthly Estimates

| Utility | 1BR | 2BR | Notes |
|---------|-----|-----|-------|
| Electricity | $50-100 | $80-150 | Higher with AC |
| Gas (heat) | $30-200 | $50-300 | Huge winter spike |
| Internet | $50-80 | $50-80 | Comcast/RCN |
| Phone | $50-100 | $50-100 | Per person |
| Water | Usually included | - | Check lease |

### Seasonal Variation
- **Summer**: +$50-100 for AC
- **Winter**: +$100-200 for heating
- **Spring/Fall**: Lowest utility months

---

## Transportation

### Without a Car

| Item | Monthly Cost |
|------|--------------|
| MBTA pass | $90 |
| Occasional rideshare | $50-150 |
| Bluebikes membership | $10-20 |
| **Total** | **$150-260** |

### With a Car

| Item | Monthly Cost |
|------|--------------|
| Car payment | $300-600 |
| Insurance | $100-200 |
| Parking | $200-500 |
| Gas | $100-200 |
| Maintenance | $50-100 |
| **Total** | **$750-1,600** |

**Bottom line:** Owning a car in Boston adds $600-1,400/month vs. transit-only.

---

## Food

### Groceries

| Budget Level | Monthly/Person | Where to Shop |
|--------------|----------------|---------------|
| Budget | $250-350 | Market Basket, Aldi |
| Moderate | $350-500 | Star Market, Stop & Shop |
| Premium | $500-700 | Whole Foods, Trader Joe's |

### Dining Out

| Meal Type | Cost Range |
|-----------|------------|
| Coffee | $3-6 |
| Fast casual lunch | $12-18 |
| Casual dinner | $20-40/person |
| Nice dinner | $50-100/person |
| Upscale dinner | $100-200/person |
| Drinks (cocktail) | $14-18 |
| Beer at bar | $7-10 |

### Monthly Dining Budget

| Lifestyle | Amount | Pattern |
|-----------|--------|---------|
| Minimal | $100-200 | Rare dining out |
| Moderate | $300-500 | 1-2x/week casual |
| Social | $500-800 | Regular dining, drinks |
| Foodie | $800-1,500 | Frequent nice dinners |

---

## Healthcare

### Insurance Costs
- Employer-sponsored: $0-500/month (employee portion)
- Marketplace (ACA): $300-600/month
- MassHealth: Free if income-eligible

### Out-of-Pocket
- Primary care visit: $20-50 copay typical
- Specialist: $30-75 copay
- Emergency room: $100-500 copay

**Note:** Massachusetts requires health insurance. Penalty for uninsured.

---

## Childcare (If Applicable)

Boston has among the highest childcare costs in the US.

| Type | Monthly Cost |
|------|--------------|
| Daycare (infant) | $2,500-3,500 |
| Daycare (toddler) | $2,000-3,000 |
| Preschool | $1,500-2,500 |
| Nanny (full-time) | $3,500-5,000 |
| After-school care | $500-1,000 |

**Waitlists:** 6-12+ months for popular daycares. Start looking early.

---

## Entertainment & Lifestyle

### Fitness
| Option | Monthly Cost |
|--------|--------------|
| Budget gym (Planet Fitness) | $10-25 |
| Standard gym (BSC, Equinox) | $50-200 |
| Boutique class (Barry's, SoulCycle) | $150-300 |
| ClassPass | $50-150 |

### Entertainment
| Activity | Cost |
|----------|------|
| Movie ticket | $15-20 |
| Red Sox ticket | $35-200 |
| Celtics/Bruins ticket | $50-300 |
| Concert (House of Blues) | $30-100 |
| Museum admission | $20-30 |

### Subscriptions
Budget $50-200/month for streaming, news, apps, etc.

---

## Taxes

### State Income Tax
Massachusetts has flat 5% income tax.

### Sales Tax
- General: 6.25%
- Clothing under $175: No tax
- Restaurant meals: 7% (6.25% + 0.75% local)

### Property Tax (If Buying)
Boston residential rate: ~1.0% of assessed value
Varies by municipality.

---

## Sample Budgets

### Student/Recent Grad ($45K salary)
| Category | Monthly |
|----------|---------|
| Rent (room in shared) | $1,200 |
| Utilities share | $75 |
| T pass | $90 |
| Groceries | $300 |
| Dining out | $150 |
| Phone/Internet | $80 |
| Entertainment | $100 |
| Miscellaneous | $100 |
| **Total** | **$2,095** |

### Young Professional ($85K salary)
| Category | Monthly |
|----------|---------|
| Rent (1BR Somerville) | $2,400 |
| Utilities | $150 |
| T pass + rideshare | $150 |
| Groceries | $400 |
| Dining out | $400 |
| Phone/Internet | $100 |
| Entertainment | $200 |
| Health insurance | $100 |
| Savings | $300 |
| **Total** | **$4,200** |

### Couple, No Kids ($180K combined)
| Category | Monthly |
|----------|---------|
| Rent (2BR South End) | $3,800 |
| Utilities | $200 |
| Transportation | $250 |
| Groceries | $700 |
| Dining out | $700 |
| Phone/Internet | $150 |
| Entertainment | $400 |
| Health insurance | $200 |
| Savings | $800 |
| **Total** | **$7,200** |

---

## Money-Saving Tips

### Housing
- Off-cycle leases (Feb, June) = less competition, sometimes lower rent
- Look at Somerville, JP, East Boston for value
- Roommates cut costs significantly
- Negotiate (especially with independent landlords)

### Transportation
- Monthly T pass pays off at 38+ rides/month
- Bluebikes cheaper than rideshare for short trips
- Don't own a car unless truly necessary

### Food
- Market Basket saves 20-30% on groceries
- Pack lunch (saves $200-300/month easily)
- Happy hour food specials (drinks aren't discounted)
- Restaurant Week for upscale on budget

### General
- Library card = free museum passes
- Student discounts (if applicable)
- Free summer concerts at Hatch Shell
- BPL has free streaming services
