# Weather & Climate — Boston

## Four Seasons Reality

Boston has **true four seasons**, each with distinct character. Plan accordingly.

### Annual Overview

| Season | Months | Temp Range | Character |
|--------|--------|------------|-----------|
| Winter | Dec-Mar | 20-40F (-7 to 4C) | Cold, snowy, gray |
| Spring | Apr-May | 45-65F (7-18C) | Unpredictable, rainy |
| Summer | Jun-Aug | 70-90F (21-32C) | Hot, humid |
| Fall | Sep-Nov | 50-70F (10-21C) | Best weather, foliage |

---

## Winter (December - March)

### What to Expect
- **Temperature**: 20-40F typical, can drop to 0-10F
- **Wind chill**: Makes it feel 10-20 degrees colder
- **Snow**: 40-50 inches average per year
- **Major storms**: 2-4 significant snowfalls
- **Daylight**: Short (4:30pm sunset in December)

### The Reality
Boston winters are **not mild**. Wind off the harbor makes it bitter. January-February are the worst.

**Days below freezing**: 100+ per year
**Days below 0F**: Usually a few each winter

### Survival Gear (Essential)

| Item | Why |
|------|-----|
| Heavy waterproof coat | Wind and snow |
| Waterproof boots | Slush, puddles |
| Wool/fleece layers | Insulation |
| Warm hat covering ears | Wind cuts through |
| Insulated gloves | Fingers freeze fast |
| Scarf/neck gaiter | Protect face |

**Don't cheap out on winter gear.** Good coat and boots are investments.

### Winter Tips

**Getting Around:**
- T runs slower in cold/snow
- Allow extra time
- Keep phone battery warm (cold drains it)
- Ice on sidewalks — walk carefully

**At Home:**
- Keep heat at 55F+ minimum (pipes freeze)
- Know your heating system
- Stock basics before storms

**Snow Emergencies:**
- City declares emergencies for major storms
- Must move car from marked routes
- Towing is immediate
- Check boston.gov for declarations

---

## Spring (April - May)

### What to Expect
- **Temperature**: 45-65F, highly variable
- **Rain**: Frequent showers
- **Unpredictable**: Can snow in April, hit 80F in May

### The Reality
Spring arrives late and inconsistently. "April showers" is real. May is usually pleasant.

**Mud season**: March-April, ground thawing, wet everywhere

### What to Wear
- Layers (huge temp swings within days)
- Light waterproof jacket
- Umbrella always
- Transitional footwear

### Spring Events
- **Marathon Monday**: Third Monday of April
- **Cherry blossoms**: Late April at Esplanade
- **Opening Day**: Red Sox start (April)
- **College move-out**: May

---

## Summer (June - August)

### What to Expect
- **Temperature**: 75-90F, occasional 95F+
- **Humidity**: HIGH (70%+ common)
- **Heat index**: Can feel 100F+
- **Thunderstorms**: Afternoon storms common

### The Reality
Boston summers are **hot and humid**. Not Southern-level, but significant. Heat index can be brutal.

**AC note**: Many older buildings don't have central AC. Window units common.

### Survival Tips

**Stay Cool:**
- Seek AC during peak heat (2-5pm)
- Charles River Esplanade for breeze
- Harbor areas cooler
- Libraries, museums, malls for free AC

**What to Wear:**
- Light, breathable fabrics
- Sunscreen
- Sunglasses
- Light rain jacket (afternoon storms)

**Hydration:**
- Carry water bottle
- Free water at many public spaces
- Signs of heat exhaustion: dizziness, nausea

### Summer Events
- **Harbor Islands**: Open May-October
- **Outdoor concerts**: Hatch Shell (free)
- **Rooftop bars**: Peak season
- **Beach days**: Cape Cod, Revere, South Boston

---

## Fall (September - November)

### What to Expect
- **September**: 65-75F, summer-like
- **October**: 50-65F, foliage peak
- **November**: 40-55F, getting cold

### The Reality
**Best weather of the year.** Clear skies, comfortable temperatures, stunning foliage.

**Foliage timing**: Peak mid-October for Boston area. Earlier north.

### What to Wear
- Layers
- Light jacket/sweater
- Comfortable walking shoes
- Warmer coat by November

### Fall Events
- **Head of the Charles**: Rowing (October)
- **Foliage drives**: North/west of city
- **Halloween**: Salem madness
- **College move-in**: September 1st chaos

---

## Weather Extremes

### Heat Waves
Several per summer. When forecast:
- Check on elderly neighbors
- Stay hydrated
- Limit outdoor exertion 11am-4pm
- Know signs of heat stroke

### Nor'easters
Major winter storms that hit New England. Can bring:
- 12-24+ inches of snow
- High winds
- Coastal flooding
- Power outages

**Preparation:**
- Stock food/water before storm
- Charge devices
- Know snow emergency routes
- Have flashlight, batteries

### Hurricanes/Tropical Storms
Rare but possible (August-October).
- Usually weakened by time they reach Boston
- More often tropical storms than direct hits
- Flooding, wind main concerns

---

## Indoor Considerations

### Heating
Most apartments use:
- Gas heat (radiators or forced air)
- Electric heat (expensive)

**Winter heating costs**: $100-200/month

### Air Conditioning
Many older buildings lack central AC.
- Window units common
- Some newer buildings have central
- Ask before signing lease

**Summer AC costs**: $50-100/month additional electricity

### Building Age
Boston has many old buildings:
- Poor insulation = higher bills
- Drafty in winter
- Hot in summer
- "Character" has costs

---

## Monthly Breakdown

| Month | Avg High | Avg Low | Precipitation | Notes |
|-------|----------|---------|---------------|-------|
| Jan | 36F | 22F | 3.4" | Coldest month |
| Feb | 39F | 24F | 3.3" | Still bitter |
| Mar | 46F | 31F | 4.2" | Can still snow |
| Apr | 56F | 41F | 3.7" | Rain, variable |
| May | 67F | 50F | 3.5" | Finally warm |
| Jun | 76F | 60F | 3.7" | Summer begins |
| Jul | 82F | 66F | 3.4" | Hot, humid |
| Aug | 80F | 65F | 3.4" | Still summer |
| Sep | 73F | 57F | 3.4" | Pleasant |
| Oct | 62F | 47F | 3.9" | Foliage |
| Nov | 52F | 38F | 3.9" | Getting cold |
| Dec | 42F | 28F | 3.8" | Winter arrives |

---

## Best Times to Visit

| Purpose | Best Months | Why |
|---------|-------------|-----|
| General tourism | Sep-Oct | Best weather, foliage |
| Budget travel | Jan-Feb | Lowest hotel prices |
| Baseball | Apr-Sep | Red Sox season |
| Outdoor activities | May-Jun, Sep-Oct | Comfortable temps |
| Holidays | Dec | Decorations, events |

**Avoid if possible:**
- January-February (brutal cold)
- August (humid, many locals away)
- September 1st (move-in chaos)
