# Business & Legal — Boston

## Starting a Business

### Entity Types

| Type | Best For | Liability | Taxes |
|------|----------|-----------|-------|
| Sole Proprietorship | Freelancers | Personal | Pass-through |
| LLC | Small business | Limited | Pass-through |
| S-Corp | Growing business | Limited | Pass-through |
| C-Corp | VC-backed startup | Limited | Corporate + personal |

### Massachusetts Registration

**For LLC:**
1. Choose name (check availability: sec.state.ma.us)
2. File Certificate of Organization ($500)
3. Create Operating Agreement
4. Get EIN from IRS
5. Register with DOR (Department of Revenue)

**For Corporation:**
1. Choose name
2. File Articles of Organization ($275)
3. Create Bylaws
4. Issue stock
5. Get EIN
6. Register with DOR

### Registered Agent
Massachusetts requires a registered agent with physical address in state. Can be:
- You (if you have MA address)
- Lawyer
- Registered agent service ($100-300/year)

---

## Licenses & Permits

### Business Certificate (DBA)
If operating under name different from legal name:
- File with city/town clerk
- $40-65 depending on municipality
- Required for bank accounts

### Professional Licenses
Some professions require state licenses:
- Attorneys (MA Bar)
- CPAs (Board of Accountancy)
- Engineers (Professional Engineers)
- Healthcare (various boards)
- Contractors (Home Improvement)
- Real estate (Division of Professional Licensure)

### Industry-Specific
- **Food service**: Health permit, food handler certifications
- **Alcohol**: Complex licensing through ABCC
- **Cannabis**: Heavily regulated, state license required
- **Retail**: Sales tax certificate

---

## Taxes

### Business Taxes
| Tax | Rate | Notes |
|-----|------|-------|
| Corporate excise | 8% of net income | C-corps |
| Pass-through | 5% individual | LLC/S-corp (on owner's return) |
| Sales tax | 6.25% | Most goods |
| Meals tax | 7% | Restaurant food |

### Filing Requirements
- Annual report (corporations/LLCs): ~$500
- Sales tax: Monthly or quarterly
- Withholding: If you have employees
- Estimated taxes: Quarterly

### Tax Advantages
- No sales tax on clothing under $175
- No sales tax on groceries
- R&D tax credits available
- Life sciences tax incentives

---

## Banking for Business

### Business Accounts
Most banks offer business accounts:
- Bank of America
- Citizens Bank
- Eastern Bank (local, good for small business)
- Santander

### Requirements
- EIN
- Formation documents
- Operating agreement (LLC)
- Identification

### Startup Banking
- Mercury, Brex, Relay (online)
- Silicon Valley Bank (Boston office)
- First Republic (now part of JPMorgan)

---

## Legal Services

### Finding a Lawyer
- Massachusetts Bar Referral: massbbo.org
- Mintz Levin (big firm, startup practice)
- Foley Hoag (big firm)
- Gesmer Updegrove (startup focused)
- Cooley (national, Boston office)

### Startup Legal
Standard startup legal work:
- Incorporation: $2,000-5,000
- Seed financing: $10,000-25,000
- Employment docs: $3,000-8,000

**Deferred fee arrangements** common for VC-backed startups.

### Free/Low-Cost Options
- Volunteer Lawyers for the Arts
- Law school clinics
- LegalZoom/Clerky (basic formation)

---

## Hiring

### Employment Law Basics
Massachusetts is employee-friendly:
- **At-will employment**: Yes, but with exceptions
- **Non-competes**: Heavily restricted (2018 law)
- **Minimum wage**: $15/hour (2023)
- **Paid family leave**: Required (PFML program)
- **Sick time**: Required (40 hours/year)

### Non-Compete Rules (Important)
Since 2018, Massachusetts restricts non-competes:
- Maximum 12 months
- Must provide "garden leave" (pay during restriction)
- Cannot apply to hourly workers, students, under-18
- Must be signed at job offer (not after start)

### Payroll
If you have employees:
- State withholding
- PFML contributions
- Unemployment insurance
- Workers comp insurance

### Common Payroll Services
- Gusto (startup-friendly)
- Justworks (PEO model)
- ADP (traditional)
- Paychex (traditional)

---

## Real Estate

### Office Space

| Type | Cost (per SF/year) | Best For |
|------|-------------------|----------|
| WeWork/coworking | $500-800 | 1-10 people |
| Class A (Kendall) | $80-120 | Established companies |
| Class B (Cambridge) | $50-70 | Growing companies |
| Suburbs (128) | $30-50 | Cost-conscious |

### Coworking Options
| Space | Location | Vibe |
|-------|----------|------|
| CIC | Cambridge, Boston | Startup ecosystem |
| WeWork | Multiple | Corporate coworking |
| Workbar | Multiple | Local chain |
| Industrious | Multiple | Premium |

### Lab Space
Biotech needs lab space (very different from office):
- LabCentral (Cambridge): Startup lab
- BioLabs (Cambridge): Incubator
- Rent: $100-200/SF/year (much higher than office)

---

## Funding

### Venture Capital
Boston/Cambridge VC ecosystem:
| Firm | Stage | Focus |
|------|-------|-------|
| General Catalyst | All | Generalist |
| Battery Ventures | Growth | Tech |
| Bessemer | All | Generalist |
| Flagship Pioneering | Early | Biotech |
| Polaris Partners | Early | Tech, healthcare |
| F-Prime | All | Biotech, tech |

### Angel Groups
- Launchpad Venture Group
- Golden Seeds (women founders)
- Hub Angels
- MIT Angels

### Grants
- SBIR/STTR (federal)
- Mass Life Sciences Center
- MassTech Collaborative
- MassVentures (state fund)

---

## Industry Associations

### General Business
- Greater Boston Chamber of Commerce
- Cambridge Chamber of Commerce
- Mass Technology Leadership Council

### Tech/Startup
- MassChallenge
- Cambridge Innovation Center
- Startup Boston

### Biotech
- Massachusetts Biotechnology Council (MassBio)
- Boston Biotech Working Group

---

## Networking

### Events
- Cambridge Innovation Center events
- Boston New Tech
- Startup Boston Week
- Industry conferences

### Key Locations
- CIC (networking hub)
- Kendall Square (informal networking)
- Venture Cafe (Thursday gatherings)

---

## Boston Advantages

### For Business
- **Talent**: Harvard, MIT, many universities
- **Healthcare**: Hospital partnerships
- **Biotech ecosystem**: Unmatched
- **Investor base**: Strong VC presence
- **Quality of life**: Attracts talent

### Challenges
- **Cost**: Expensive city
- **Weather**: Winters can be hard
- **Competition for talent**: High demand
- **Traffic**: Commuting difficult
