---
name: Boston
slug: boston
version: 1.0.0
homepage: https://clawic.com/skills/boston
description: Navigate Boston as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, transport, costs, and local insights.
metadata: {"clawdbot":{"emoji":"🦞","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Boston for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Downtown, Back Bay, Beacon Hill | `neighborhoods-downtown.md` |
| Cambridge, Somerville | `neighborhoods-cambridge.md` |
| South End, Jamaica Plain, Roxbury | `neighborhoods-south.md` |
| North End, Charlestown, East Boston | `neighborhoods-north.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Seafood & New England classics | `food-seafood.md` |
| North End Italian & ethnic | `food-ethnic.md` |
| Best areas for dining | `food-areas.md` |
| Dietary, alcohol, practical | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (T, buses, bikes) | `transport.md` |
| Cost of living | `cost.md` |
| Safety | `safety.md` |
| Weather & seasonal tips | `climate.md` |
| Local services (banking, utilities) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business & legal | `business.md` |
| Startups & funding | `startup.md` |
| Visas & work permits | `visas.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & hospitals | `healthcare.md` |
| Universities & education | `education.md` |
| Expat & social life | `lifestyle.md` |
| Driving & car ownership | `driving.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. Education Capital Reality
Boston metro has 50+ colleges and universities with ~250,000 students:
- **Harvard** (Cambridge): World's top university, drives local prestige
- **MIT** (Cambridge): Tech and engineering powerhouse, Kendall Square hub
- **Boston University**: Large urban campus, Comm Ave corridor
- **Northeastern**: Co-op program leader, Fenway area
- **Tufts** (Medford/Somerville): Research university, Davis Square access
- **Boston College** (Chestnut Hill): Catholic institution, Green Line end
- **Berklee**: World's largest music college, Back Bay

Student calendar affects everything: September move-in chaos, May exodus, summer quiet.
See `education.md` for complete university guide.

### 3. Weather Reality
Boston has true four seasons with extremes:
- **Winter (Dec-Mar)**: 20-35F, snow common, wind chill brutal
- **Spring (Apr-May)**: 45-65F, unpredictable, can snow in April
- **Summer (Jun-Aug)**: 75-90F, humid, beach weather
- **Fall (Sep-Nov)**: 50-70F, best weather, foliage season

**Winter survival**: Proper coat, waterproof boots, layers. The T runs slower in snow.
See `climate.md` for monthly breakdown and survival strategies.

### 4. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (Back Bay) | $2,800-3,800/mo |
| 1BR rent (Cambridge) | $2,600-3,500/mo |
| 1BR rent (Somerville) | $2,200-2,900/mo |
| Senior SWE salary | $180K-260K total comp |
| MBTA monthly pass | $90 (CharlieCard) |
| Lobster roll | $25-35 |
| Student budget | $1,800-2,500/month |

### 5. Cost Reality
Boston is 3rd most expensive US metro after NYC and SF:
- **Housing**: 40-50% of budget typical
- **September surge**: Rents spike 10-20% for student turnover
- **Broker fees**: One month rent (unique to Boston market)
- **Heating costs**: Gas heat adds $100-200/month in winter
- **Parking**: $200-400/month, street parking near impossible

### 6. Transit Overview
The MBTA ("The T") is America's oldest subway:
- **Four lines**: Red, Orange, Blue, Green (Green is actually trolley)
- **Coverage**: Good in Boston/Cambridge core, limited suburbs
- **Reliability**: Improving but delays common, especially winter
- **CharlieCard**: Tap card, lower fares than cash
- **Commuter Rail**: Suburbs and Providence/Worcester

Most residents don't need cars if living near T. See `transport.md`.

### 7. Tech Hub Context
Greater Boston is a top-5 US tech hub:
- **Kendall Square** (Cambridge): Biotech capital, Google, Microsoft, startups
- **Seaport**: New innovation district, Amazon, Reebok HQ
- **Route 128**: Traditional tech corridor (now less trendy)
- **Harvard/MIT pipeline**: Constant talent flow

Biotech and healthcare tech dominate. Pure software less common than Bay Area.
See `tech.md` for industry details.

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | South End, Cambridge (Central/Harvard), Somerville |
| Families | Brookline, Newton, Arlington, Lexington |
| Students | Allston, Brighton, Fenway, Medford |
| Budget-conscious | Dorchester, East Boston, Malden, Quincy |
| Tech workers | Kendall Square, Seaport, Central Cambridge |
| Walkability seekers | Back Bay, Beacon Hill, South End |

## Healthcare Hub Context

Boston has world-class healthcare and medical research:
- **Mass General Hospital**: Top-ranked US hospital, Harvard-affiliated
- **Brigham and Women's**: Research powerhouse, also Harvard
- **Dana-Farber Cancer Institute**: World's leading cancer research
- **Boston Children's**: #1 pediatric hospital in US
- **Beth Israel Deaconess**: Major teaching hospital

Healthcare jobs represent ~20% of Boston employment.
Medical tourism brings international patients year-round.
See `healthcare.md` for patient and professional guidance.

## Boston-Specific Traps

- **September 1st madness** — 65% of leases turn over. Streets packed with moving trucks. Book movers in June.
- **Broker fees** — Most rentals require one month fee to broker. Budget accordingly.
- **Winter underestimation** — Wind chill makes 20F feel like 0F. Proper gear essential.
- **The T reliability** — Allow 15+ min buffer for appointments. Track delays on MBTA app.
- **Parking nightmares** — Street parking is permit-only by neighborhood. Snow emergencies tow instantly.
- **Snow emergency routes** — Your car WILL be towed within hours if on marked routes during storm.
- **Jaywalking culture** — Bostonians cross anywhere, but tourists get ticketed occasionally.
- **Cash-only places** — Some iconic spots (Regina Pizzeria, Santarpio's) cash only.
- **Sunday alcohol** — Liquor stores open at noon on Sundays.
- **Happy hour ban** — Massachusetts banned happy hour drink specials in 1984. Still illegal.
- **Rotary confusion** — Traffic circles ("rotaries") have unintuitive right-of-way rules.
- **Last call at 2am** — All bars close at 2am. The T stops around 12:30am.
- **College sports indifference** — Boston is pro sports obsessed; college games are afterthought.
- **Red Sox ticket myth** — Games aren't always sold out since 2013. Check day-of availability.

## Sports Culture Warning

Boston has the most intense sports culture in America:
- **Red Sox**: Fenway Park (1912) is sacred ground. Rivalry with Yankees is real.
- **Patriots**: Six Super Bowls. Now rebuilding post-Brady but still religion.
- **Celtics**: 18 NBA titles. TD Garden gets loud.
- **Bruins**: Hockey matters here. Original Six franchise.

Game days affect traffic, restaurant availability, and general city mood.
Don't wear Yankees gear unless you want commentary.
See `lifestyle.md` for sports calendar and culture.

## Historical Context

Boston is America's most historically significant city:
- **Freedom Trail**: 2.5 miles connecting 16 historic sites
- **Harvard** (1636): America's oldest university
- **Boston Common** (1634): America's oldest public park
- **Fenway Park** (1912): America's oldest baseball stadium
- **The T** (1897): America's first subway

History is everywhere but doesn't dominate daily life. Most locals rarely walk the Freedom Trail.
See `visitor-attractions.md` for historical sites worth visiting.

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `dubai` - city guide reference
- `travel` - general travel planning

## Feedback

- If useful: `clawhub star boston`
- Stay updated: `clawhub sync`
