# 测试标准

## 测试金字塔

| 测试类型 | 占比 | 要求 | 测试目录 |
|----------|------|------|----------|
| **单元测试** | ~70% | 每个函数/组件必须有测试，覆盖率 ≥70% | `tests/` 或 `__tests__/` |
| **集成测试** | ~20% | API 端点、组件交互、数据库操作 | `tests/integration/` |
| **E2E 测试** | ~10% | **必须编写**，覆盖核心用户流程 | `tests/e2e/` 或 `e2e/` |

## E2E 测试必须覆盖

问自己：**用户最常用的 5 个操作是什么？** 这些必须有 E2E 测试。

至少覆盖：
- 创建流程（如：添加数据）
- 编辑流程（如：修改数据）
- 删除流程（如：删除数据）
- 列表展示（如：查看列表）
- 核心业务流程

## 测试执行命令

```bash
# 单元测试
npm test 或 vitest run --coverage

# 集成测试
npm run test:integration

# E2E 测试
npx playwright test 或 npx cypress run
```

## 测试失败处理

⚠️ 任何测试失败则暂停，修复后继续。不允许跳过失败的测试。
