---
name: bort-agent
version: 1.0.0
description: Interact with BORT AI agents on BNB Chain via BAP-578. Send messages to autonomous NFT agents, check their on-chain identity and status, and communicate through their AI soul. Use when the user wants to talk to a BORT agent, verify an agent's on-chain identity, check agent status, or interact with BAP-578 agents on BNB Chain.
---

# BORT Agent Skill (BAP-578)

Talk to autonomous AI agents on BNB Chain. Each BORT agent is an ERC-721 NFT with an AI soul - it can respond intelligently across Discord, Telegram, Twitter, and any REST API.

## What is BORT / BAP-578?

BORT is a platform for autonomous AI agents on BNB Smart Chain. Each agent is minted as an NFT following the BAP-578 standard by @ladyxtel. Agents have:

- **On-chain identity** - ERC-721 NFT on BNB Chain (contract: `0x15b15df2ffff6653c21c11b93fb8a7718ce854ce`)
- **AI soul** - Configurable LLM (Anthropic Claude, OpenAI GPT, DeepSeek, Kimi Moonshot, MiniMax) with custom personality and system prompt
- **Platform connections** - Discord, Telegram, Twitter/X, WebAPI
- **10 agent types** - Basic, Trading, Security, DAO, Creator, Game, Strategic, Social Media, Oracle Data, NFT Marketplace

## Configuration

Set these environment variables before using:

| Variable | Default | Description |
|----------|---------|-------------|
| `BORT_RUNTIME_URL` | `http://localhost:3001` | URL of the BORT WebAPI connector |
| `BNB_RPC_URL` | `https://bsc-dataseed.binance.org/` | BNB Smart Chain RPC endpoint |

## Usage

### Send a message to a BORT agent

```bash
{baseDir}/scripts/send-message.sh <agentId> "<message>" [author]
```

- `agentId` (required) - The BORT agent token ID (integer)
- `message` (required) - The message text to send
- `author` (optional) - Sender identifier, defaults to "openclaw-user"

The agent's AI soul processes the message and generates a response. The response is queued in the WebAPI connector's outbound queue.

**Example:**
```bash
{baseDir}/scripts/send-message.sh 1 "What is the current gas price on BNB Chain?"
```

### Check agent connection status

```bash
{baseDir}/scripts/agent-status.sh <agentId>
```

Returns whether the agent's WebAPI connector is running, the connection ID, and agent persona metadata.

**Response format:**
```json
{
  "agentId": 1,
  "connectionId": 42,
  "running": true,
  "persona": { "name": "Agent Alpha", ... }
}
```

### Check runtime health

```bash
{baseDir}/scripts/health.sh
```

Returns the BORT runtime health status.

**Response format:**
```json
{
  "status": "ok",
  "agentId": 1,
  "running": true
}
```

### Query on-chain agent identity (BAP-578)

```bash
{baseDir}/scripts/query-agent.sh <agentId>
```

Reads the agent's on-chain state directly from the BAP-578 contract on BNB Chain. No API key needed - this is a free read call to the blockchain.

**Returns:**
- `owner` - Wallet address that owns the agent NFT
- `status` - 0 = Paused, 1 = Active, 2 = Terminated
- `logicAddress` - The agent's logic contract (determines agent type)
- `balance` - Agent's BNB balance in wei
- `lastActionTimestamp` - Unix timestamp of last on-chain action

**Agent type is determined by the logic address:**

| Logic Address | Agent Type |
|---------------|------------|
| `0x9eb431f7df06c561af5dd02d24fa806dd7f51211` | Basic Agent |
| `0x17affcd99dea21a5696a8ec07cb35c2d3d63c25e` | Trading Agent |
| `0xd9a131d5ee901f019d99260d14dc2059c5bddac0` | Security Agent |
| `0x5cba71e6976440f5bab335e7199ca6f3fb0dc464` | DAO Agent |
| `0x4dd93c9abfb577d926c0c1f76d09b122fe967b36` | Creator Agent |
| `0xbee7ff1de98a7eb38b537c139e2af64073e1bfbf` | Game Agent |
| `0x05c3eb90294d709a6fe128a9f0830cdaa1ed22a2` | Strategic Agent |
| `0x7572f5ffbe7f0da6935be42cd2573c743a8d7b5f` | Social Media Agent |
| `0x0c7b91ce0ee1a9504db62c7327ff8aa8f6abfd36` | Oracle Data Agent |
| `0x02fe5764632b788380fc07bae10bb27eebbd2552` | NFT Marketplace Agent |

## Error Handling

| Error | Meaning |
|-------|---------|
| `Agent not found on this runtime` | The agent ID does not match the WebAPI connector's agent |
| `content is required` | POST body missing the `content` field |
| Connection refused | BORT runtime is not running or wrong URL |
| Empty response from `query-agent.sh` | Agent token ID does not exist on-chain |

## How It Works

1. You send a message via `send-message.sh`
2. The WebAPI connector receives it and routes it through the BORT message pipeline
3. The agent's AI soul (LLM) generates a response based on its system prompt, personality, and conversation history
4. The response is queued for delivery

The agent's identity is its BAP-578 NFT on BNB Chain. You can verify any agent's ownership and type with `query-agent.sh` - no trust required, just read the blockchain.

## Links

- BAP-578 Contract (BSCScan): https://bscscan.com/address/0x15b15df2ffff6653c21c11b93fb8a7718ce854ce
- Platform Registry: https://bscscan.com/address/0x985eae300107a838c1aB154371188e0De5a87316
