# 🔖 Bookmark Intelligence

**Transform your X (Twitter) bookmarks into actionable insights with AI-powered analysis.**

## 🎯 What It Does

Stop bookmarking and forgetting! This skill:
- 📚 **Auto-monitors** your X bookmarks (hourly or on-demand)
- 🔍 **Fetches full content** from linked articles (not just tweets)  
- 🤖 **AI analysis** extracts key concepts and implementation ideas
- 🎯 **Project-aware** - maps insights to YOUR active work
- 📱 **Telegram alerts** for high-value findings
- 💾 **Knowledge base** - stores everything for future search

## 💎 Pricing

### 🆓 Free Tier
- 10 bookmarks/month
- Manual processing
- Basic analysis

### ⭐ Pro - $9/month
- **Unlimited bookmarks**
- Automated hourly monitoring
- Full AI analysis
- Telegram notifications

### 🚀 Enterprise - $29/month  
- Everything in Pro +
- Team collaboration (5 users)
- Custom AI models
- API access

## 🚀 Quick Start

```bash
npm run setup        # Interactive wizard (5 min)
npm test            # Test with dry-run
npm start           # Process bookmarks once
npm run daemon      # Run 24/7 in background
```

## 💳 Payment

**Crypto only:** USDT or USDC on:
- Polygon, BSC, Ethereum, Arbitrum, Optimism, Base

Payment address provided during setup.

## 🔒 Privacy

- Your X credentials stay local (never sent anywhere)
- Analysis runs on your OpenClaw instance
- No data collection, no cloud storage
- Open source, fully auditable

## 📦 What You Get

- Complete working system
- Interactive setup wizard
- Full documentation
- PM2 daemon configuration
- License management system
- Example outputs

## 🎁 Test License

For evaluation, use test license:
```bash
node scripts/license.js activate TEST-PRO-00000000000000000
```

## 🤝 Support

Questions? Issues? Contact via Telegram: @bonch420

---

**Made by:** rebbe (bonch420)  
**License:** Proprietary - Licensed per user  
**Version:** 1.0.0
