---
name: bookkeeping-basics
description: Set up and maintain basic bookkeeping for a solopreneur business. Use when tracking income and expenses, preparing for taxes, managing invoices and receipts, understanding cash flow, or generating financial reports. Covers accounting software selection, chart of accounts, expense categorization, reconciliation, and financial statements. Not professional accounting advice — consult a CPA for complex situations. Trigger on "bookkeeping", "accounting", "track expenses", "financial records", "QuickBooks", "invoicing", "receipts", "profit and loss".
---

# Bookkeeping Basics

## Overview
Bookkeeping tracks where money comes from and where it goes. Most solopreneurs hate bookkeeping, so they avoid it — then face chaos at tax time or when applying for loans. This playbook gives you a simple system: minimal time, maximum clarity. **Disclaimer: This is educational content, not professional accounting advice. Consult a CPA for complex situations.**

---

## Step 1: Choose Your Accounting Software

Don't use spreadsheets. Use accounting software. It automates most of the work and keeps you compliant.

**Software comparison:**

| Software | Best For | Pricing | Learning Curve | Features |
|---|---|---|---|---|
| **Wave** | Freelancers, very small businesses | Free (pay for payments/payroll) | Easy | Basic invoicing, expense tracking, reports |
| **QuickBooks Online** | Most solopreneurs, scaling businesses | $15-50/month | Medium | Full accounting, invoicing, tax reports, integrations |
| **FreshBooks** | Service businesses, invoicing-heavy | $17-55/month | Easy | Invoicing, time tracking, expense tracking |
| **Xero** | International businesses, contractors | $13-70/month | Medium | Full accounting, multi-currency, payroll |

**Selection guide:**
- Just starting, no revenue yet → Wave (free)
- Revenue < $50K/year → Wave or FreshBooks
- Revenue $50K-250K/year → QuickBooks Online
- International clients or contractors → Xero

**Recommendation:** Start with Wave (free). Upgrade to QuickBooks when you hit $50K revenue or need more features.

---

## Step 2: Set Up Your Chart of Accounts

A chart of accounts is a list of categories for organizing income and expenses. Most software comes with defaults — use them unless you have a specific reason to customize.

**Basic chart of accounts (solopreneur):**

### INCOME CATEGORIES:
- Sales Revenue (product/service sales)
- Consulting Revenue
- Other Income (interest, refunds, etc.)

### EXPENSE CATEGORIES:
- **Cost of Goods Sold (COGS):** Direct costs to deliver your product/service (if applicable)
- **Operating Expenses:**
  - Advertising / Marketing
  - Software / Tools / Subscriptions
  - Contractor Payments
  - Office Supplies
  - Professional Services (lawyer, accountant)
  - Travel / Meals (business-related)
  - Insurance
  - Bank Fees / Merchant Fees
  - Home Office Deduction (if applicable)
  - Utilities (if home office)
  - Other Expenses

**Rule:** Don't over-categorize. 10-15 categories max. Too many creates confusion. Too few makes tax prep hard.

---

## Step 3: Track Every Transaction

Every dollar in and every dollar out must be recorded. No exceptions.

**Income tracking:**
- Record every payment received (invoice, client name, date, amount)
- Use invoicing software (Wave, QuickBooks, FreshBooks) to generate invoices and track payments automatically
- For cash payments, create manual invoices or receipts

**Expense tracking:**
- Connect your business bank account and credit card to your accounting software (auto-imports transactions)
- Categorize each expense when it imports (software learns patterns over time)
- Save receipts (digital copies, not paper — use apps like Expensify or Shoeboxed, or just your phone camera)

**Receipt rules (IRS):**
- Keep receipts for expenses > $75
- Keep receipts for ALL meals, travel, and entertainment (even under $75)
- Store digitally (cloud storage, accounting software, or receipt app)
- Retain for 7 years (IRS audit window)

**Bank/credit card reconciliation (monthly):**
Reconciliation = matching your accounting software records to your actual bank statements.

**How to reconcile (15-30 min/month):**
1. Download bank statement for the month
2. Open your accounting software's reconciliation tool
3. Check off each transaction in software that matches the bank statement
4. Investigate any mismatches (missing transactions, duplicate entries)
5. Mark reconciliation as complete

**Why this matters:** Catches errors, fraud, or missed transactions. If software balance ≠ bank balance, something's wrong.

---

## Step 4: Separate Business and Personal Finances

NEVER mix business and personal money. It's the #1 bookkeeping mistake.

**Why separation matters:**
- Simplifies bookkeeping (business account = business transactions only)
- Protects your LLC liability protection (mixing funds pierces the corporate veil)
- Makes taxes easier (clear business expenses vs personal)
- Looks professional to clients, lenders, investors

**How to separate:**
- [ ] Open a business bank account (use your EIN, not SSN)
- [ ] Get a business credit card
- [ ] Pay yourself a salary or owner's draw (transfer from business to personal account on a schedule)
- [ ] Pay all business expenses from business account ONLY
- [ ] Pay all personal expenses from personal account ONLY

**If you accidentally pay a personal expense from business account:**
1. Record it as "Owner's Draw" or "Personal Expense" in your bookkeeping
2. Don't try to deduct it on taxes (it's not a business expense)

---

## Step 5: Understand Basic Financial Statements

Your accounting software generates these automatically. You should review them monthly.

### Profit & Loss (P&L) / Income Statement
Shows: Revenue - Expenses = Profit (or Loss)

**What it tells you:** Are you making money? Which expense categories are highest?

**Example:**
```
Revenue:              $10,000
Expenses:
  Marketing:          $2,000
  Software:           $500
  Contractor:         $3,000
  Other:              $1,000
Total Expenses:       $6,500
Net Profit:           $3,500
```

**How to use it:**
- Compare month-over-month (are you growing?)
- Identify expense trends (is one category ballooning?)
- Calculate profit margin (Net Profit / Revenue = 35% in example above — healthy is 20-50%)

### Balance Sheet
Shows: Assets = Liabilities + Equity

**What it tells you:** What you own (assets), what you owe (liabilities), and what's left over (equity/net worth).

**Most solopreneurs can ignore this** unless applying for a loan or raising funding.

### Cash Flow Statement
Shows: Cash in - Cash out = Net cash flow

**What it tells you:** Are you running out of cash? (even profitable businesses can have cash flow problems if customers pay late)

**How to use it:**
- Track cash balance over time
- Predict cash shortages (if expenses > revenue for next 2-3 months)
- Plan for large purchases or dry spells

---

## Step 6: Prepare for Tax Time

Good bookkeeping makes tax prep fast and cheap. Bad bookkeeping means expensive CPA hours or IRS penalties.

**Tax prep checklist (do this all year, not just at tax time):**

- [ ] Categorize every transaction monthly (don't wait until December)
- [ ] Save receipts for deductible expenses
- [ ] Track mileage if you drive for business (apps: MileIQ, Everlance)
- [ ] Set aside 25-30% of revenue for taxes (transfer to separate savings account)
- [ ] Generate a P&L at year-end (December 31)
- [ ] Prepare a summary of all income and expenses by category
- [ ] Hand off to your CPA or tax software (TurboTax, TaxAct)

**Common deductible expenses (U.S.):**
- Home office (if you have dedicated workspace)
- Software and subscriptions
- Contractor payments
- Marketing and advertising
- Professional services (lawyer, accountant)
- Business travel and meals (50% of meals, 100% of travel)
- Equipment and tools
- Business insurance
- Bank and merchant fees

**Non-deductible (can't write off):**
- Personal expenses
- Commuting (home to office — but client visits are deductible)
- Clothing (unless it's a uniform or specialized work gear)
- Entertaining clients (used to be 50% deductible, now 0% as of 2021 — check current rules)

**Rule:** When in doubt, ask your CPA. Don't guess on deductions.

---

## Step 7: Monthly Bookkeeping Routine (30-60 min/month)

Consistency prevents end-of-year chaos. Do these tasks monthly:

**Monthly bookkeeping checklist:**

- [ ] **Reconcile bank and credit card accounts** (match software to statements)
- [ ] **Categorize any uncategorized transactions**
- [ ] **Review P&L** (revenue vs expenses, profit margin)
- [ ] **Send outstanding invoices** (if clients haven't paid)
- [ ] **Follow up on overdue invoices** (Net-30 past due? Send reminder)
- [ ] **Pay bills due this month** (don't miss deadlines or you'll pay late fees)
- [ ] **Set aside taxes** (transfer 25-30% of profit to tax savings account)
- [ ] **Check cash flow** (will you run out of cash in next 2-3 months? If yes, plan ahead)

**Time required:** 30 min if your bookkeeping is current. 3 hours if you've been ignoring it.

**Rule:** Do this monthly. Don't wait until tax season.

---

## Step 8: When to Hire a Bookkeeper or CPA

**DIY bookkeeping works if:**
- Revenue < $100K/year
- Simple business model (no inventory, payroll, or complex transactions)
- You can commit 1 hour/month to bookkeeping

**Hire a bookkeeper if:**
- Revenue > $100K/year
- Complex transactions (inventory, multiple revenue streams, many contractors)
- You hate bookkeeping and keep procrastinating

**Cost:** Virtual bookkeeper = $200-500/month. Worth it if it saves you 5+ hours/month.

**Hire a CPA (tax accountant) if:**
- Revenue > $50K/year (DIY taxes become risky)
- Complex tax situation (multiple LLCs, S-Corp election, international clients)
- You want to maximize deductions and minimize tax liability

**Cost:** CPA = $500-2,000/year for tax prep. More if you need year-round advice.

**Rule:** DIY bookkeeping is fine. DIY taxes past $50K revenue is risky. Hire a CPA.

---

## Bookkeeping Mistakes to Avoid
- **Not tracking expenses.** Every dollar counts at tax time. Missing receipts = higher taxes.
- **Mixing personal and business finances.** Creates a mess. Separate accounts from day one.
- **Not reconciling monthly.** Errors compound. Reconcile monthly or you'll regret it at year-end.
- **Waiting until tax season to organize.** Bookkeeping in December is painful. Do it monthly.
- **Not setting aside money for taxes.** Quarterly taxes sneak up on you. Save 25-30% of profit consistently.
- **Guessing at expense categories.** If unsure, ask a CPA. Wrong categorization = IRS audit risk.
