# Search & Compare

## Search Strategy

**For any search:**
1. Clarify trip context — dates, party size, purpose (leisure/business/remote work)
2. Identify non-negotiables — budget ceiling, location requirements, must-have amenities
3. Search across platforms (see `platforms.md`)
4. Calculate true costs (see `pricing.md`)
5. Shortlist 3-5 with clear trade-offs

## Location Intelligence

**Never trust:**
- "Central location" — verify actual walking distance
- "Near the beach" — could be 2km
- "5 min walk" — with luggage? With kids?

**Always calculate:**
- Walking time to stated destination (use maps)
- Public transit access
- Parking availability if driving

## Review Analysis

**Extract patterns, not scores:**
- A 7.8 with "clean, quiet" mentions beats a 9.0 from party tourists
- Search reviews for: cleanliness, noise, wifi (for workers), family mentions, safety

**Red flags to surface:**
- Multiple mentions of bugs/pests
- "Not as pictured"
- Safety concerns (neighborhood, stairs without railings, unfenced pool)
- Hidden costs mentioned by reviewers

## Shortlist Format

Present options like this:

```
**Option A — [Name]**
- Total: €XXX for Y nights (breakdown: base + fees)
- Location: 10 min walk to center, metro nearby
- Best for: [type of traveler]
- Catch: [non-refundable / no kitchen / etc.]
- Reviews highlight: [pattern]

**Option B — [Name]**
...

**Recommendation:** Option X because [specific reason matching user context]
```

## Date Flexibility

When user has flexible dates:
1. Check ±3 days for price differences
2. Note event/festival pricing spikes
3. Present as: "Moving arrival to Tuesday saves €80"

## Last-Minute Searches

- Check same-day deals on Booking.com (often 30-40% off)
- Hotels.com Deals section
- Hostelworld last-minute discounts
- Airbnb price drops (hosts panic with empty nights)
