# Pricing & Total Cost

## The Fee Problem

**Airbnb example:**
- Listed: €50/night
- Cleaning fee: €80
- Service fee: €45
- Tourist tax: €2/night × 5 = €10
- **Total for 5 nights: €435 (€87/night actual)**

**Always calculate true nightly rate after ALL fees.**

## Fee Types to Include

| Fee Type | Platform | Notes |
|----------|----------|-------|
| Cleaning fee | Airbnb, VRBO | Often €50-150, kills short stays |
| Service fee | Airbnb, Booking | 12-15% typically |
| Tourist/city tax | Hotels, Airbnb | €1-5/night/person, varies by city |
| Resort fee | US hotels | $25-50/night, often hidden until checkout |
| Extra person fee | Airbnb | Per additional guest/night |
| Utility cap | Long-term rentals | "Utilities included up to €50/month" |

## Monthly Stay Pricing

**Never multiply nightly × 30.**

Most platforms offer monthly discounts:
- Airbnb: 20-50% off for 28+ nights
- Booking.com: Long-stay rates exist but less common
- Local platforms: Often 30-40% cheaper than Airbnb monthly

**Negotiation opportunity:**
Message host: "I'm interested in [dates] for [X weeks/months]. Do you offer a discount for longer stays?"

Many hosts will offer 15-30% off even if not listed.

## Price Comparison Format

Present like this:

```
Property: Ocean View Apartment
Platform comparison (5 nights, 2 guests):

| Platform     | Base  | Fees  | Total | Per Night |
|--------------|-------|-------|-------|-----------|
| Airbnb       | €250  | €125  | €375  | €75       |
| Booking.com  | €280  | €35   | €315  | €63       |
| Direct site  | €260  | €20   | €280  | €56       |

→ Recommendation: Book direct, saves €95
```

## Budget Thresholds by Region

Help users understand "cheap" in context:

| Region | Budget/night | Mid-range/night |
|--------|--------------|-----------------|
| Southeast Asia | <€15 | €15-40 |
| Eastern Europe | <€25 | €25-60 |
| Western Europe | <€40 | €40-100 |
| US major cities | <€50 | €50-150 |
| Latin America | <€20 | €20-50 |

## Red Flags in Pricing

- Price dropped 50%+ suddenly → check recent reviews
- "Too good to be true" in expensive city → likely scam or bait-and-switch
- No cleaning fee on Airbnb → usually small/simple place or included in high nightly
- Resort fee not shown until checkout (US hotels) → always ask upfront
