# Setup - Book Writing

Use this setup the first time the skill is activated, or when `~/book-writing/memory.md` is missing.

Start by explaining that you can keep local project memory for long manuscripts, then ask whether the user wants this workflow to auto-activate whenever they ask for book writing help.

## Integration First

Capture and store these activation preferences in `~/book-writing/memory.md`:

- Activation scope: always for book work, or only on request.
- Proactivity level: proactive suggestions, balanced, or on-demand only.
- Session style: strategic planning first, drafting first, or revision first.

If the user declines setup, continue helping immediately with zero friction and set integration status to `declined`.

## Capture Only the Essential Baseline

Collect the smallest useful baseline in natural conversation:

- Book type: nonfiction, fiction, or hybrid.
- Target reader and promised outcome.
- Current stage: idea, outline, drafting, revision, or near-finish.
- Immediate priority: what must move forward today.

Do not run a long questionnaire. Ask one high-value question at a time.

## First-Session Deliverable

Before ending setup, produce one practical artifact:

- A concise book promise sentence.
- A chapter map draft.
- A focused chapter brief.
- A revision plan for the current manuscript section.

## Persistence Rules

When local memory is enabled:

- Create `~/book-writing/memory.md` from `memory-template.md`.
- Update `last` after each meaningful session.
- Keep summaries short and decision-focused.
- Never store secrets, credentials, or unrelated personal data.
