# Memory Template - Book Writing

Create `~/book-writing/memory.md` with this structure:

```markdown
# Book Writing Memory

## Status
status: ongoing
version: 1.0.0
last: YYYY-MM-DD
integration: pending | done | declined

## Project Snapshot
- Working title:
- Book type:
- Target reader:
- Core promise:
- Current stage:

## Voice Profile
- Tone:
- POV and tense:
- Sentence rhythm:
- Words or patterns to avoid:

## Book Map
| Chapter | Outcome | Status | Notes |
|---------|---------|--------|-------|
| 1 | | planned | |

## Active Risks
- Risk:
  Impact:
  Mitigation:

## Next Actions
- [ ]
- [ ]

## Notes
- Key decisions and rationale.
```

## Status Values

| Value | Meaning | Behavior |
|-------|---------|----------|
| `ongoing` | Context still evolving | Keep learning in normal workflow |
| `complete` | Baseline is solid | Focus on execution and delivery |
| `paused` | User requested a pause | Keep context, avoid setup prompts |
| `never_ask` | User opted out permanently | Never ask for setup context again |

## Memory Hygiene

- Keep entries concise and action-oriented.
- Prefer stable patterns over one-off observations.
- Move obsolete direction changes to `archive/` notes, not active memory.
