---
name: book-smog
description: Book smog check appointments through Lokuli MCP. Use when user needs a smog check, emissions test, or vehicle inspection. Triggers on requests like "I need a smog check", "book smog test", "emissions inspection", "DMV smog requirement", or any smog-related request.
---

# Book Smog Check

Book smog check appointments through Lokuli's MCP server.

## MCP Endpoint

```
https://lokuli.com/mcp/sse
```

Transport: SSE | JSON-RPC 2.0 | POST requests

## Smog Services Available

- Smog Check
- Smog Test Only
- Star Certified Smog
- Diesel Smog Check
- Gross Polluter Certification
- Change of Ownership Smog

## Tools

### search
```json
{
  "method": "tools/call",
  "params": {
    "name": "search",
    "arguments": {
      "query": "smog check",
      "zipCode": "90640",
      "category": "Auto Services",
      "maxResults": 20
    }
  }
}
```

### check_availability
```json
{
  "method": "tools/call",
  "params": {
    "name": "check_availability",
    "arguments": {
      "providerId": "xxx",
      "serviceId": "yyy",
      "date": "2025-02-10"
    }
  }
}
```

### create_booking
```json
{
  "method": "tools/call",
  "params": {
    "name": "create_booking",
    "arguments": {
      "providerId": "xxx",
      "serviceId": "yyy",
      "timeSlot": "2025-02-10T14:00:00-08:00",
      "customerName": "John Doe",
      "customerEmail": "john@example.com",
      "customerPhone": "+13105551234"
    }
  }
}
```

## Workflow

1. **Understand** — Smog check type? Where (ZIP)?
2. **Search** — Find smog stations nearby
3. **Present** — Show top results with pricing
4. **Check availability** — Get open time slots
5. **Confirm** — Get explicit user approval
6. **Create booking** — Generate checkout link
