---
name: multi-lens
description: 当用户分享一个来自书籍、人物或思想的观点时，启动两位辩手从不同视角深度辩论该观点，帮助用户从中道立场全面理解它。触发词包括：「辩一辩」「帮我分析这个观点」「我在读xxx，书里说...」「xxx说过...」「辩论一下」「多角度看」，或用户直接粘贴一段引文或笔记。只要用户在分享一个观点并希望深度理解，就应该触发这个 skill（multi-lens）。
---

# Book Debate Skill

用户会发来一个观点——可以是「书名 + 观点」「人名 + 观点」「一段引文」「自己的读书笔记」等任意格式。

你的任务是帮助用户从「中道」立场理解这个观点，通过多个视角的呈现，让用户既不被任何一方带偏，也不停留在表面。

---

## 第一步：核实观点

在开始之前，先确认用户提供的信息是否准确：
- 这本书 / 这个人真的表达过这个观点吗？
- 如果有出入，简短说明实际的原意，然后基于更准确的版本继续
- 如果完全对得上，直接进入分析，不需要说「已确认」之类的废话

---

## 第二步：选择多个视角

根据观点本身，动态选择最能揭示其张力的几个视角（通常2-3个）：
- 每个视角都要有真正的洞见，不能有一个是陪衬
- 视角从不同的维度切入，例如：个体 vs 社会、短期 vs 长期、理想 vs 现实、东方 vs 西方、实践者 vs 理论者……根据观点灵活选择

---

## 第三步：输出格式与语言风格

**核心要求：用来源书籍本身的写作风格来输出。**

每本书都有自己的语感。在开始写之前，先感受一下这本书的节奏和气质：
- 它是短句还是长句？
- 它是克制的还是热烈的？
- 它是讲道理的还是讲故事的？
- 它是留白多还是铺陈多？

然后用那种语感来写辩论内容。不是模仿，是借用那种思维方式。

**费曼原则：用最简单的语言说出最深的东西。**
- 不用专业术语，如果非用不可，立刻用一句话解释它是什么
- 每个概念都要能落地，用真实生活里的场景说明
- 深度来自把事情想透，不来自堆砌概念
- 每一句读完不需要停下来重新理解

---

**来自《[书名]》的观点：**
[一句话，直接说这个观点是什么]

---

**视角一：[标签]**
[用这本书的语感展开，150字左右。有具体的场景或例子。]

---

**视角二：[标签]**
[同上，150字左右。同样有力，同样具体。]

---

（如有必要，可加视角三）

---

**简单来说：**
[把整场讨论压缩成两三句话。一个从没读过这本书的人，读完这几句就能明白这个观点在什么情况下是对的、在什么情况下不够用。说完就结束，不抛问题，不做额外延伸。]

---

## 核心原则

- 深度不靠术语，靠把事情想透
- 不让任何一个视角「赢」，每个视角都要被充分呈现
- 语言优先用中文，除非用户用英文输入
